/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.memory.management;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.memory.provider.ByteBufferPoolConfiguration;
import org.mule.runtime.api.memory.provider.ByteBufferProvider;
import org.mule.runtime.api.memory.provider.type.ByteBufferType;
import org.mule.runtime.api.profiling.ProfilingService;
import org.mule.runtime.internal.memory.bytebuffer.ByteBufferProviderBuilder;
import org.mule.runtime.internal.memory.management.ProfiledMemoryManagementService;
import org.mule.runtime.internal.memory.profiling.NoOpMemoryProfilingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMemoryManagementService
implements ProfiledMemoryManagementService {
    private static final DefaultMemoryManagementService INSTANCE = new DefaultMemoryManagementService();
    static Logger LOGGER = LoggerFactory.getLogger(DefaultMemoryManagementService.class);
    private final Map<String, ByteBufferProvider<ByteBuffer>> byteBufferProviders;
    private final Map<String, Long> byteBufferProvidersUsageCount;
    private ProfilingService profilingService = NoOpMemoryProfilingService.getNoOpMemoryProfilingService();

    public static DefaultMemoryManagementService getInstance() {
        return INSTANCE;
    }

    public static DefaultMemoryManagementService newDefaultMemoryManagementService() {
        return new DefaultMemoryManagementService();
    }

    private DefaultMemoryManagementService() {
        this(new HashMap<String, ByteBufferProvider<ByteBuffer>>(), new HashMap<String, Long>());
    }

    DefaultMemoryManagementService(Map<String, ByteBufferProvider<ByteBuffer>> byteBufferProviders, Map<String, Long> byteBufferProvidersCount) {
        this.byteBufferProviders = byteBufferProviders;
        this.byteBufferProvidersUsageCount = byteBufferProvidersCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Map<String, Long> map = this.byteBufferProvidersUsageCount;
        synchronized (map) {
            this.byteBufferProviders.values().forEach(ByteBufferProvider::dispose);
            this.byteBufferProviders.clear();
            this.byteBufferProvidersUsageCount.clear();
        }
    }

    @Override
    public void initialise() throws InitialisationException {
    }

    @Override
    public synchronized ByteBufferProvider<ByteBuffer> getByteBufferProvider(String name, ByteBufferType byteBufferType, ByteBufferPoolConfiguration poolConfiguration) {
        return this.doGetByteBufferProvider(name, byteBufferType, poolConfiguration);
    }

    @Override
    public ByteBufferProvider<ByteBuffer> getByteBufferProvider(String name, ByteBufferType byteBufferType) {
        return this.doGetByteBufferProvider(name, byteBufferType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBufferProvider<ByteBuffer> doGetByteBufferProvider(String name, ByteBufferType byteBufferType, ByteBufferPoolConfiguration poolConfiguration) {
        if (name == null) {
            throw new IllegalArgumentException("Byte buffer provider name cannot be null.");
        }
        Map<String, Long> map = this.byteBufferProvidersUsageCount;
        synchronized (map) {
            ByteBufferProvider byteBufferProvider = this.byteBufferProviders.computeIfAbsent(name, thisName -> ByteBufferProviderBuilder.buildByteBufferProviderFrom(byteBufferType).withName(name).withPoolConfiguration(poolConfiguration).withProfilingService(this.profilingService).build());
            this.byteBufferProvidersUsageCount.putIfAbsent(name, 0L);
            this.byteBufferProvidersUsageCount.computeIfPresent(name, (key, val) -> val + 1L);
            return byteBufferProvider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposeByteBufferProvider(String name) {
        Map<String, Long> map = this.byteBufferProvidersUsageCount;
        synchronized (map) {
            Long count = this.byteBufferProvidersUsageCount.get(name);
            if (count != null) {
                this.disposeOrReduceUsageCount(name, count);
            } else {
                LOGGER.warn("Unable to dispose not present ByteBufferProvider '{}'", (Object)name);
            }
        }
    }

    private void disposeOrReduceUsageCount(String name, Long count) {
        if (count == 1L) {
            ByteBufferProvider<ByteBuffer> byteBufferProvider = this.byteBufferProviders.get(name);
            byteBufferProvider.dispose();
            this.byteBufferProviders.remove(name);
            this.byteBufferProvidersUsageCount.remove(name);
        } else {
            this.byteBufferProvidersUsageCount.put(name, this.byteBufferProvidersUsageCount.get(name) - 1L);
        }
    }

    @Override
    public void setProfilingService(ProfilingService profilingService) {
        this.profilingService = profilingService;
    }
}

