/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.SettingsSupplierFactory;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.pom.parser.api.MavenPomParser;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleDeployableModel;
import org.mule.runtime.api.deployment.meta.MuleDomainModel;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.activation.api.ArtifactActivationException;
import org.mule.runtime.module.artifact.activation.api.deployable.ArtifactModelResolver;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.activation.api.descriptor.MuleConfigurationsFilter;
import org.mule.runtime.module.artifact.activation.internal.maven.AbstractMavenDeployableProjectModelBuilder;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;

public class MavenDeployableProjectModelBuilder
extends AbstractMavenDeployableProjectModelBuilder {
    private static final String DEFAULT_PACKAGE_EXPORT = "";
    private static final String JAVA_EXTENSION = "java";
    private static final String PACKAGE_SEPARATOR = ".";
    private static final String CLASS_PATH_SEPARATOR = "/";
    private static final String DEFAULT_SOURCES_DIRECTORY = "src/main";
    private static final String DEFAULT_SOURCES_JAVA_DIRECTORY = "/java";
    private static final String DEFAULT_RESOURCES_DIRECTORY = "/resources";
    private static final String DEFAULT_MULE_DIRECTORY = "/mule";
    private static final String DEFAULT_TEST_RESOURCES_DIRECTORY = "/test/resources";
    private final List<Path> resourcesPath = new ArrayList<Path>();
    private final boolean exportAllResourcesAndPackagesIfEmptyLoaderDescriptor;
    private final boolean includeTestDependencies;
    private final MuleConfigurationsFilter muleConfigurationsFilter = MuleConfigurationsFilter.defaultMuleConfigurationsFilter();

    public MavenDeployableProjectModelBuilder(File projectFolder, MavenConfiguration mavenConfiguration, boolean exportAllResourcesAndPackagesIfEmptyLoaderDescriptor, boolean includeTestDependencies) {
        super(mavenConfiguration, projectFolder);
        this.exportAllResourcesAndPackagesIfEmptyLoaderDescriptor = exportAllResourcesAndPackagesIfEmptyLoaderDescriptor;
        this.includeTestDependencies = includeTestDependencies;
    }

    public MavenDeployableProjectModelBuilder(File projectFolder, boolean exportAllResourcesAndPackagesIfEmptyLoaderDescriptor) {
        this(projectFolder, MavenDeployableProjectModelBuilder.getDefaultMavenConfiguration(), exportAllResourcesAndPackagesIfEmptyLoaderDescriptor, false);
    }

    public MavenDeployableProjectModelBuilder(File projectFolder, boolean exportAllResourcesAndPackagesIfEmptyLoaderDescriptor, boolean includeTestDependencies) {
        this(projectFolder, MavenDeployableProjectModelBuilder.getDefaultMavenConfiguration(), exportAllResourcesAndPackagesIfEmptyLoaderDescriptor, includeTestDependencies);
    }

    public MavenDeployableProjectModelBuilder(File projectFolder) {
        this(projectFolder, MavenDeployableProjectModelBuilder.getDefaultMavenConfiguration(), false, false);
    }

    protected static MavenConfiguration getDefaultMavenConfiguration() {
        MavenClientProvider mavenClientProvider = MavenClientProvider.discoverProvider(MavenDeployableProjectModelBuilder.class.getClassLoader());
        Supplier<File> localMavenRepository = mavenClientProvider.getLocalRepositorySuppliers().environmentMavenRepositorySupplier();
        SettingsSupplierFactory settingsSupplierFactory = mavenClientProvider.getSettingsSupplierFactory();
        Optional<File> globalSettings = settingsSupplierFactory.environmentGlobalSettingsSupplier();
        Optional<File> userSettings = settingsSupplierFactory.environmentUserSettingsSupplier();
        Optional<File> settingsSecurity = settingsSupplierFactory.environmentSettingsSecuritySupplier();
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = MavenConfiguration.newMavenConfigurationBuilder().forcePolicyUpdateNever(true).localMavenRepositoryLocation(localMavenRepository.get());
        globalSettings.ifPresent(mavenConfigurationBuilder::globalSettingsLocation);
        userSettings.ifPresent(mavenConfigurationBuilder::userSettingsLocation);
        settingsSecurity.ifPresent(mavenConfigurationBuilder::settingsSecurityLocation);
        return mavenConfigurationBuilder.build();
    }

    @Override
    protected DeployableProjectModel doBuild(MavenPomParser parser, ArtifactCoordinates deployableArtifactCoordinates) {
        try {
            List<String> packages = this.getAvailablePackages(parser);
            List<String> muleResources = this.getAvailableMuleResources(parser);
            List<String> nonMuleResources = this.getAvailableNonMuleResources(parser);
            List<String> allResources = Stream.concat(muleResources.stream(), nonMuleResources.stream()).collect(Collectors.toList());
            Set<String> muleConfigs = this.getConfigs(this.getMuleResourcesDirectory(parser), muleResources);
            return new DeployableProjectModel(packages, allResources, this.resourcesPath, this.buildBundleDescriptor(deployableArtifactCoordinates), this.getDeployableModelResolver(deployableArtifactCoordinates, allResources, muleConfigs, packages), this.projectFolder, this.deployableBundleDependencies, this.sharedDeployableBundleDescriptors, this.additionalPluginDependencies);
        }
        catch (IOException e) {
            throw new ArtifactActivationException(I18nMessageFactory.createStaticMessage("Couldn't search exported packages and resources"), (Throwable)e);
        }
    }

    private Supplier<MuleDeployableModel> getDeployableModelResolver(ArtifactCoordinates deployableArtifactCoordinates, List<String> allResources, Set<String> muleConfigs, List<String> packages) {
        if (deployableArtifactCoordinates.getClassifier().equals("mule-application")) {
            return () -> {
                MuleApplicationModel applicationModel = ArtifactModelResolver.applicationModelResolver().resolve(this.projectFolder);
                if (this.shouldEditDeployableModel(applicationModel)) {
                    applicationModel = this.buildApplicationModel(applicationModel, allResources, muleConfigs, packages);
                }
                return applicationModel;
            };
        }
        if (deployableArtifactCoordinates.getClassifier().equals("mule-domain")) {
            return () -> {
                MuleDomainModel domainModel = ArtifactModelResolver.domainModelResolver().resolve(this.projectFolder);
                if (this.shouldEditDeployableModel(domainModel)) {
                    domainModel = this.buildDomainModel(domainModel, allResources, muleConfigs, packages);
                }
                return domainModel;
            };
        }
        throw new IllegalStateException("project is not a mule-application or mule-domain");
    }

    private boolean shouldEditDeployableModel(MuleDeployableModel deployableModel) {
        return this.exportAllResourcesAndPackagesIfEmptyLoaderDescriptor && deployableModel.getClassLoaderModelLoaderDescriptor() == null || this.includeTestDependencies || deployableModel.getConfigs() == null;
    }

    @Override
    protected boolean isIncludeTestDependencies() {
        return this.includeTestDependencies;
    }

    private MuleApplicationModel buildApplicationModel(MuleApplicationModel applicationModel, List<String> allResources, Set<String> muleConfigs, List<String> packages) {
        MuleApplicationModel.MuleApplicationModelBuilder builder = ((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)new MuleApplicationModel.MuleApplicationModelBuilder().setName(applicationModel.getName() != null ? applicationModel.getName() : "mule")).setMinMuleVersion(applicationModel.getMinMuleVersion())).setRequiredProduct(applicationModel.getRequiredProduct())).withClassLoaderModelDescriptorLoader(this.createClassLoaderModelDescriptorLoader(applicationModel.getClassLoaderModelLoaderDescriptor(), allResources, packages))).withBundleDescriptorLoader(applicationModel.getBundleDescriptorLoader() != null ? applicationModel.getBundleDescriptorLoader() : new MuleArtifactLoaderDescriptor("mule", Collections.emptyMap()))).setDomain(applicationModel.getDomain().orElse(null));
        builder.setConfigs((Set)(applicationModel.getConfigs() != null ? applicationModel.getConfigs() : muleConfigs));
        builder.setRedeploymentEnabled(applicationModel.isRedeploymentEnabled());
        builder.setSecureProperties((List)applicationModel.getSecureProperties());
        builder.setSupportedJavaVersions((Set)applicationModel.getSupportedJavaVersions());
        builder.setLogConfigFile(applicationModel.getLogConfigFile());
        return (MuleApplicationModel)builder.build();
    }

    private MuleDomainModel buildDomainModel(MuleDomainModel domainModel, List<String> allResources, Set<String> muleConfigs, List<String> packages) {
        MuleDomainModel.MuleDomainModelBuilder builder = (MuleDomainModel.MuleDomainModelBuilder)((MuleDomainModel.MuleDomainModelBuilder)((MuleDomainModel.MuleDomainModelBuilder)((MuleDomainModel.MuleDomainModelBuilder)((MuleDomainModel.MuleDomainModelBuilder)new MuleDomainModel.MuleDomainModelBuilder().setName(domainModel.getName() != null ? domainModel.getName() : "mule")).setMinMuleVersion(domainModel.getMinMuleVersion())).setRequiredProduct(domainModel.getRequiredProduct())).withClassLoaderModelDescriptorLoader(this.createClassLoaderModelDescriptorLoader(domainModel.getClassLoaderModelLoaderDescriptor(), allResources, packages))).withBundleDescriptorLoader(domainModel.getBundleDescriptorLoader() != null ? domainModel.getBundleDescriptorLoader() : new MuleArtifactLoaderDescriptor("mule", Collections.emptyMap()));
        builder.setConfigs((Set)(domainModel.getConfigs() != null ? domainModel.getConfigs() : muleConfigs));
        builder.setRedeploymentEnabled(domainModel.isRedeploymentEnabled());
        builder.setSecureProperties((List)domainModel.getSecureProperties());
        builder.setSupportedJavaVersions((Set)domainModel.getSupportedJavaVersions());
        builder.setLogConfigFile(domainModel.getLogConfigFile());
        return (MuleDomainModel)builder.build();
    }

    private Set<String> getConfigs(String muleResourcesDirectory, List<String> muleResources) {
        return muleResources.stream().filter(muleResource -> this.muleConfigurationsFilter.filter(this.resolveCandidateConfigsPath(muleResourcesDirectory, (String)muleResource))).collect(Collectors.toSet());
    }

    private File resolveCandidateConfigsPath(String muleResourcesDirectory, String candidateConfigFileName) {
        return Paths.get(this.projectFolder.getAbsolutePath(), new String[0]).resolve(muleResourcesDirectory).resolve(candidateConfigFileName).toFile();
    }

    private MuleArtifactLoaderDescriptor createClassLoaderModelDescriptorLoader(MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor, List<String> resources, List<String> packages) {
        HashMap<String, Object> attributes;
        String id = classLoaderModelLoaderDescriptor != null ? classLoaderModelLoaderDescriptor.getId() : "mule";
        Map<String, Object> map = attributes = classLoaderModelLoaderDescriptor != null && classLoaderModelLoaderDescriptor.getAttributes() != null ? classLoaderModelLoaderDescriptor.getAttributes() : new HashMap<String, Object>();
        if (this.exportAllResourcesAndPackagesIfEmptyLoaderDescriptor && classLoaderModelLoaderDescriptor == null) {
            attributes.put("exportedResources", resources);
            attributes.put("exportedPackages", packages);
        }
        if (this.isIncludeTestDependencies()) {
            attributes.put("includeTestDependencies", "true");
        }
        return new MuleArtifactLoaderDescriptor(id, attributes);
    }

    private List<String> getAvailablePackages(MavenPomParser parser) throws IOException {
        String sourceDirectory = parser.getSourceDirectory();
        Path javaDirectory = Paths.get(this.projectFolder.getAbsolutePath(), sourceDirectory.concat(DEFAULT_SOURCES_JAVA_DIRECTORY));
        if (!javaDirectory.toFile().exists()) {
            return Collections.emptyList();
        }
        List allJavaFiles = Files.walk(javaDirectory, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        Predicate<Path> isJavaFile = path -> FilenameUtils.getExtension((String)path.toString()).endsWith(JAVA_EXTENSION);
        return allJavaFiles.stream().filter(isJavaFile).map(path -> {
            Path parent = javaDirectory.relativize((Path)path).getParent();
            return parent != null ? parent.toString() : DEFAULT_PACKAGE_EXPORT;
        }).map(this::escapeSlashes).map(s -> s.replace(CLASS_PATH_SEPARATOR, PACKAGE_SEPARATOR)).distinct().collect(Collectors.toList());
    }

    private String getMuleResourcesDirectory(MavenPomParser parser) {
        return parser.getSourceDirectory().concat(DEFAULT_MULE_DIRECTORY);
    }

    private List<String> getAvailableMuleResources(MavenPomParser parser) throws IOException {
        String muleResourcesDirectory = this.getMuleResourcesDirectory(parser);
        List<String> resources = this.getResourcesInFolder(muleResourcesDirectory);
        if (resources.isEmpty()) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(muleResourcesDirectory + " cannot be empty"));
        }
        return resources;
    }

    private List<String> getAvailableNonMuleResources(MavenPomParser parser) throws IOException {
        String sourceDirectory = parser.getSourceDirectory();
        ArrayList<String> resources = new ArrayList<String>();
        List<String> resourcesDirectories = parser.getResourceDirectories();
        if (this.isIncludeTestDependencies()) {
            resources.addAll(this.getResourcesInFolder(sourceDirectory.concat(DEFAULT_TEST_RESOURCES_DIRECTORY)));
        }
        if (resourcesDirectories.isEmpty()) {
            resources.addAll(this.getResourcesInFolder(sourceDirectory.concat(DEFAULT_RESOURCES_DIRECTORY)));
        } else {
            resourcesDirectories.forEach(r -> {
                try {
                    resources.addAll(this.getResourcesInFolder((String)r));
                }
                catch (IOException e) {
                    throw new IllegalStateException("Cannot load files from" + r);
                }
            });
        }
        return resources;
    }

    private List<String> getResourcesInFolder(String resourcesDirectoryName) throws IOException {
        Path resourcesDirectory = Paths.get(this.projectFolder.getAbsolutePath(), resourcesDirectoryName);
        if (!resourcesDirectory.toFile().exists()) {
            return Collections.emptyList();
        }
        this.resourcesPath.add(resourcesDirectory);
        if (Files.notExists(resourcesDirectory, new LinkOption[0])) {
            return Collections.emptyList();
        }
        List allResourcesFiles = Files.walk(resourcesDirectory, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        return allResourcesFiles.stream().map(resourcesDirectory::relativize).map(Path::toString).map(this::escapeSlashes).collect(Collectors.toList());
    }

    private String escapeSlashes(String p) {
        return p.replace("\\", CLASS_PATH_SEPARATOR);
    }

    @Override
    protected File getPomFromFolder(File projectFolder) {
        String pomFilePath = "pom.xml";
        File pomFile = new File(projectFolder, pomFilePath);
        Preconditions.checkState(pomFile.exists(), String.format("The pom.xml file for artifact in folder %s could not be found", projectFolder.getAbsolutePath()));
        return pomFile;
    }
}

