/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.json.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.ast.internal.serialization.json.gson.TypedComponentIdentifierJsonDeserializer;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

public class ComponentLocationJsonDeserializer
implements JsonDeserializer<ComponentLocation> {
    public ComponentLocation deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        List<URI> importChain;
        TypedComponentIdentifierJsonDeserializer componentIdentifierJsonDeserializer = new TypedComponentIdentifierJsonDeserializer();
        JsonObject locationJsonObject = jsonElement.getAsJsonObject();
        JsonElement nameJsonElement = locationJsonObject.get("name");
        Optional<String> name = nameJsonElement != null ? Optional.of(nameJsonElement.getAsString()) : Optional.empty();
        JsonArray jsonArray = locationJsonObject.get("parts").getAsJsonArray();
        ArrayList<DefaultComponentLocation.DefaultLocationPart> parts = new ArrayList<DefaultComponentLocation.DefaultLocationPart>();
        for (JsonElement element : jsonArray) {
            JsonObject locationPartJsonObject = element.getAsJsonObject();
            JsonElement partPathJsonElement = locationPartJsonObject.get("partPath");
            String partPath = partPathJsonElement != null ? partPathJsonElement.getAsString() : null;
            Optional<TypedComponentIdentifier> partIdentifier = Optional.ofNullable(componentIdentifierJsonDeserializer.deserialize(locationPartJsonObject.get("partIdentifier"), (Type)((Object)TypedComponentIdentifier.class), jsonDeserializationContext));
            Optional<Object> fileName = Optional.ofNullable(locationPartJsonObject.get("fileName") != null ? locationPartJsonObject.get("fileName").getAsString() : null);
            OptionalInt lineInFile = OptionalInt.empty();
            JsonElement lineInFileJsonElement = locationPartJsonObject.get("line");
            if (lineInFileJsonElement != null) {
                lineInFile = OptionalInt.of(lineInFileJsonElement.getAsInt());
            }
            OptionalInt startColumn = OptionalInt.empty();
            JsonElement startColumnJsonElement = locationPartJsonObject.get("column");
            if (startColumnJsonElement != null) {
                startColumn = OptionalInt.of(startColumnJsonElement.getAsInt());
            }
            parts.add(new DefaultComponentLocation.DefaultLocationPart(partPath, partIdentifier, fileName, lineInFile, startColumn));
        }
        if (locationJsonObject.get("importChain") != null) {
            importChain = new ArrayList();
            for (JsonElement importChainItem : locationJsonObject.get("importChain").getAsJsonArray()) {
                importChain.add(URI.create(importChainItem.getAsString()));
            }
        } else {
            importChain = Collections.emptyList();
        }
        return new DefaultComponentLocation(name, parts, importChain);
    }
}

