/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleManifest {
    protected static final Logger logger = LoggerFactory.getLogger(MuleManifest.class);
    private static Manifest manifest;

    public static String getProductVersion() {
        String version = MuleManifest.getManifestProperty("Implementation-Version");
        if (version == null) {
            return MuleManifest.getProductVersionFromPropertiesFile();
        }
        return version;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getProductVersionFromPropertiesFile() {
        String VERSION_PROPERTIES_PATH = "product-version/version.properties";
        String WARNING_MESSAGE_VERSION_COULDNT_BE_RESOLVED = "Failure reading {} properties file to get productVersion";
        String COULDNT_BE_RESOLVED_PLACEHOLDER = "<Mule version could not be resolved>";
        Properties versionProps = new Properties();
        try (InputStream versionPropsInputStream = MuleManifest.class.getClassLoader().getResourceAsStream("product-version/version.properties");){
            if (versionPropsInputStream == null) {
                logger.warn("Failure reading {} properties file to get productVersion", (Object)"product-version/version.properties");
                String string2 = "<Mule version could not be resolved>";
                return string2;
            }
            versionProps.load(versionPropsInputStream);
            String string = versionProps.getProperty("mule.version");
            return string;
        }
        catch (IOException e) {
            logger.warn("Failure reading {} properties file to get productVersion", (Object)"product-version/version.properties", (Object)e);
            return "<Mule version could not be resolved>";
        }
    }

    public static String getVendorName() {
        return MuleManifest.getManifestProperty("Specification-Vendor");
    }

    public static String getVendorUrl() {
        return MuleManifest.getManifestProperty("Vendor-Url");
    }

    public static String getProductUrl() {
        return MuleManifest.getManifestProperty("Product-Url");
    }

    public static String getProductName() {
        return MuleManifest.getManifestProperty("Implementation-Title");
    }

    public static String getProductMoreInfo() {
        return MuleManifest.getManifestProperty("More-Info");
    }

    public static String getProductSupport() {
        return MuleManifest.getManifestProperty("Support");
    }

    public static String getProductLicenseInfo() {
        return MuleManifest.getManifestProperty("License");
    }

    public static String getProductDescription() {
        return MuleManifest.getManifestProperty("Description");
    }

    public static String getBuildNumber() {
        return MuleManifest.getManifestProperty("Build-Revision");
    }

    public static String getBuildDate() {
        return MuleManifest.getManifestProperty("Build-Date");
    }

    public static String getSupportedJdks() {
        return MuleManifest.getManifestProperty("Supported-Jdks");
    }

    @Deprecated
    public static String getRecommndedJdks() {
        return MuleManifest.getManifestProperty("Recommended-Jdks");
    }

    public static String getRecommendedJdks() {
        return MuleManifest.getManifestProperty("Recommended-Jdks");
    }

    public static synchronized Manifest getManifest() {
        if (manifest == null) {
            manifest = new Manifest();
            InputStream is = null;
            try {
                URL url = AccessController.doPrivileged(new UrlPrivilegedAction());
                if (url != null) {
                    is = url.openStream();
                }
                if (is != null) {
                    manifest.read(is);
                }
            }
            catch (IOException e) {
                logger.warn("Failed to read manifest Info, Manifest information will not display correctly: " + e.getMessage());
            }
        }
        return manifest;
    }

    protected static String getManifestProperty(String name) {
        return MuleManifest.getManifest().getMainAttributes().getValue(new Attributes.Name(name));
    }

    private MuleManifest() {
    }

    static class UrlPrivilegedAction
    implements PrivilegedAction<URL> {
        private static final Pattern EMBEDDED_JAR_PATTERN = Pattern.compile("mule[^-]*-[^-]*-embedded");
        private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";

        UrlPrivilegedAction() {
        }

        @Override
        public URL run() {
            URL result = null;
            try {
                Enumeration<URL> e = MuleConfiguration.class.getClassLoader().getResources(MANIFEST_PATH);
                result = this.getManifestJarURL(e);
                if (result == null) {
                    result = this.getManifestTestJarURL();
                }
            }
            catch (IOException e1) {
                logger.warn("Failure reading manifest: " + e1.getMessage(), (Throwable)e1);
            }
            return result;
        }

        URL getManifestJarURL(Enumeration<URL> e) {
            TreeMap<String, URL> candidates = new TreeMap<String, URL>();
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                if ((!url.toExternalForm().contains("mule-core") || url.toExternalForm().contains("tests.jar") || url.toExternalForm().contains("mule-core-components")) && !url.toExternalForm().contains("mule-runtime-extension-model") && !url.toExternalForm().contains("mule-runtime-ee-extension-model") && (!EMBEDDED_JAR_PATTERN.matcher(url.toExternalForm()).find() || !url.toExternalForm().endsWith(".jar"))) continue;
                candidates.put(url.toExternalForm(), url);
            }
            if (!candidates.isEmpty()) {
                for (String candidateKey : candidates.keySet()) {
                    if (!candidateKey.contains("mule-core-ee") && !candidateKey.contains("mule-runtime-ee-extension-model")) continue;
                    return (URL)candidates.get(candidateKey);
                }
                return (URL)candidates.get(candidates.lastKey());
            }
            return null;
        }

        URL getManifestTestJarURL() throws IOException {
            String testManifestPath = "core-tests/target/test-classes";
            Enumeration<URL> e = MuleConfiguration.class.getClassLoader().getResources(MANIFEST_PATH);
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                if ((!url.toExternalForm().contains(testManifestPath) || url.toExternalForm().contains("tests.jar")) && (!EMBEDDED_JAR_PATTERN.matcher(url.toExternalForm()).find() || !url.toExternalForm().endsWith(".jar"))) continue;
                return url;
            }
            return null;
        }
    }
}

