/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.model;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.artifact.ArtifactCoordinates;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ExternalLibraryModel;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.construct.HasConstructModels;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.function.FunctionModel;
import org.mule.runtime.api.meta.model.function.HasFunctionModels;
import org.mule.runtime.api.meta.model.notification.NotificationModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.extension.api.ExtensionConstants;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.model.AbstractComplexModel;

public class ImmutableExtensionModel
extends AbstractComplexModel
implements ExtensionModel,
HasFunctionModels {
    private final String vendor;
    private final String version;
    private final Category category;
    private final List<ConfigurationModel> configurations;
    private final List<ConstructModel> constructModels;
    private final List<FunctionModel> functions;
    private final Set<String> privilegedPackages;
    private final Set<String> privilegedArtifacts;
    private final Set<ErrorModel> errors;
    private final Set<ObjectType> types;
    private final Set<String> resources;
    private final XmlDslModel xmlDslModel;
    private final Set<SubTypesModel> subTypes;
    private final Set<ImportedTypeModel> importedTypes;
    private final Set<ExternalLibraryModel> externalLibraries;
    private final Set<NotificationModel> notifications;
    private final ArtifactCoordinates artifactCoordinates;
    private final MuleVersion minMuleVersion;
    private final Set<String> supportedJavaVersions;

    @Deprecated
    public ImmutableExtensionModel(String name, String description, String version, String vendor, Category category, List<ConfigurationModel> configurationModels, List<OperationModel> operationModels, List<ConnectionProviderModel> connectionProviders, List<SourceModel> sourceModels, List<FunctionModel> functions, List<ConstructModel> constructModels, DisplayModel displayModel, XmlDslModel xmlDslModel, Set<SubTypesModel> subTypes, Set<ObjectType> types, Set<String> resources, Set<ImportedTypeModel> importedTypes, Set<ErrorModel> errors, Set<ExternalLibraryModel> externalLibraryModels, Set<String> privilegedPackages, Set<String> privilegedArtifacts, Set<ModelProperty> modelProperties) {
        this(name, description, version, vendor, category, configurationModels, operationModels, connectionProviders, sourceModels, functions, constructModels, displayModel, xmlDslModel, subTypes, types, resources, importedTypes, errors, externalLibraryModels, privilegedPackages, privilegedArtifacts, modelProperties, Collections.emptySet());
    }

    public ImmutableExtensionModel(String name, String description, String version, String vendor, Category category, List<ConfigurationModel> configurationModels, List<OperationModel> operationModels, List<ConnectionProviderModel> connectionProviders, List<SourceModel> sourceModels, List<FunctionModel> functions, List<ConstructModel> constructModels, DisplayModel displayModel, XmlDslModel xmlDslModel, Set<SubTypesModel> subTypes, Set<ObjectType> types, Set<String> resources, Set<ImportedTypeModel> importedTypes, Set<ErrorModel> errors, Set<ExternalLibraryModel> externalLibraryModels, Set<String> privilegedPackages, Set<String> privilegedArtifacts, Set<ModelProperty> modelProperties, Set<NotificationModel> notifications) {
        this(name, description, version, vendor, category, configurationModels, operationModels, connectionProviders, sourceModels, functions, constructModels, displayModel, xmlDslModel, subTypes, types, resources, importedTypes, errors, externalLibraryModels, privilegedPackages, privilegedArtifacts, modelProperties, notifications, null);
    }

    public ImmutableExtensionModel(String name, String description, String version, String vendor, Category category, List<ConfigurationModel> configurationModels, List<OperationModel> operationModels, List<ConnectionProviderModel> connectionProviders, List<SourceModel> sourceModels, List<FunctionModel> functions, List<ConstructModel> constructModels, DisplayModel displayModel, XmlDslModel xmlDslModel, Set<SubTypesModel> subTypes, Set<ObjectType> types, Set<String> resources, Set<ImportedTypeModel> importedTypes, Set<ErrorModel> errors, Set<ExternalLibraryModel> externalLibraryModels, Set<String> privilegedPackages, Set<String> privilegedArtifacts, Set<ModelProperty> modelProperties, Set<NotificationModel> notifications, DeprecationModel deprecationModel) {
        this(name, description, version, vendor, category, configurationModels, operationModels, connectionProviders, sourceModels, functions, constructModels, displayModel, xmlDslModel, subTypes, types, resources, importedTypes, errors, externalLibraryModels, privilegedPackages, privilegedArtifacts, modelProperties, notifications, deprecationModel, null);
    }

    public ImmutableExtensionModel(String name, String description, String version, String vendor, Category category, List<ConfigurationModel> configurationModels, List<OperationModel> operationModels, List<ConnectionProviderModel> connectionProviders, List<SourceModel> sourceModels, List<FunctionModel> functions, List<ConstructModel> constructModels, DisplayModel displayModel, XmlDslModel xmlDslModel, Set<SubTypesModel> subTypes, Set<ObjectType> types, Set<String> resources, Set<ImportedTypeModel> importedTypes, Set<ErrorModel> errors, Set<ExternalLibraryModel> externalLibraryModels, Set<String> privilegedPackages, Set<String> privilegedArtifacts, Set<ModelProperty> modelProperties, Set<NotificationModel> notifications, DeprecationModel deprecationModel, ArtifactCoordinates artifactCoordinates) {
        this(name, description, version, vendor, category, configurationModels, operationModels, connectionProviders, sourceModels, functions, constructModels, displayModel, xmlDslModel, subTypes, types, resources, importedTypes, errors, externalLibraryModels, privilegedPackages, privilegedArtifacts, modelProperties, notifications, deprecationModel, artifactCoordinates, null, ExtensionConstants.DEFAULT_SUPPORTED_JAVA_VERSIONS);
    }

    public ImmutableExtensionModel(String name, String description, String version, String vendor, Category category, List<ConfigurationModel> configurationModels, List<OperationModel> operationModels, List<ConnectionProviderModel> connectionProviders, List<SourceModel> sourceModels, List<FunctionModel> functions, List<ConstructModel> constructModels, DisplayModel displayModel, XmlDslModel xmlDslModel, Set<SubTypesModel> subTypes, Set<ObjectType> types, Set<String> resources, Set<ImportedTypeModel> importedTypes, Set<ErrorModel> errors, Set<ExternalLibraryModel> externalLibraryModels, Set<String> privilegedPackages, Set<String> privilegedArtifacts, Set<ModelProperty> modelProperties, Set<NotificationModel> notifications, DeprecationModel deprecationModel, ArtifactCoordinates artifactCoordinates, MuleVersion minMuleVersion, Set<String> supportedJavaVersions) {
        super(name, description, operationModels, connectionProviders, sourceModels, displayModel, modelProperties, deprecationModel);
        this.configurations = this.copy(configurationModels);
        this.checkModelArgument(version != null && version.length() > 0, "Version cannot be blank");
        this.checkModelArgument(category != null, "Extension Category cannot be null");
        this.checkModelArgument(vendor != null, "Extension Vendor cannot be null");
        this.checkModelArgument(xmlDslModel != null, "xmlDslModel cannot be null");
        this.category = category;
        this.version = version;
        this.vendor = vendor;
        this.types = this.copy(types);
        this.resources = this.copy(resources);
        this.importedTypes = this.copy(importedTypes);
        this.subTypes = this.copy(subTypes);
        this.xmlDslModel = xmlDslModel;
        this.errors = errors;
        this.externalLibraries = Collections.unmodifiableSet(externalLibraryModels);
        this.privilegedPackages = privilegedPackages;
        this.privilegedArtifacts = privilegedArtifacts;
        this.constructModels = this.copy(constructModels);
        this.functions = this.copy(functions);
        this.notifications = this.copy(notifications);
        this.artifactCoordinates = artifactCoordinates;
        this.minMuleVersion = minMuleVersion;
        this.supportedJavaVersions = this.copy(supportedJavaVersions);
    }

    @Override
    public List<ConfigurationModel> getConfigurationModels() {
        return this.configurations;
    }

    @Override
    public Optional<ConfigurationModel> getConfigurationModel(String name) {
        return this.findModel(this.configurations, name);
    }

    @Override
    public List<ConstructModel> getConstructModels() {
        return this.constructModels;
    }

    @Override
    public Optional<ConstructModel> getConstructModel(String name) {
        return this.constructModels.stream().filter(c -> c.getName().equals(name)).findFirst();
    }

    @Override
    public List<FunctionModel> getFunctionModels() {
        return this.functions;
    }

    @Override
    public Optional<FunctionModel> getFunctionModel(String name) {
        return this.findModel(this.functions, name);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    @Override
    public Category getCategory() {
        return this.category;
    }

    @Override
    public Set<ObjectType> getTypes() {
        return this.types;
    }

    @Override
    public Set<String> getPrivilegedPackages() {
        return this.privilegedPackages;
    }

    @Override
    public Set<String> getPrivilegedArtifacts() {
        return this.privilegedArtifacts;
    }

    @Override
    public Set<String> getResources() {
        return this.resources;
    }

    @Override
    public Set<ImportedTypeModel> getImportedTypes() {
        return this.importedTypes;
    }

    @Override
    public XmlDslModel getXmlDslModel() {
        return this.xmlDslModel;
    }

    @Override
    public Set<SubTypesModel> getSubTypes() {
        return this.subTypes;
    }

    @Override
    public Set<ErrorModel> getErrorModels() {
        return this.errors;
    }

    @Override
    public Set<NotificationModel> getNotificationModels() {
        return this.notifications;
    }

    @Override
    public Set<ExternalLibraryModel> getExternalLibraryModels() {
        return this.externalLibraries;
    }

    private void checkModelArgument(boolean condition, String errorMessage) {
        if (!condition) {
            throw new IllegalModelDefinitionException(errorMessage);
        }
    }

    @Override
    public Optional<ComponentModel> findComponentModel(String componentName) {
        ConfigurationModel configurationModel;
        Optional<ComponentModel> component = this.doFindComponentModel(this, componentName);
        if (component.isPresent()) {
            return component;
        }
        Iterator<ConfigurationModel> iterator = this.configurations.iterator();
        while (iterator.hasNext() && !(component = this.doFindComponentModel(configurationModel = iterator.next(), componentName)).isPresent()) {
        }
        return component;
    }

    @Override
    public Optional<ArtifactCoordinates> getArtifactCoordinates() {
        return Optional.ofNullable(this.artifactCoordinates);
    }

    @Override
    public Optional<MuleVersion> getMinMuleVersion() {
        return Optional.ofNullable(this.minMuleVersion);
    }

    @Override
    public Set<String> getSupportedJavaVersions() {
        return this.supportedJavaVersions;
    }

    private <T extends HasOperationModels & HasSourceModels> Optional<ComponentModel> doFindComponentModel(T owner, String componentName) {
        Optional<ComponentModel> component = owner.getOperationModel(componentName);
        if (component.isPresent()) {
            return component;
        }
        component = ((HasSourceModels)owner).getSourceModel(componentName);
        if (component.isPresent()) {
            return component;
        }
        if (owner instanceof HasConstructModels) {
            component = ((HasConstructModels)owner).getConstructModel(componentName);
        }
        return component;
    }

    @Override
    public String toString() {
        return "ImmutableExtensionModel{vendor='" + this.vendor + '\'' + ", version='" + this.version + '\'' + ", category=" + (Object)((Object)this.category) + ", configurations=" + this.configurations + ", constructModels=" + this.constructModels + ", functions=" + this.functions + ", privilegedPackages=" + this.privilegedPackages + ", privilegedArtifacts=" + this.privilegedArtifacts + ", errors=" + this.errors + ", types=" + this.types + ", resources=" + this.resources + ", xmlDslModel=" + this.xmlDslModel + ", subTypes=" + this.subTypes + ", importedTypes=" + this.importedTypes + ", externalLibraries=" + this.externalLibraries + ", notifications=" + this.notifications + ", artifactCoordinates=" + this.artifactCoordinates + ", minMuleVersion=" + this.minMuleVersion + "} " + super.toString();
    }
}

