/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.privileged.util;

import java.util.Set;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.extension.internal.property.NoConnectivityErrorModelProperty;
import org.mule.runtime.extension.internal.property.NoErrorMappingModelProperty;
import org.mule.runtime.extension.internal.property.NoReconnectionStrategyModelProperty;
import org.mule.runtime.extension.internal.property.NoStreamingConfigurationModelProperty;
import org.mule.runtime.extension.internal.property.NoTransactionalActionModelProperty;
import org.mule.runtime.extension.internal.property.PagedOperationModelProperty;
import org.mule.runtime.extension.internal.property.TargetModelProperty;
import org.mule.runtime.extension.internal.property.TransactionalActionModelProperty;
import org.mule.runtime.extension.internal.property.TransactionalTypeModelProperty;

public final class ComponentDeclarationUtils {
    private ComponentDeclarationUtils() {
    }

    public static void withNoStreamingConfiguration(OperationDeclarer declarer) {
        declarer.withModelProperty(new NoStreamingConfigurationModelProperty());
    }

    public static void withNoTransactionalAction(OperationDeclarer declarer) {
        declarer.withModelProperty(new NoTransactionalActionModelProperty());
    }

    public static void withNoReconnectionStrategy(OperationDeclarer declarer) {
        declarer.withModelProperty(new NoReconnectionStrategyModelProperty());
    }

    public static void withNoReconnectionStrategy(ExtensionDeclarer declarer) {
        declarer.withModelProperty(new NoReconnectionStrategyModelProperty());
    }

    public static void withNoConnectivityError(OperationDeclarer declarer) {
        declarer.withModelProperty(new NoConnectivityErrorModelProperty());
    }

    public static void withNoErrorMapping(OperationDeclarer declarer) {
        declarer.withModelProperty(new NoErrorMappingModelProperty());
    }

    public static void asPagedOperation(ComponentDeclarer declarer) {
        declarer.withModelProperty(new PagedOperationModelProperty());
    }

    public static boolean isNoTransactionalAction(ComponentModel componentModel) {
        return componentModel.getModelProperty(NoTransactionalActionModelProperty.class).isPresent();
    }

    public static boolean isNoErrorMapping(OperationModel componentModel) {
        return componentModel.getModelProperty(NoErrorMappingModelProperty.class).isPresent();
    }

    public static boolean isPagedOperation(ComponentModel componentModel) {
        return componentModel.getModelProperty(PagedOperationModelProperty.class).isPresent();
    }

    public static boolean isTransactionalAction(ParameterModel paramModel) {
        return paramModel.getModelProperty(TransactionalActionModelProperty.class).isPresent();
    }

    public static boolean isTransactionalType(ParameterModel paramModel) {
        return paramModel.getModelProperty(TransactionalTypeModelProperty.class).isPresent();
    }

    public static boolean isTargetParameter(Set<ModelProperty> paramModelProperties) {
        return paramModelProperties.stream().anyMatch(modelProperty -> modelProperty instanceof TargetModelProperty);
    }

    public static boolean isTargetParameter(ParameterModel paramModel) {
        return ComponentDeclarationUtils.isTargetParameter(paramModel.getModelProperties());
    }

    public static boolean isConnectionProvisioningRequired(ConnectableComponentModel componentModel) {
        return componentModel.requiresConnection() && ComponentDeclarationUtils.isConnectivityErrorSupported(componentModel);
    }

    public static boolean isReconnectionStrategySupported(ConnectableComponentModel componentModel) {
        return !componentModel.getModelProperty(NoReconnectionStrategyModelProperty.class).isPresent();
    }

    public static boolean isReconnectionStrategySupported(ExtensionDeclaration declaration) {
        return ComponentDeclarationUtils.isReconnectionStrategySupported(declaration);
    }

    public static boolean isReconnectionStrategySupported(ExecutableComponentDeclaration<?> declaration) {
        return ComponentDeclarationUtils.isReconnectionStrategySupported(declaration);
    }

    private static boolean isReconnectionStrategySupported(BaseDeclaration<?> declaration) {
        return !declaration.getModelProperty(NoReconnectionStrategyModelProperty.class).isPresent();
    }

    public static boolean isConnectivityErrorSupported(ExecutableComponentDeclaration<?> declaration) {
        return !declaration.getModelProperty(NoConnectivityErrorModelProperty.class).isPresent();
    }

    private static boolean isConnectivityErrorSupported(ConnectableComponentModel componentModel) {
        return !componentModel.getModelProperty(NoConnectivityErrorModelProperty.class).isPresent();
    }
}

