/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.deployable;

import com.google.common.collect.Sets;
import com.vdurmont.semver4j.Semver;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.maven.pom.parser.api.MavenPomParserProvider;
import org.mule.runtime.api.deployment.meta.MuleDeployableModel;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.globalconfig.api.GlobalConfigLoader;
import org.mule.runtime.module.artifact.activation.api.deployable.ArtifactModelResolver;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.activation.internal.deployable.AbstractDeployableProjectModelBuilder;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.internal.util.FileJarExplorer;
import org.mule.runtime.module.artifact.internal.util.JarExplorer;
import org.mule.runtime.module.artifact.internal.util.JarInfo;
import org.mule.tools.api.classloader.AppClassLoaderModelJsonSerializer;
import org.mule.tools.api.classloader.ClassLoaderModelJsonSerializer;
import org.mule.tools.api.classloader.model.AppClassLoaderModel;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.classloader.model.ClassLoaderModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleDeployableProjectModelBuilder
extends AbstractDeployableProjectModelBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleDeployableProjectModelBuilder.class);
    private final File projectFolder;
    private final Optional<MuleDeployableModel> model;

    public MuleDeployableProjectModelBuilder(File projectFolder) {
        this(projectFolder, Optional.empty());
    }

    public MuleDeployableProjectModelBuilder(File projectFolder, Optional<MuleDeployableModel> model) {
        if (!projectFolder.isDirectory()) {
            throw new IllegalArgumentException(String.format("projectFolder '%s' is not a folder", projectFolder.getAbsolutePath()));
        }
        this.projectFolder = projectFolder;
        this.model = model;
    }

    @Override
    public DeployableProjectModel build() {
        AppClassLoaderModel packagerClassLoaderModel = this.getAppPackagerClassLoaderModel(MuleDeployableProjectModelBuilder.getClassLoaderModelDescriptor(this.projectFolder));
        Map<ArtifactCoordinates, BundleDescriptor> bundleDescriptors = packagerClassLoaderModel.getDependencies().stream().collect(Collectors.toMap(Artifact::getArtifactCoordinates, artifact -> this.buildBundleDescriptor(artifact.getArtifactCoordinates()), (bundleDescriptor1, bundleDescriptor2) -> bundleDescriptor1));
        Map<BundleDescriptor, List<BundleDependency>> additionalPluginDependencies = this.getAdditionalPluginDependencies(packagerClassLoaderModel, bundleDescriptors);
        List<BundleDependency> dependencies = this.getDependencies(packagerClassLoaderModel);
        Set<BundleDescriptor> sharedLibraries = this.getSharedLibraries(packagerClassLoaderModel, bundleDescriptors);
        List<String> packages = packagerClassLoaderModel.getPackages() != null ? Arrays.asList(packagerClassLoaderModel.getPackages()) : Collections.emptyList();
        List<String> resources = packagerClassLoaderModel.getResources() != null ? Arrays.asList(packagerClassLoaderModel.getResources()) : Collections.emptyList();
        return new DeployableProjectModel(packages, resources, Collections.emptyList(), this.buildBundleDescriptor(packagerClassLoaderModel.getArtifactCoordinates()), this.getModelResolver(packagerClassLoaderModel.getArtifactCoordinates()), Optional.empty(), this.projectFolder, dependencies, sharedLibraries, additionalPluginDependencies);
    }

    private Map<BundleDescriptor, List<BundleDependency>> getAdditionalPluginDependencies(AppClassLoaderModel packagerClassLoaderModel, Map<ArtifactCoordinates, BundleDescriptor> bundleDescriptors) {
        return packagerClassLoaderModel.getAdditionalPluginDependencies().map(apds -> apds.stream().collect(Collectors.toMap(plugin -> packagerClassLoaderModel.getDependencies().stream().filter(pluginDependency -> StringUtils.equals((CharSequence)pluginDependency.getArtifactCoordinates().getGroupId(), (CharSequence)plugin.getGroupId()) && StringUtils.equals((CharSequence)pluginDependency.getArtifactCoordinates().getArtifactId(), (CharSequence)plugin.getArtifactId())).map(artifact -> (BundleDescriptor)bundleDescriptors.get(artifact.getArtifactCoordinates())).findFirst().orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Couldn't find plugin '%s' among dependencies", plugin)))), plugin -> plugin.getAdditionalDependencies().stream().map(artifact -> this.createAdditionalPluginDependencyFromPackagerDependency((Artifact)artifact, packagerClassLoaderModel)).collect(Collectors.toList())))).orElse(Collections.emptyMap());
    }

    private BundleDependency createAdditionalPluginDependencyFromPackagerDependency(Artifact additionalPluginArtifact, AppClassLoaderModel packagerClassLoaderModel) {
        BundleDependency additionalPluginDependency = this.createBundleDependencyFromPackagerDependency(this.getDeployableArtifactRepositoryUriResolver()).apply(additionalPluginArtifact);
        if (new Semver(packagerClassLoaderModel.getVersion(), Semver.SemverType.LOOSE).isLowerThan("1.2.0")) {
            additionalPluginDependency = this.discoverPackagesAndResources(additionalPluginDependency);
        }
        return additionalPluginDependency;
    }

    private List<BundleDependency> getDependencies(AppClassLoaderModel packagerClassLoaderModel) {
        List<BundleDependency> patchBundleDependencies = this.getPatchedBundledDependencies(this.projectFolder);
        List<BundleDependency> dependencies = packagerClassLoaderModel.getDependencies().stream().map(artifact -> {
            Optional<BundleDependency> patchedBundledDependency = patchBundleDependencies.stream().filter(bundleDependency -> bundleDependency.getDescriptor().getGroupId().equals(artifact.getArtifactCoordinates().getGroupId()) && bundleDependency.getDescriptor().getArtifactId().equals(artifact.getArtifactCoordinates().getArtifactId())).findAny();
            return patchedBundledDependency.orElse(this.createBundleDependencyFromPackagerDependency(this.getDeployableArtifactRepositoryUriResolver()).apply((Artifact)artifact));
        }).collect(Collectors.toList());
        dependencies = dependencies.stream().map(d -> new BundleDependency.Builder((BundleDependency)d).setTransitiveDependencies(this.getTransitiveDependencies((BundleDependency)d)).build()).collect(Collectors.toList());
        if (new Semver(packagerClassLoaderModel.getVersion(), Semver.SemverType.LOOSE).isLowerThan("1.2.0")) {
            dependencies = this.discoverPackagesAndResources(dependencies);
        }
        return dependencies;
    }

    private List<BundleDependency> getPatchedBundledDependencies(File artifactFile) {
        ArrayList<BundleDependency> patchBundleDependencies = new ArrayList<BundleDependency>();
        File classLoaderModelPatchDescriptor = this.getClassLoaderModelPatchDescriptor(artifactFile);
        if (classLoaderModelPatchDescriptor.exists()) {
            ClassLoaderModel packagerClassLoaderModelPatch = this.getPackagerClassLoaderModel(classLoaderModelPatchDescriptor);
            patchBundleDependencies.addAll(packagerClassLoaderModelPatch.getDependencies().stream().map(artifact -> this.createBundleDependencyFromPackagerDependency(this.getDeployableArtifactRepositoryUriResolver()).apply((Artifact)artifact)).collect(Collectors.toList()));
        }
        return patchBundleDependencies;
    }

    private List<BundleDependency> getTransitiveDependencies(BundleDependency bundleDependency) {
        if (bundleDependency.getDescriptor().isPlugin() && bundleDependency.getBundleUri() != null) {
            ClassLoaderModel packagerClassLoaderModel = this.getPackagerClassLoaderModel(this.getPluginClassLoaderModelDescriptor(bundleDependency));
            return packagerClassLoaderModel.getDependencies().stream().map(artifact -> this.createBundleDependencyFromPackagerDependency(this.getDeployableArtifactRepositoryUriResolver()).apply((Artifact)artifact)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private BundleDependency discoverPackagesAndResources(BundleDependency dependency) {
        FileJarExplorer jarExplorer = new FileJarExplorer();
        if ("mule-plugin".equals(dependency.getDescriptor().getClassifier().orElse(null))) {
            return this.discoverPluginPackagesAndResources(dependency, jarExplorer);
        }
        return this.addLocalPackagesAndResourcesToDependency(dependency, jarExplorer);
    }

    private List<BundleDependency> discoverPackagesAndResources(List<BundleDependency> dependencies) {
        return dependencies.stream().map(this::discoverPackagesAndResources).collect(Collectors.toList());
    }

    private BundleDependency discoverPluginPackagesAndResources(BundleDependency dependency, JarExplorer jarExplorer) {
        if (!"mule-plugin".equals(dependency.getDescriptor().getClassifier().orElse(null))) {
            throw new IllegalArgumentException("Expected dependency to be a Mule plugin");
        }
        List<BundleDependency> updatedTransitiveDependenciesList = dependency.getTransitiveDependenciesList().stream().map(transitiveDependency -> this.addLocalPackagesAndResourcesToDependency((BundleDependency)transitiveDependency, jarExplorer)).collect(Collectors.toList());
        JarInfo exploredJar = jarExplorer.explore(dependency.getBundleUri());
        return new BundleDependency.Builder(dependency).setTransitiveDependencies(updatedTransitiveDependenciesList).setPackages(exploredJar.getPackages()).setResources(exploredJar.getResources()).build();
    }

    private BundleDependency addLocalPackagesAndResourcesToDependency(BundleDependency dependency, JarExplorer jarExplorer) {
        if ("mule-plugin".equals(dependency.getDescriptor().getClassifier().orElse(null)) || "mule-domain".equals(dependency.getDescriptor().getClassifier().orElse(null)) || this.validateMuleRuntimeSharedLibrary(dependency.getDescriptor().getGroupId(), dependency.getDescriptor().getArtifactId()) || dependency.getBundleUri() == null) {
            return dependency;
        }
        try {
            JarInfo exploredJar = jarExplorer.explore(dependency.getBundleUri());
            return new BundleDependency.Builder(dependency).setPackages(exploredJar.getPackages()).setResources(exploredJar.getResources()).build();
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("File for dependency artifact not found: '{}'. Skipped localPackages scanning for that artifact.", (Object)dependency.getBundleUri());
            return dependency;
        }
    }

    private Set<BundleDescriptor> getSharedLibraries(AppClassLoaderModel packagerClassLoaderModel, Map<ArtifactCoordinates, BundleDescriptor> bundleDescriptors) {
        if (new Semver(packagerClassLoaderModel.getVersion(), Semver.SemverType.LOOSE).isLowerThan("1.1.0")) {
            return MavenPomParserProvider.discoverProvider().createMavenPomParserClient(this.projectFolder.toPath(), this.getActiveProfiles()).getSharedLibraries().stream().map(shareLibrary -> {
                if (!this.validateMuleRuntimeSharedLibrary(shareLibrary.getGroupId(), shareLibrary.getArtifactId())) {
                    return bundleDescriptors.values().stream().filter(bundleDescriptor -> bundleDescriptor.getGroupId().equals(shareLibrary.getGroupId()) && bundleDescriptor.getArtifactId().equals(shareLibrary.getArtifactId())).findAny().orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Shared library '%s:%s' is not among the available dependencies", shareLibrary.getGroupId(), shareLibrary.getArtifactId())));
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        return packagerClassLoaderModel.getDependencies().stream().filter(Artifact::isShared).map(artifact -> (BundleDescriptor)bundleDescriptors.get(artifact.getArtifactCoordinates())).collect(Collectors.toSet());
    }

    protected final boolean validateMuleRuntimeSharedLibrary(String groupId, String artifactId) {
        if ("org.mule.runtime".equals(groupId) || "com.mulesoft.mule.runtime.modules".equals(groupId)) {
            LOGGER.warn("Shared library '{}:{}' is a Mule Runtime dependency. It will not be shared by the app in order to avoid classloading issues. Please consider removing it, or at least not putting it as a sharedLibrary.", (Object)groupId, (Object)artifactId);
            return true;
        }
        return false;
    }

    protected List<String> getActiveProfiles() {
        return GlobalConfigLoader.getMavenConfig().getActiveProfiles().orElse(Collections.emptyList());
    }

    private File getClassLoaderModelPatchDescriptor(File artifactFile) {
        return new File(artifactFile, "META-INF/mule-artifact/classloader-model-patch.json");
    }

    private Function<URI, URI> getDeployableArtifactRepositoryUriResolver() {
        return uri -> new File(this.projectFolder, uri.toString()).toURI();
    }

    private Function<Artifact, BundleDependency> createBundleDependencyFromPackagerDependency(Function<URI, URI> uriResolver) {
        return d -> {
            URI bundle = d.getUri();
            if (!d.getUri().isAbsolute()) {
                bundle = (URI)uriResolver.apply(d.getUri());
            }
            return new BundleDependency.Builder().setDescriptor(new BundleDescriptor.Builder().setArtifactId(d.getArtifactCoordinates().getArtifactId()).setGroupId(d.getArtifactCoordinates().getGroupId()).setClassifier(d.getArtifactCoordinates().getClassifier()).setType(d.getArtifactCoordinates().getType()).setVersion(d.getArtifactCoordinates().getVersion()).setBaseVersion(d.getArtifactCoordinates().getVersion()).build()).setBundleUri(bundle).setPackages(d.getPackages() == null ? Collections.emptySet() : Sets.newHashSet((Object[])d.getPackages())).setResources(d.getResources() == null ? Collections.emptySet() : Sets.newHashSet((Object[])d.getResources())).build();
        };
    }

    private Supplier<MuleDeployableModel> getModelResolver(ArtifactCoordinates deployableArtifactCoordinates) {
        return () -> this.model.orElseGet(() -> {
            File muleArtifactFolder = new File(this.projectFolder, ArtifactDescriptor.MULE_ARTIFACT_FOLDER);
            if (deployableArtifactCoordinates.getClassifier().equals("mule-application")) {
                return ArtifactModelResolver.applicationModelResolver().resolve(muleArtifactFolder);
            }
            if (deployableArtifactCoordinates.getClassifier().equals("mule-domain")) {
                return ArtifactModelResolver.domainModelResolver().resolve(muleArtifactFolder);
            }
            throw new IllegalStateException("project is not a mule-application or mule-domain");
        });
    }

    private BundleDescriptor buildBundleDescriptor(ArtifactCoordinates artifactCoordinates) {
        return new BundleDescriptor.Builder().setArtifactId(artifactCoordinates.getArtifactId()).setGroupId(artifactCoordinates.getGroupId()).setVersion(artifactCoordinates.getVersion()).setBaseVersion(artifactCoordinates.getVersion()).setType(artifactCoordinates.getType()).setClassifier(artifactCoordinates.getClassifier()).build();
    }

    private File getPluginClassLoaderModelDescriptor(BundleDependency bundleDependency) {
        File artifactFile = new File(bundleDependency.getBundleUri());
        if (MuleDeployableProjectModelBuilder.isHeavyPackage(artifactFile)) {
            return MuleDeployableProjectModelBuilder.getClassLoaderModelDescriptor(artifactFile);
        }
        char slashChar = '/';
        String path = "META-INF" + slashChar + "mule-artifact" + slashChar + bundleDependency.getDescriptor().getGroupId().replace('.', slashChar) + slashChar + bundleDependency.getDescriptor().getArtifactId() + slashChar + bundleDependency.getDescriptor().getBaseVersion() + slashChar + "classloader-model.json";
        return new File(this.projectFolder.getAbsolutePath(), path);
    }

    private AppClassLoaderModel getAppPackagerClassLoaderModel(File classLoaderModelDescriptor) {
        AppClassLoaderModel appPackagerClassLoaderModel = AppClassLoaderModelJsonSerializer.deserialize(classLoaderModelDescriptor);
        if (appPackagerClassLoaderModel.getArtifactCoordinates().getClassifier() == null) {
            throw new IllegalArgumentException(String.format("Artifact coordinates from project's class loader model are missing the 'classifier' attribute. Valid values are '%s' and '%s'.", "mule-application", "mule-domain"));
        }
        return appPackagerClassLoaderModel;
    }

    private ClassLoaderModel getPackagerClassLoaderModel(File classLoaderModelDescriptor) {
        return ClassLoaderModelJsonSerializer.deserialize(classLoaderModelDescriptor);
    }
}

