/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.module.extension.api.loader.java.type.FieldElement;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.util.FieldSetter;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.reflections.ReflectionUtils;

public class ReflectionCache {
    private final ConcurrentMap<Class<?>, List<FieldElement>> fieldElements = new ConcurrentHashMap();
    private final ConcurrentMap<Class<? extends Annotation>, ConcurrentMap<Class<?>, Optional<FieldSetter>>> fieldSetterForAnnotatedField = new ConcurrentHashMap(3, 0.9f);
    private final ConcurrentMap<Class<?>, List<Field>> fieldsByClass = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, Boolean> hasDefaultConstructorsByClass = new ConcurrentHashMap();

    public List<FieldElement> fieldElementsFor(ParameterGroupDescriptor groupDescriptor) {
        Class<?> clazz = groupDescriptor.getType().getDeclaringClass().get();
        List elements = (List)this.fieldElements.get(clazz);
        if (elements == null) {
            elements = this.fieldElements.computeIfAbsent(clazz, cls -> groupDescriptor.getType().getFields());
        }
        return elements;
    }

    public Optional<FieldSetter> getFieldSetterForAnnotatedField(Object target, Class<? extends Annotation> annotationClass) {
        Class<?> type;
        Optional setter;
        ConcurrentMap cache = (ConcurrentMap)this.fieldSetterForAnnotatedField.get(annotationClass);
        if (cache == null) {
            cache = this.fieldSetterForAnnotatedField.computeIfAbsent(annotationClass, k -> new ConcurrentHashMap());
        }
        if ((setter = (Optional)cache.get(type = target.getClass())) == null) {
            setter = cache.computeIfAbsent(type, t -> {
                List<Field> fields = IntrospectionUtils.getAnnotatedFields(t, annotationClass);
                if (fields.isEmpty()) {
                    return Optional.empty();
                }
                if (fields.size() > 1) {
                    throw new IllegalModelDefinitionException(String.format("Class '%s' has %d fields annotated with @%s. Only one field may carry that annotation", t.getName(), fields.size(), annotationClass));
                }
                return Optional.of(new FieldSetter(fields.get(0)));
            });
        }
        return setter;
    }

    public List<Field> getFields(Class<?> clazz) {
        List fields = (List)this.fieldsByClass.get(clazz);
        if (fields == null) {
            fields = this.fieldsByClass.computeIfAbsent(clazz, cls -> {
                ArrayList<Field> f = new ArrayList<Field>();
                for (Field field : clazz.getDeclaredFields()) {
                    f.add(field);
                }
                for (Class type : ReflectionUtils.getAllSuperTypes((Class)clazz, (Predicate[])new Predicate[0])) {
                    for (Field field : type.getDeclaredFields()) {
                        f.add(field);
                    }
                }
                return f;
            });
        }
        return fields;
    }

    public boolean hasDefaultConstructor(Class<?> clazz) {
        Boolean value = (Boolean)this.hasDefaultConstructorsByClass.get(clazz);
        if (value == null) {
            value = this.hasDefaultConstructorsByClass.computeIfAbsent(clazz, cls -> ClassUtils.getConstructor(cls, new Class[0]) != null);
        }
        return value;
    }
}

