/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.exception;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.config.ExceptionHelper;
import org.mule.runtime.core.privileged.exception.EventProcessingException;

public class MessagingException
extends EventProcessingException {
    private static final long serialVersionUID = 5419631874341149626L;
    public static final String PAYLOAD_INFO_KEY = "Payload";
    public static final String PAYLOAD_TYPE_INFO_KEY = "Payload Type";
    protected transient Message muleMessage;
    protected transient CoreEvent processedEvent;
    private boolean handled;
    private transient Component failingComponent;

    public MessagingException(I18nMessage message, CoreEvent event) {
        super(message, event);
        this.extractMuleMessage(event);
        this.setMessage(this.generateMessage(message, null));
    }

    public MessagingException(I18nMessage message, CoreEvent event, Component failingComponent) {
        super(message, event);
        this.extractMuleMessage(event);
        this.failingComponent = failingComponent;
        this.setMessage(this.generateMessage(message, null));
    }

    public MessagingException(I18nMessage message, CoreEvent event, Throwable cause) {
        super(message, event, cause);
        this.extractMuleMessage(event);
        this.setMessage(this.generateMessage(message, null));
    }

    public MessagingException(I18nMessage message, CoreEvent event, Throwable cause, Component failingComponent) {
        super(message, event, cause);
        this.extractMuleMessage(event);
        this.failingComponent = failingComponent;
        this.setMessage(this.generateMessage(message, null));
    }

    public MessagingException(CoreEvent event, Throwable cause) {
        super(event, cause);
        this.extractMuleMessage(event);
        this.setMessage(this.generateMessage(this.getI18nMessage(), null));
    }

    public MessagingException(CoreEvent event, MessagingException original) {
        super(original.getI18nMessage(), event, original.getCause());
        this.failingComponent = original.getFailingComponent();
        this.handled = original.handled();
        this.addAllInfo(original.getInfo());
        this.extractMuleMessage(event);
        this.setMessage(original.getMessage());
    }

    public MessagingException(CoreEvent event, Throwable cause, Component failingComponent) {
        super(event, cause);
        this.extractMuleMessage(event);
        this.failingComponent = failingComponent;
        this.setMessage(this.generateMessage(this.getI18nMessage(), null));
    }

    protected String generateMessage(I18nMessage message, MuleContext muleContext) {
        if (this.muleMessage != null) {
            if (MuleException.isVerboseExceptions()) {
                Object payload = this.muleMessage.getPayload().getValue();
                if (this.muleMessage.getPayload().getDataType().isStreamType()) {
                    this.addInfo(PAYLOAD_INFO_KEY, StringUtils.abbreviate((String)payload.toString(), (int)1000));
                } else if (payload != null) {
                    this.addInfo(PAYLOAD_TYPE_INFO_KEY, this.muleMessage.getPayload().getDataType().getType().getName());
                } else {
                    this.addInfo(PAYLOAD_TYPE_INFO_KEY, Objects.toString(null));
                    this.addInfo(PAYLOAD_INFO_KEY, Objects.toString(null));
                }
            }
        } else {
            this.addInfo(PAYLOAD_INFO_KEY, Objects.toString(null));
        }
        return message.getMessage();
    }

    @Deprecated
    public Message getMuleMessage() {
        if (this.getEvent() != null) {
            return this.getEvent().getMessage();
        }
        return this.muleMessage;
    }

    @Override
    public CoreEvent getEvent() {
        return this.processedEvent != null ? this.processedEvent : super.getEvent();
    }

    public void setProcessedEvent(CoreEvent processedEvent) {
        if (processedEvent != null) {
            this.processedEvent = processedEvent;
            this.extractMuleMessage(processedEvent);
            processedEvent.getError().ifPresent(e -> this.getExceptionInfo().setErrorType(e.getErrorType()));
        } else {
            this.processedEvent = null;
            this.muleMessage = null;
        }
    }

    public boolean causedBy(Class e) {
        if (e == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        return ExceptionHelper.traverseCauseHierarchy(this, causeException -> {
            if (e.isAssignableFrom(causeException.getClass())) {
                return causeException;
            }
            return null;
        }) != null;
    }

    public boolean causedExactlyBy(Class<? extends Throwable> e) {
        if (e == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        return ExceptionHelper.traverseCauseHierarchy(this, causeException -> {
            if (causeException.getClass().equals(e)) {
                return causeException;
            }
            return null;
        }) != null;
    }

    public Throwable getRootCause() {
        Throwable rootException = ExceptionHelper.getRootException(this);
        if (rootException == null) {
            rootException = this;
        }
        return rootException;
    }

    public boolean causeMatches(String regex) {
        if (regex == null) {
            throw new IllegalArgumentException("regex cannot be null");
        }
        Boolean matched = ExceptionHelper.traverseCauseHierarchy(this, e -> e.getClass().getName().matches(regex));
        return matched != null && matched != false;
    }

    public void setHandled(boolean handled) {
        this.handled = handled;
    }

    public boolean handled() {
        return this.handled;
    }

    @Override
    public Component getFailingComponent() {
        return this.failingComponent;
    }

    protected void extractMuleMessage(CoreEvent event) {
        this.muleMessage = event == null ? null : event.getMessage();
    }

    private void writeObject(ObjectOutputStream out) throws Exception {
        out.defaultWriteObject();
        if (this.failingComponent instanceof Serializable) {
            out.writeBoolean(true);
            out.writeObject(this.failingComponent);
        } else {
            out.writeBoolean(false);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        boolean failingComponentWasSerialized = in.readBoolean();
        if (failingComponentWasSerialized) {
            this.failingComponent = (Component)in.readObject();
        }
    }

    @Override
    public String toString() {
        return super.toString() + "; ErrorType: " + this.getEvent().getError().map(e -> e.getErrorType().toString()).orElse("(None)");
    }
}

