/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.declaration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.SimpleType;
import org.mule.metadata.api.model.TimeType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ComposableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.construct.HasConstructModels;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.util.xmlsecurity.XMLSecureFactories;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterGroupElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.RouteElementDeclaration;
import org.mule.runtime.app.declaration.api.fluent.ArtifactDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ComponentElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConfigurationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConnectionElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConstructElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.HasNestedComponentDeclarer;
import org.mule.runtime.app.declaration.api.fluent.OperationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ParameterGroupElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ParameterListValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterObjectValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterSimpleValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterizedBuilder;
import org.mule.runtime.app.declaration.api.fluent.ParameterizedElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.RouteElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.SimpleValueType;
import org.mule.runtime.app.declaration.api.fluent.TopLevelParameterDeclarer;
import org.mule.runtime.config.api.dsl.processor.xml.XmlApplicationServiceRegistry;
import org.mule.runtime.config.internal.dsl.model.XmlArtifactDeclarationLoader;
import org.mule.runtime.config.internal.dsl.utils.DslConstants;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.core.api.source.scheduler.CronScheduler;
import org.mule.runtime.core.api.source.scheduler.FixedFrequencyScheduler;
import org.mule.runtime.dsl.api.xml.XmlNamespaceInfoProvider;
import org.mule.runtime.dsl.api.xml.parser.ConfigLine;
import org.mule.runtime.dsl.api.xml.parser.SimpleConfigAttribute;
import org.mule.runtime.dsl.api.xml.parser.XmlApplicationParserUtils;
import org.mule.runtime.dsl.api.xml.parser.XmlConfigurationDocumentLoader;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.declaration.type.annotation.ExtensibleTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.FlattenedTypeAnnotation;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.module.artifact.activation.internal.classloader.MuleApplicationClassLoader;
import org.w3c.dom.Document;
import org.xml.sax.helpers.DefaultHandler;

@Deprecated
public class DefaultXmlArtifactDeclarationLoader
implements XmlArtifactDeclarationLoader {
    public static final String TRANSFORM_IDENTIFIER = "transform";
    private static final String TRANSFORM_SCRIPT = "script";
    private static final String TRANSFORM_RESOURCE = "resource";
    private static final String TRANSFORM_VARIABLE_NAME = "variableName";
    private static final String MESSAGE_GROUP_NAME = "Message";
    private static final String SET_PAYLOAD_PARAM_NAME = "setPayload";
    private static final String SET_ATTRIBUTES_PARAM_NAME = "setAttributes";
    private static final String SET_VARIABLES_PARAM_NAME = "variables";
    private static final String SET_VARIABLES_GROUP_NAME = "Set Variables";
    private final DslResolvingContext context;
    private final Map<String, DslSyntaxResolver> resolvers;
    private final Map<String, ExtensionModel> extensionsByNamespace = new HashMap<String, ExtensionModel>();

    public DefaultXmlArtifactDeclarationLoader(DslResolvingContext context) {
        this.context = context;
        this.resolvers = context.getExtensions().stream().collect(Collectors.toMap(e -> e.getXmlDslModel().getNamespace(), e -> DslSyntaxResolver.getDefault(e, context)));
        this.context.getExtensions().forEach(e -> this.extensionsByNamespace.put(e.getXmlDslModel().getNamespace(), (ExtensionModel)e));
    }

    @Override
    public ArtifactDeclaration load(InputStream configResource) {
        return this.load("app.xml", configResource);
    }

    @Override
    public ArtifactDeclaration load(String name, InputStream configResource) {
        ConfigLine configLine = this.loadArtifactConfig(name, configResource);
        return this.declareArtifact(configLine);
    }

    private ConfigLine loadArtifactConfig(String name, InputStream resource) {
        Preconditions.checkArgument((resource != null ? 1 : 0) != 0, (Object)"The given application was not found as resource");
        Document document = XmlConfigurationDocumentLoader.noValidationDocumentLoader().loadDocument(() -> XMLSecureFactories.createDefault().getSAXParserFactory(), new DefaultHandler(), name, resource);
        XmlApplicationServiceRegistry xmlApplicationServiceRegistry = new XmlApplicationServiceRegistry(new SpiServiceRegistry(), this.context);
        return XmlApplicationParserUtils.parse(DefaultXmlArtifactDeclarationLoader.createFromPluginClassloaders(cl -> xmlApplicationServiceRegistry.lookupProviders(XmlNamespaceInfoProvider.class, (ClassLoader)cl).stream().collect(Collectors.toList()), MuleApplicationClassLoader.resolveContextArtifactPluginClassLoaders()), document.getDocumentElement()).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not load load a Configuration from the given resource")));
    }

    public static List<XmlNamespaceInfoProvider> createFromPluginClassloaders(Function<ClassLoader, List<XmlNamespaceInfoProvider>> xmlNamespaceInfoProvidersSupplier, List<ClassLoader> pluginsClassLoaders) {
        ImmutableList.Builder namespaceInfoProvidersBuilder = ImmutableList.builder();
        namespaceInfoProvidersBuilder.addAll((Iterable)xmlNamespaceInfoProvidersSupplier.apply(Thread.currentThread().getContextClassLoader()));
        for (ClassLoader pluginClassLoader : pluginsClassLoaders) {
            namespaceInfoProvidersBuilder.addAll((Iterable)xmlNamespaceInfoProvidersSupplier.apply(pluginClassLoader));
        }
        return namespaceInfoProvidersBuilder.build();
    }

    private ArtifactDeclaration declareArtifact(ConfigLine configLine) {
        ArtifactDeclarer artifactDeclarer = ElementDeclarer.newArtifact();
        configLine.getConfigAttributes().values().forEach(a -> artifactDeclarer.withCustomParameter(a.getName(), a.getValue()));
        configLine.getChildren().forEach(line -> this.declareElement((ConfigLine)line, artifactDeclarer));
        return (ArtifactDeclaration)artifactDeclarer.getDeclaration();
    }

    private void declareElement(final ConfigLine configLine, final ArtifactDeclarer artifactDeclarer) {
        final ExtensionModel ownerExtension = this.getExtensionModel(configLine);
        final ElementDeclarer extensionElementsDeclarer = ElementDeclarer.forExtension(ownerExtension.getName());
        final DslSyntaxResolver dsl = this.resolvers.get(this.getNamespace(configLine));
        final Reference<Boolean> alreadyDeclared = new Reference<Boolean>(false);
        new ExtensionWalker(){

            @Override
            protected void onConstruct(HasConstructModels owner, ConstructModel model) {
                DefaultXmlArtifactDeclarationLoader.this.declareComponentModel(configLine, model, extensionElementsDeclarer::newConstruct).ifPresent(declarer -> {
                    DefaultXmlArtifactDeclarationLoader.this.getDeclaredName(configLine).ifPresent(((ConstructElementDeclarer)declarer)::withRefName);
                    artifactDeclarer.withGlobalElement((GlobalElementDeclaration)declarer.getDeclaration());
                    alreadyDeclared.set(true);
                    this.stop();
                });
            }

            @Override
            protected void onConfiguration(ConfigurationModel model) {
                DslElementSyntax elementDsl = dsl.resolve(model);
                if (elementDsl.getElementName().equals(configLine.getIdentifier())) {
                    ConfigurationElementDeclarer configurationDeclarer = extensionElementsDeclarer.newConfiguration(model.getName());
                    DefaultXmlArtifactDeclarationLoader.this.getDeclaredName(configLine).ifPresent(configurationDeclarer::withRefName);
                    Map<String, SimpleConfigAttribute> attributes = configLine.getConfigAttributes().values().stream().filter(a -> !a.getName().equals("name")).collect(Collectors.toMap(SimpleConfigAttribute::getName, a -> a));
                    List configComplexParameters = configLine.getChildren().stream().filter(config -> DefaultXmlArtifactDeclarationLoader.this.declareAsConnectionProvider(ownerExtension, model, configurationDeclarer, config, extensionElementsDeclarer)).collect(Collectors.toList());
                    DefaultXmlArtifactDeclarationLoader.this.declareParameterizedComponent(model, elementDsl, configurationDeclarer, attributes, configComplexParameters);
                    artifactDeclarer.withGlobalElement((GlobalElementDeclaration)configurationDeclarer.getDeclaration());
                    alreadyDeclared.set(true);
                    this.stop();
                }
            }
        }.walk(ownerExtension);
        if (!alreadyDeclared.get().booleanValue()) {
            ownerExtension.getTypes().stream().filter(type -> dsl.resolve((MetadataType)type).map(typeDsl -> typeDsl.getElementName().equals(configLine.getIdentifier())).orElse(false)).findFirst().ifPresent(type -> {
                TopLevelParameterDeclarer topLevelParameter = extensionElementsDeclarer.newGlobalParameter(configLine.getIdentifier());
                this.getDeclaredName(configLine).ifPresent(topLevelParameter::withRefName);
                type.accept(this.getParameterDeclarerVisitor(configLine, dsl.resolve((MetadataType)type).get(), value -> topLevelParameter.withValue((ParameterObjectValue)value)));
                artifactDeclarer.withGlobalElement((GlobalElementDeclaration)topLevelParameter.getDeclaration());
            });
        }
    }

    private Optional<String> getDeclaredName(ConfigLine configLine) {
        return Optional.ofNullable(configLine.getConfigAttributes().get("name")).map(SimpleConfigAttribute::getValue);
    }

    private ExtensionModel getExtensionModel(ConfigLine line) {
        String namespace = this.getNamespace(line);
        ExtensionModel extensionModel = this.extensionsByNamespace.get(namespace);
        if (extensionModel == null) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Missing Extension model in the context for namespace [" + namespace + "]"));
        }
        return extensionModel;
    }

    private ExtensionWalker getComponentDeclaringWalker(final Consumer<ComponentElementDeclaration> declarationConsumer, final ConfigLine line, final ElementDeclarer extensionElementsDeclarer) {
        final DslSyntaxResolver dsl = this.resolvers.get(this.getNamespace(line));
        return new ExtensionWalker(){

            @Override
            protected void onOperation(HasOperationModels owner, OperationModel model) {
                if (!model.getName().equals(DefaultXmlArtifactDeclarationLoader.TRANSFORM_IDENTIFIER)) {
                    DefaultXmlArtifactDeclarationLoader.this.declareComponentModel(line, model, extensionElementsDeclarer::newOperation).ifPresent(declarer -> {
                        declarationConsumer.accept((ComponentElementDeclaration)declarer.getDeclaration());
                        this.stop();
                    });
                } else {
                    this.declareTransform(model);
                }
            }

            @Override
            protected void onSource(HasSourceModels owner, SourceModel model) {
                Map<String, SimpleConfigAttribute> successCallbackAttributes = this.filterSourceCallbackAttributes(line.getConfigAttributes(), model.getSuccessCallback(), entry -> true);
                Map<String, SimpleConfigAttribute> errorCallbackAttributes = this.filterSourceCallbackAttributes(line.getConfigAttributes(), model.getErrorCallback(), entry -> !successCallbackAttributes.containsKey(entry.getKey()));
                Map<String, SimpleConfigAttribute> sourceAttributes = this.filterAttributes(line.getConfigAttributes(), entry -> !successCallbackAttributes.containsKey(entry.getKey()) && !errorCallbackAttributes.containsKey(entry.getKey()));
                DefaultXmlArtifactDeclarationLoader.this.declareComponentModel(line.getNamespaceUri(), line.getIdentifier(), sourceAttributes, line.getChildren(), model, extensionElementsDeclarer::newSource).ifPresent(declarer -> {
                    DslElementSyntax elementDsl = dsl.resolve(model);
                    model.getSuccessCallback().ifPresent(cb -> DefaultXmlArtifactDeclarationLoader.this.declareParameterizedComponent(cb, elementDsl, declarer, successCallbackAttributes, line.getChildren()));
                    model.getErrorCallback().ifPresent(cb -> DefaultXmlArtifactDeclarationLoader.this.declareParameterizedComponent(cb, elementDsl, declarer, errorCallbackAttributes, line.getChildren()));
                    declarationConsumer.accept((ComponentElementDeclaration)declarer.getDeclaration());
                    this.stop();
                });
            }

            private Map<String, SimpleConfigAttribute> filterSourceCallbackAttributes(Map<String, SimpleConfigAttribute> configAttributes, Optional<SourceCallbackModel> sourceCallbackModel, Predicate<Map.Entry<String, SimpleConfigAttribute>> filterCondition) {
                if (sourceCallbackModel.isPresent()) {
                    Set parameterNames = sourceCallbackModel.map(callbackModel -> callbackModel.getAllParameterModels().stream().map(parameterModel -> parameterModel.getName()).collect(Collectors.toSet())).orElse(null);
                    return sourceCallbackModel.map(callbackModel -> this.filterAttributes(configAttributes, entry -> parameterNames.contains(entry.getKey()) && filterCondition.test((Map.Entry<String, SimpleConfigAttribute>)entry))).orElse(Collections.emptyMap());
                }
                return Collections.emptyMap();
            }

            private Map<String, SimpleConfigAttribute> filterAttributes(Map<String, SimpleConfigAttribute> configAttributes, Predicate<Map.Entry<String, SimpleConfigAttribute>> filterCondition) {
                return configAttributes.entrySet().stream().filter(filterCondition).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (SimpleConfigAttribute)entry.getValue()));
            }

            @Override
            protected void onConstruct(HasConstructModels owner, ConstructModel model) {
                DefaultXmlArtifactDeclarationLoader.this.declareComponentModel(line, model, extensionElementsDeclarer::newConstruct).ifPresent(declarer -> {
                    declarationConsumer.accept((ComponentElementDeclaration)declarer.getDeclaration());
                    this.stop();
                });
            }

            private Optional<ParameterGroupModel> getParameterGroup(ParameterizedModel model, String groupName) {
                return model.getParameterGroupModels().stream().filter(parameterGroupModel -> parameterGroupModel.getName().equals(groupName)).findFirst();
            }

            private void declareTransform(ComponentModel model) {
                DslElementSyntax elementDsl = dsl.resolve(model);
                if (model.getName().equals(DefaultXmlArtifactDeclarationLoader.TRANSFORM_IDENTIFIER) && elementDsl.getElementName().equals(line.getIdentifier())) {
                    OperationElementDeclarer transform = extensionElementsDeclarer.newOperation(DefaultXmlArtifactDeclarationLoader.TRANSFORM_IDENTIFIER);
                    line.getChildren().stream().filter(c -> c.getIdentifier().equals("message")).findFirst().ifPresent(messageConfig -> {
                        ParameterGroupElementDeclarer messageGroup = ElementDeclarer.newParameterGroup(DefaultXmlArtifactDeclarationLoader.MESSAGE_GROUP_NAME);
                        Optional<ParameterGroupModel> messageParameterGroup = this.getParameterGroup(model, DefaultXmlArtifactDeclarationLoader.MESSAGE_GROUP_NAME);
                        messageConfig.getChildren().stream().filter(c -> c.getIdentifier().equals("set-payload")).findFirst().ifPresent(payloadConfig -> {
                            ParameterObjectValue.Builder payload = ElementDeclarer.newObjectValue();
                            MetadataType setPayloadType = DefaultXmlArtifactDeclarationLoader.this.getGroupParameterType(messageParameterGroup, DefaultXmlArtifactDeclarationLoader.SET_PAYLOAD_PARAM_NAME);
                            DefaultXmlArtifactDeclarationLoader.this.populateTransformScriptParameter(payloadConfig, payload, setPayloadType);
                            messageGroup.withParameter(DefaultXmlArtifactDeclarationLoader.SET_PAYLOAD_PARAM_NAME, payload.build());
                        });
                        messageConfig.getChildren().stream().filter(c -> c.getIdentifier().equals("set-attributes")).findFirst().ifPresent(attributesConfig -> {
                            ParameterObjectValue.Builder attributes = ElementDeclarer.newObjectValue();
                            MetadataType setAttributesType = DefaultXmlArtifactDeclarationLoader.this.getGroupParameterType(messageParameterGroup, DefaultXmlArtifactDeclarationLoader.SET_ATTRIBUTES_PARAM_NAME);
                            DefaultXmlArtifactDeclarationLoader.this.populateTransformScriptParameter(attributesConfig, attributes, setAttributesType);
                            messageGroup.withParameter(DefaultXmlArtifactDeclarationLoader.SET_ATTRIBUTES_PARAM_NAME, attributes.build());
                        });
                        transform.withParameterGroup((ParameterGroupElementDeclaration)messageGroup.getDeclaration());
                    });
                    line.getChildren().stream().filter(c -> c.getIdentifier().equals(DefaultXmlArtifactDeclarationLoader.SET_VARIABLES_PARAM_NAME)).findFirst().ifPresent(variablesConfig -> {
                        ParameterGroupElementDeclarer variablesGroup = ElementDeclarer.newParameterGroup(DefaultXmlArtifactDeclarationLoader.SET_VARIABLES_GROUP_NAME);
                        Optional<ParameterGroupModel> setVariablesParameterGroup = this.getParameterGroup(model, DefaultXmlArtifactDeclarationLoader.SET_VARIABLES_GROUP_NAME);
                        ParameterListValue.Builder variables = ElementDeclarer.newListValue();
                        variablesConfig.getChildren().forEach(variableConfig -> {
                            ParameterObjectValue.Builder variable = ElementDeclarer.newObjectValue();
                            variable.withParameter(DefaultXmlArtifactDeclarationLoader.TRANSFORM_VARIABLE_NAME, variableConfig.getConfigAttributes().get(DefaultXmlArtifactDeclarationLoader.TRANSFORM_VARIABLE_NAME).getValue());
                            MetadataType setVariablesType = DefaultXmlArtifactDeclarationLoader.this.getGroupParameterType(setVariablesParameterGroup, DefaultXmlArtifactDeclarationLoader.SET_VARIABLES_PARAM_NAME);
                            DefaultXmlArtifactDeclarationLoader.this.populateTransformScriptParameter(variableConfig, variable, setVariablesType);
                            variables.withValue(variable.build());
                        });
                        transform.withParameterGroup((ParameterGroupElementDeclaration)variablesGroup.withParameter(DefaultXmlArtifactDeclarationLoader.SET_VARIABLES_PARAM_NAME, variables.build()).getDeclaration());
                    });
                    line.getConfigAttributes().values().forEach(a -> transform.withCustomParameter(a.getName(), a.getValue()));
                    declarationConsumer.accept((ComponentElementDeclaration)transform.getDeclaration());
                    this.stop();
                }
            }
        };
    }

    private MetadataType getGroupParameterType(Optional<ParameterGroupModel> messageParameterGroup, String paramName) {
        MetadataType metadataType = null;
        if (messageParameterGroup.isPresent()) {
            metadataType = this.getGroupParameterType(messageParameterGroup.get(), paramName);
        }
        return metadataType;
    }

    private MetadataType getGroupParameterType(ParameterGroupModel model, String paramName) {
        MetadataType metadataType = null;
        Optional<ParameterModel> parameter = model.getParameter(paramName);
        if (parameter.isPresent()) {
            metadataType = model.getParameter(paramName).get().getType();
        }
        return metadataType;
    }

    private boolean declareAsConnectionProvider(ExtensionModel ownerExtension, ConfigurationModel model, ConfigurationElementDeclarer configurationDeclarer, ConfigLine config, ElementDeclarer extensionElementsDeclarer) {
        DslSyntaxResolver dsl = this.resolvers.get(this.getNamespace(config));
        Optional<ConnectionProviderModel> connectionProvider = model.getConnectionProviders().stream().filter(cp -> dsl.resolve((NamedObject)cp).getElementName().equals(config.getIdentifier())).findFirst();
        if (!connectionProvider.isPresent()) {
            connectionProvider = ownerExtension.getConnectionProviders().stream().filter(cp -> dsl.resolve((NamedObject)cp).getElementName().equals(config.getIdentifier())).findFirst();
        }
        if (!connectionProvider.isPresent()) {
            return true;
        }
        ConnectionProviderModel providerModel = connectionProvider.get();
        ConnectionElementDeclarer connectionDeclarer = extensionElementsDeclarer.newConnection(providerModel.getName());
        this.declareParameterizedComponent(providerModel, dsl.resolve(providerModel), connectionDeclarer, config.getConfigAttributes(), config.getChildren());
        configurationDeclarer.withConnection((ConnectionElementDeclaration)connectionDeclarer.getDeclaration());
        return false;
    }

    private Optional<ComponentElementDeclarer> declareComponentModel(ConfigLine line, ComponentModel model, Function<String, ComponentElementDeclarer> declarerBuilder) {
        return this.declareComponentModel(line.getNamespaceUri(), line.getIdentifier(), line.getConfigAttributes(), line.getChildren(), model, declarerBuilder);
    }

    private Optional<ComponentElementDeclarer> declareComponentModel(String namespace, String identifier, Map<String, SimpleConfigAttribute> configAttributes, List<ConfigLine> children, ComponentModel model, Function<String, ComponentElementDeclarer> declarerBuilder) {
        DslElementSyntax elementDsl = this.resolvers.get(this.getNamespace(namespace)).resolve(model);
        if (elementDsl.getElementName().equals(identifier)) {
            ComponentElementDeclarer declarer = declarerBuilder.apply(model.getName());
            if (configAttributes.get("config-ref") != null) {
                declarer.withConfig(configAttributes.get("config-ref").getValue());
            }
            this.declareParameterizedComponent(model, elementDsl, declarer, configAttributes, children);
            this.declareComposableModel((ComposableModel)model, elementDsl, children, (HasNestedComponentDeclarer)declarer);
            return Optional.of(declarer);
        }
        return Optional.empty();
    }

    private void populateTransformScriptParameter(ConfigLine config, ParameterObjectValue.Builder builder, MetadataType type) {
        if (config.getConfigAttributes().containsKey(TRANSFORM_RESOURCE)) {
            builder.withParameter(TRANSFORM_RESOURCE, this.createParameterSimpleValue(config.getConfigAttributes().get(TRANSFORM_RESOURCE).getValue(), this.getChildMetadataType(type, TRANSFORM_RESOURCE)));
        }
        if (!StringUtils.isBlank((CharSequence)config.getTextContent())) {
            builder.withParameter(TRANSFORM_SCRIPT, ParameterSimpleValue.of(config.getTextContent(), SimpleValueType.STRING));
        }
        config.getConfigAttributes().entrySet().stream().filter(e -> !((String)e.getKey()).equals(TRANSFORM_RESOURCE)).map(Map.Entry::getValue).forEach(a -> {
            MetadataType childMetadataType = this.getChildMetadataType(type, a.getName());
            builder.withParameter(a.getName(), this.createParameterSimpleValue(a.getValue(), childMetadataType));
        });
    }

    private boolean isCData(ConfigLine config) {
        return config.getCustomAttributes().get("IS_CDATA") != null;
    }

    private void declareComposableModel(ComposableModel model, DslElementSyntax elementDsl, ConfigLine containerConfig, HasNestedComponentDeclarer declarer) {
        this.declareComposableModel(model, elementDsl, containerConfig.getChildren(), declarer);
    }

    private void declareComposableModel(ComposableModel model, DslElementSyntax elementDsl, List<ConfigLine> children, HasNestedComponentDeclarer declarer) {
        children.forEach(child -> {
            ExtensionModel extensionModel = this.getExtensionModel((ConfigLine)child);
            ElementDeclarer extensionElementsDeclarer = ElementDeclarer.forExtension(extensionModel.getName());
            Reference<Boolean> componentFound = new Reference<Boolean>(false);
            this.declareRoute(model, elementDsl, (ConfigLine)child, extensionElementsDeclarer).ifPresent(route -> {
                declarer.withComponent((ComponentElementDeclaration)route);
                componentFound.set(true);
            });
            if (!componentFound.get().booleanValue()) {
                this.getComponentDeclaringWalker(declaration -> declarer.withComponent((ComponentElementDeclaration)declaration), (ConfigLine)child, extensionElementsDeclarer).walk(extensionModel);
            }
        });
    }

    private Optional<RouteElementDeclaration> declareRoute(ComposableModel model, DslElementSyntax elementDsl, ConfigLine child, ElementDeclarer extensionElementsDeclarer) {
        return model.getNestedComponents().stream().filter(nestedModel -> elementDsl.getContainedElement(nestedModel.getName()).map(nestedDsl -> child.getIdentifier().equals(nestedDsl.getElementName())).orElse(false)).filter(nestedModel -> nestedModel instanceof NestedRouteModel).findFirst().map(nestedModel -> {
            RouteElementDeclarer routeDeclarer = extensionElementsDeclarer.newRoute(nestedModel.getName());
            DslElementSyntax routeDsl = elementDsl.getContainedElement(nestedModel.getName()).get();
            this.declareParameterizedComponent((ParameterizedModel)nestedModel, routeDsl, routeDeclarer, child.getConfigAttributes(), child.getChildren());
            this.declareComposableModel((ComposableModel)nestedModel, elementDsl, child, (HasNestedComponentDeclarer)routeDeclarer);
            return (RouteElementDeclaration)routeDeclarer.getDeclaration();
        });
    }

    private void declareParameterizedComponent(ParameterizedModel model, DslElementSyntax elementDsl, ParameterizedElementDeclarer declarer, Map<String, SimpleConfigAttribute> configAttributes, List<ConfigLine> children) {
        this.copyExplicitAttributes(model, configAttributes, declarer);
        this.declareChildParameters(model, elementDsl, children, declarer);
    }

    private void declareChildParameters(ParameterizedModel model, DslElementSyntax modelDsl, List<ConfigLine> children, ParameterizedElementDeclarer declarer) {
        model.getParameterGroupModels().forEach(group -> {
            if (group.isShowInDsl()) {
                modelDsl.getChild(group.getName()).ifPresent(groupDsl -> children.stream().filter(c -> c.getIdentifier().equals(groupDsl.getElementName())).findFirst().ifPresent(groupConfig -> this.declareInlineGroup((ParameterGroupModel)group, (DslElementSyntax)groupDsl, (ConfigLine)groupConfig, declarer)));
            } else {
                ParameterGroupElementDeclarer groupDeclarer = ElementDeclarer.newParameterGroup(group.getName());
                group.getParameterModels().forEach(param -> modelDsl.getChild(param.getName()).ifPresent(paramDsl -> {
                    if (ExtensionModelUtils.isInfrastructure(param)) {
                        this.handleInfrastructure((ParameterModel)param, children, declarer);
                    } else {
                        children.stream().filter(c -> c.getIdentifier().equals(paramDsl.getElementName())).findFirst().ifPresent(paramConfig -> param.getType().accept(this.getParameterDeclarerVisitor((ConfigLine)paramConfig, (DslElementSyntax)paramDsl, value -> groupDeclarer.withParameter(param.getName(), (ParameterValue)value))));
                    }
                }));
                if (!((ParameterGroupElementDeclaration)groupDeclarer.getDeclaration()).getParameters().isEmpty()) {
                    declarer.withParameterGroup((ParameterGroupElementDeclaration)groupDeclarer.getDeclaration());
                }
            }
        });
    }

    private void declareInlineGroup(ParameterGroupModel model, DslElementSyntax dsl, ConfigLine config, ParameterizedElementDeclarer groupContainer) {
        ParameterGroupElementDeclarer groupDeclarer = ElementDeclarer.newParameterGroup(model.getName());
        this.copyExplicitAttributes(config.getConfigAttributes(), groupDeclarer, model);
        this.declareComplexParameterValue(model, dsl, config.getChildren(), groupDeclarer);
        groupContainer.withParameterGroup((ParameterGroupElementDeclaration)groupDeclarer.getDeclaration());
    }

    private void declareComplexParameterValue(ParameterGroupModel group, DslElementSyntax groupDsl, List<ConfigLine> groupChilds, ParameterizedBuilder<String, ParameterValue, ?> groupBuilder) {
        groupChilds.forEach(child -> group.getParameterModels().stream().filter(param -> groupDsl.getChild(param.getName()).map(dsl -> dsl.getElementName().equals(child.getIdentifier())).orElse(false)).findFirst().ifPresent(param -> param.getType().accept(this.getParameterDeclarerVisitor((ConfigLine)child, groupDsl.getChild(param.getName()).get(), value -> groupBuilder.withParameter(param.getName(), (ParameterValue)value)))));
    }

    private MetadataTypeVisitor getParameterDeclarerVisitor(final ConfigLine config, final DslElementSyntax paramDsl, final Consumer<ParameterValue> valueConsumer) {
        return new MetadataTypeVisitor(){

            @Override
            protected void defaultVisit(MetadataType metadataType) {
                if (config.getTextContent() != null) {
                    valueConsumer.accept(DefaultXmlArtifactDeclarationLoader.this.isCData(config) ? DefaultXmlArtifactDeclarationLoader.this.createParameterSimpleCdataValue(config.getTextContent(), metadataType) : DefaultXmlArtifactDeclarationLoader.this.createParameterSimpleValue(config.getTextContent(), metadataType));
                }
            }

            @Override
            public void visitArrayType(ArrayType arrayType) {
                if (config.getChildren().isEmpty() && config.getTextContent() != null) {
                    valueConsumer.accept(DefaultXmlArtifactDeclarationLoader.this.isCData(config) ? DefaultXmlArtifactDeclarationLoader.this.createParameterSimpleCdataValue(config.getTextContent(), arrayType) : DefaultXmlArtifactDeclarationLoader.this.createParameterSimpleValue(config.getTextContent(), arrayType));
                } else {
                    ParameterListValue.Builder listBuilder = ElementDeclarer.newListValue();
                    config.getChildren().forEach(item -> arrayType.getType().accept(DefaultXmlArtifactDeclarationLoader.this.getParameterDeclarerVisitor(item, paramDsl.getGeneric(arrayType.getType()).get(), listBuilder::withValue)));
                    valueConsumer.accept(listBuilder.build());
                }
            }

            @Override
            public void visitObject(ObjectType objectType) {
                if (config.getConfigAttributes().isEmpty() && config.getChildren().isEmpty()) {
                    this.defaultVisit(objectType);
                    return;
                }
                ParameterObjectValue.Builder objectValue = ElementDeclarer.newObjectValue();
                if (ExtensionMetadataTypeUtils.isMap(objectType)) {
                    DefaultXmlArtifactDeclarationLoader.this.createMapValue(objectValue, config, objectType.getOpenRestriction().orElse(null));
                } else if (paramDsl.isWrapped()) {
                    if (config.getChildren().size() == 1) {
                        DefaultXmlArtifactDeclarationLoader.this.createWrappedObject(objectType, objectValue, config);
                    }
                } else {
                    DefaultXmlArtifactDeclarationLoader.this.createObjectValueFromType(objectType, objectValue, config, paramDsl);
                }
                valueConsumer.accept(objectValue.build());
            }
        };
    }

    private void createMapValue(ParameterObjectValue.Builder objectValue, ConfigLine config, MetadataType elementMetadataType) {
        config.getChildren().stream().map(ConfigLine::getConfigAttributes).forEach(entry -> {
            SimpleConfigAttribute entryKey = (SimpleConfigAttribute)entry.get("key");
            SimpleConfigAttribute entryValue = (SimpleConfigAttribute)entry.get("value");
            if (entryKey != null && entryValue != null) {
                objectValue.withParameter(entryKey.getValue(), this.createParameterSimpleValue(entryValue.getValue(), elementMetadataType));
            }
        });
    }

    private void createWrappedObject(ObjectType objectType, ParameterObjectValue.Builder objectValue, ConfigLine config) {
        ConfigLine wrappedConfig = config.getChildren().get(0);
        DslSyntaxResolver wrappedElementResolver = this.resolvers.get(this.getNamespace(wrappedConfig));
        Set<ObjectType> subTypes = this.context.getTypeCatalog().getSubTypes(objectType);
        if (!subTypes.isEmpty()) {
            subTypes.stream().filter(subType -> wrappedElementResolver.resolve((MetadataType)subType).map(dsl -> dsl.getElementName().equals(wrappedConfig.getIdentifier())).orElse(false)).findFirst().ifPresent(subType -> this.createObjectValueFromType((ObjectType)subType, objectValue, wrappedConfig, wrappedElementResolver.resolve((MetadataType)subType).get()));
        } else if (objectType.getAnnotation(ExtensibleTypeAnnotation.class).isPresent()) {
            this.createObjectValueFromType(objectType, objectValue, wrappedConfig, wrappedElementResolver.resolve(objectType).get());
        }
    }

    private void createObjectValueFromType(ObjectType objectType, ParameterObjectValue.Builder objectValue, ConfigLine config, DslElementSyntax paramDsl) {
        ExtensionMetadataTypeUtils.getId(objectType).ifPresent(objectValue::ofType);
        objectType.getFieldByName("config-ref").map(f -> config.getConfigAttributes().get("config-ref")).ifPresent(configRef -> objectValue.withParameter("config-ref", ParameterSimpleValue.of(configRef.getValue(), SimpleValueType.STRING)));
        this.copyExplicitAttributes(config.getConfigAttributes(), objectValue, objectType);
        config.getChildren().forEach(fieldConfig -> objectType.getFields().stream().filter(fieldType -> paramDsl.getContainedElement(MetadataTypeUtils.getLocalPart(fieldType)).map(fieldDsl -> fieldDsl.getElementName().equals(fieldConfig.getIdentifier())).orElse(false)).findFirst().ifPresent(fieldType -> fieldType.getValue().accept(this.getParameterDeclarerVisitor((ConfigLine)fieldConfig, paramDsl.getContainedElement(MetadataTypeUtils.getLocalPart(fieldType)).get(), fieldValue -> objectValue.withParameter(MetadataTypeUtils.getLocalPart(fieldType), (ParameterValue)fieldValue)))));
    }

    private void handleInfrastructure(ParameterModel paramModel, List<ConfigLine> declaredConfigs, ParameterizedElementDeclarer declarer) {
        switch (paramModel.getName()) {
            case "reconnection": {
                this.findAnyMatchingChildById(declaredConfigs, "reconnection").ifPresent(config -> {
                    ParameterObjectValue.Builder reconnection = ElementDeclarer.newObjectValue().ofType(config.getIdentifier());
                    this.copyExplicitAttributes(config.getConfigAttributes(), reconnection, paramModel.getType());
                    config.getChildren().forEach(child -> {
                        String paramName = child.getIdentifier().equals("reconnect") || child.getIdentifier().equals("reconnect-forever") ? "reconnectionStrategy" : child.getIdentifier();
                        MetadataType type = this.getChildMetadataType(paramModel.getType(), paramName, "reconnect");
                        ParameterObjectValue.Builder childBuilder = ElementDeclarer.newObjectValue().ofType(child.getIdentifier());
                        this.cloneAsDeclaration((ConfigLine)child, childBuilder, type);
                        reconnection.withParameter(paramName, childBuilder.build());
                    });
                    declarer.withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup("Connection").withParameter("reconnection", reconnection.build()).getDeclaration());
                });
                return;
            }
            case "reconnectionStrategy": {
                this.findAnyMatchingChildById(declaredConfigs, "reconnect", "reconnect-forever").ifPresent(config -> {
                    ParameterObjectValue.Builder reconnection = ElementDeclarer.newObjectValue().ofType(config.getIdentifier());
                    MetadataType childMetadataType = this.getChildMetadataType(paramModel.getType(), config.getIdentifier());
                    this.copyExplicitAttributes(config.getConfigAttributes(), reconnection, childMetadataType);
                    declarer.withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup("Connection").withParameter("reconnectionStrategy", reconnection.build()).getDeclaration());
                });
                return;
            }
            case "redeliveryPolicy": {
                this.findAnyMatchingChildById(declaredConfigs, "redelivery-policy").ifPresent(config -> {
                    ParameterObjectValue.Builder redelivery = ElementDeclarer.newObjectValue();
                    this.copyExplicitAttributes(config.getConfigAttributes(), redelivery, paramModel.getType());
                    declarer.withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("redeliveryPolicy", redelivery.build()).getDeclaration());
                });
                return;
            }
            case "expirationPolicy": {
                this.findAnyMatchingChildById(declaredConfigs, "expiration-policy").ifPresent(config -> {
                    ParameterObjectValue.Builder expiration = ElementDeclarer.newObjectValue();
                    this.copyExplicitAttributes(config.getConfigAttributes(), expiration, paramModel.getType());
                    declarer.withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("expirationPolicy", expiration.build()).getDeclaration());
                });
                return;
            }
            case "poolingProfile": {
                this.findAnyMatchingChildById(declaredConfigs, "pooling-profile").ifPresent(config -> {
                    ParameterObjectValue.Builder poolingProfile = ElementDeclarer.newObjectValue();
                    this.cloneAsDeclaration((ConfigLine)config, poolingProfile, paramModel.getType());
                    declarer.withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup("Connection").withParameter("poolingProfile", poolingProfile.build()).getDeclaration());
                });
                return;
            }
            case "streamingStrategy": {
                this.findAnyMatchingChildById(declaredConfigs, "repeatable-file-store-stream", "repeatable-in-memory-stream", "non-repeatable-stream").ifPresent(config -> {
                    ParameterObjectValue.Builder streaming = ElementDeclarer.newObjectValue().ofType(config.getIdentifier());
                    MetadataType childMetadataType = this.getChildMetadataType(paramModel.getType(), config.getIdentifier());
                    this.cloneAsDeclaration((ConfigLine)config, streaming, childMetadataType);
                    declarer.withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("streamingStrategy", streaming.build()).getDeclaration());
                });
                return;
            }
            case "tlsContext": {
                this.findAnyMatchingChildById(declaredConfigs, "context").ifPresent(config -> {
                    ParameterObjectValue.Builder tls = ElementDeclarer.newObjectValue();
                    this.copyExplicitAttributes(config.getConfigAttributes(), tls, paramModel.getType());
                    config.getChildren().forEach(child -> {
                        ParameterObjectValue.Builder childBuilder = ElementDeclarer.newObjectValue();
                        if (child.getIdentifier().equals("revocation-check")) {
                            child.getChildren().stream().findFirst().ifPresent(configLine -> {
                                MetadataType childMetadataType = this.getChildMetadataType(paramModel.getType(), "revocation-check", configLine.getIdentifier());
                                this.cloneAsDeclaration((ConfigLine)configLine, childBuilder, childMetadataType);
                                childBuilder.ofType(configLine.getIdentifier());
                            });
                        } else {
                            MetadataType childMetadataType = this.getChildMetadataType(paramModel.getType(), child.getIdentifier());
                            this.cloneAsDeclaration((ConfigLine)child, childBuilder, childMetadataType);
                        }
                        tls.withParameter(child.getIdentifier(), childBuilder.build());
                    });
                    declarer.withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("tlsContext", tls.build()).getDeclaration());
                });
                return;
            }
            case "schedulingStrategy": {
                this.findAnyMatchingChildById(declaredConfigs, "scheduling-strategy").ifPresent(config -> {
                    ParameterObjectValue.Builder schedulingStrategy = ElementDeclarer.newObjectValue().ofType(config.getIdentifier());
                    this.copyExplicitAttributes(config.getConfigAttributes(), schedulingStrategy, paramModel.getType());
                    config.getChildren().stream().filter(child -> child.getIdentifier().equals("fixed-frequency") || child.getIdentifier().equals("cron")).findFirst().ifPresent(strategy -> {
                        MetadataType strategyType;
                        ParameterObjectValue.Builder strategyObject = ElementDeclarer.newObjectValue();
                        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
                        if (strategy.getIdentifier().equals("fixed-frequency")) {
                            strategyType = typeLoader.load((Type)((Object)FixedFrequencyScheduler.class));
                        } else if (strategy.getIdentifier().equals("cron")) {
                            strategyType = typeLoader.load((Type)((Object)CronScheduler.class));
                        } else {
                            throw new IllegalArgumentException("Unknown type found for scheduling-strategy parameter: " + strategy.getIdentifier());
                        }
                        this.cloneAsDeclaration((ConfigLine)strategy, strategyObject, strategyType);
                        String typeId = ExtensionMetadataTypeUtils.getId(strategyType).orElseThrow(() -> new IllegalArgumentException("Missing TypeId for scheduling strategy implementation: " + strategy.getIdentifier()));
                        strategyObject.ofType(typeId);
                        declarer.withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("schedulingStrategy", strategyObject.build()).getDeclaration());
                    });
                });
                return;
            }
        }
    }

    private MetadataType getChildMetadataType(MetadataType parentMetadataType, String modelParamName) {
        return this.getChildMetadataType(parentMetadataType, modelParamName, modelParamName);
    }

    private MetadataType getChildMetadataType(MetadataType parentMetadataType, String configParamName, String modelParamName) {
        MetadataType childMetadataType;
        if (parentMetadataType instanceof ObjectFieldType) {
            parentMetadataType = ((ObjectFieldType)parentMetadataType).getValue();
        }
        if (parentMetadataType instanceof ObjectType) {
            childMetadataType = this.getMetadataTypeFromObjectType((ObjectType)parentMetadataType, configParamName, modelParamName);
        } else if (parentMetadataType instanceof UnionType) {
            childMetadataType = this.getChildMetadataTypeFromUnion((UnionType)parentMetadataType, modelParamName);
        } else if (parentMetadataType instanceof ArrayType) {
            childMetadataType = this.getChildMetadataType(((ArrayType)parentMetadataType).getType(), modelParamName, configParamName);
        } else {
            throw new IllegalStateException("Cannot obtain child parameter type from " + parentMetadataType.getClass().getName());
        }
        return childMetadataType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MetadataType getMetadataTypeFromObjectType(ObjectType objectMetadataType, String configParamName, String modelParamName) {
        Optional<ObjectFieldType> fieldByName = objectMetadataType.getFieldByName(configParamName);
        if (!fieldByName.isPresent()) return this.getMetadataTypeFromFlattenedFields(objectMetadataType, modelParamName);
        ObjectFieldType objectFieldType = fieldByName.get();
        if (objectFieldType.getValue() instanceof ObjectType) {
            return objectFieldType;
        }
        if (objectFieldType.getValue() instanceof SimpleType) {
            return objectFieldType.getValue();
        }
        if (!(objectFieldType.getValue() instanceof UnionType)) throw new IllegalStateException("Unsupported attribute type: " + objectFieldType.getValue().getClass().getName());
        return this.getChildMetadataTypeFromUnion((UnionType)objectFieldType.getValue(), modelParamName);
    }

    private MetadataType getChildMetadataTypeFromUnion(UnionType parentMetadataType, String modelParamName) {
        Optional<MetadataType> result = parentMetadataType.getTypes().stream().filter(metadataType -> metadataType.getAnnotation(TypeIdAnnotation.class).get().getValue().equals(modelParamName)).findFirst();
        return result.orElse(null);
    }

    private MetadataType getMetadataTypeFromFlattenedFields(ObjectType objectMetadataType, String modelParamName) {
        MetadataType childMetadataType = null;
        List flattenedFieldTypes = objectMetadataType.getFields().stream().filter(field -> field.getAnnotation(FlattenedTypeAnnotation.class).isPresent()).map(ObjectFieldType::getValue).collect(Collectors.toList());
        for (MetadataType flattenedFieldType : flattenedFieldTypes) {
            for (ObjectFieldType field2 : ((ObjectType)flattenedFieldType).getFields()) {
                if (!field2.getKey().getName().getLocalPart().equals(modelParamName)) continue;
                childMetadataType = field2.getValue();
                break;
            }
            if (childMetadataType == null) continue;
            break;
        }
        return childMetadataType;
    }

    private Optional<ConfigLine> findAnyMatchingChildById(List<ConfigLine> configs, String ... validIds) {
        List<String> ids = Arrays.asList(validIds);
        return configs.stream().filter(c -> ids.contains(c.getIdentifier())).findFirst();
    }

    private void cloneAsDeclaration(ConfigLine config, ParameterObjectValue.Builder objectValue, MetadataType metadataType) {
        this.copyExplicitAttributes(config.getConfigAttributes(), objectValue, metadataType);
        this.copyChildren(config, objectValue, metadataType);
    }

    private String getNamespace(ConfigLine configLine) {
        return this.getNamespace(configLine.getNamespaceUri());
    }

    private String getNamespace(String namespace) {
        return namespace == null ? DslConstants.CORE_NAMESPACE : namespace;
    }

    private void copyExplicitAttributes(Map<String, SimpleConfigAttribute> attributes, ParameterizedBuilder<String, ParameterValue, ?> builder, ParameterGroupModel group) {
        attributes.values().stream().filter(a -> !a.getName().equals("name") && !a.getName().equals("config-ref")).filter(a -> !a.isValueFromSchema()).forEach(a -> builder.withParameter(a.getName(), this.createParameterSimpleValue(a.getValue(), this.getGroupParameterType(group, a.getName()))));
    }

    private void copyExplicitAttributes(Map<String, SimpleConfigAttribute> attributes, ParameterizedBuilder<String, ParameterValue, ?> builder, MetadataType parentMetadataType) {
        attributes.values().stream().filter(a -> !a.getName().equals("name") && !a.getName().equals("config-ref")).filter(a -> !a.isValueFromSchema()).forEach(a -> builder.withParameter(a.getName(), this.createParameterSimpleValue(a.getValue(), this.getChildMetadataType(parentMetadataType, a.getName()))));
    }

    private void copyExplicitAttributes(ParameterizedModel model, Map<String, SimpleConfigAttribute> attributes, ParameterizedElementDeclarer builder) {
        attributes.values().stream().filter(a -> !a.getName().equals("config-ref")).filter(a -> !a.isValueFromSchema()).forEach(a -> {
            Optional<ParameterGroupModel> ownerGroup = model.getParameterGroupModels().stream().filter(group -> group.getParameter(a.getName()).isPresent()).findFirst();
            if (ownerGroup.isPresent()) {
                builder.withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup(ownerGroup.get().getName()).withParameter(a.getName(), this.createParameterSimpleValue(a.getValue(), this.getGroupParameterType(ownerGroup, a.getName()))).getDeclaration());
            } else if (!a.getName().equals("name")) {
                builder.withCustomParameter(a.getName(), a.getValue());
            }
        });
    }

    private void copyChildren(ConfigLine config, ParameterizedBuilder<String, ParameterValue, ?> builder, MetadataType metadataType) {
        config.getChildren().forEach(child -> {
            ParameterObjectValue.Builder childBuilder = ElementDeclarer.newObjectValue();
            MetadataType childMetadataType = this.getChildMetadataType(metadataType, child.getIdentifier());
            this.cloneAsDeclaration((ConfigLine)child, childBuilder, childMetadataType);
            builder.withParameter(child.getIdentifier(), childBuilder.build());
        });
    }

    private ParameterValue createParameterSimpleValue(String a, MetadataType type) {
        return ParameterSimpleValue.of(a, this.getSimpleTypeFromMetadataType(type));
    }

    private ParameterValue createParameterSimpleCdataValue(String a, MetadataType type) {
        return ParameterSimpleValue.cdata(a, this.getSimpleTypeFromMetadataType(type));
    }

    private SimpleValueType getSimpleTypeFromMetadataType(MetadataType type) {
        if (type instanceof DateTimeType) {
            return SimpleValueType.DATETIME;
        }
        if (type instanceof TimeType) {
            return SimpleValueType.TIME;
        }
        if (type instanceof BooleanType) {
            return SimpleValueType.BOOLEAN;
        }
        if (type instanceof NumberType) {
            return SimpleValueType.NUMBER;
        }
        return SimpleValueType.STRING;
    }
}

