/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.validation.ArtifactValidation;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;

public class MelNotEnabled
implements ArtifactValidation {
    private final boolean compatibilityInstalled;

    public MelNotEnabled(boolean compatibilityInstalled) {
        this.compatibilityInstalled = compatibilityInstalled;
    }

    @Override
    public String getName() {
        return "MEL not enabled";
    }

    @Override
    public String getDescription() {
        return "Properties or configs used to enable MEL support are not present";
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.WARN;
    }

    @Override
    public List<ValidationResultItem> validateMany(ArtifactAst artifact) {
        if (this.compatibilityInstalled) {
            return Collections.singletonList(ValidationResultItem.create(Collections.emptyList(), (Validation)this, "Deployed artifact uses the compatibility plugin."));
        }
        if (this.isMelDefault()) {
            return Collections.singletonList(ValidationResultItem.create(Collections.emptyList(), (Validation)this, "Runtime has the 'mule.test.mel.default' system property set to true."));
        }
        return Collections.emptyList();
    }

    private boolean isMelDefault() {
        return Boolean.valueOf(System.getProperty("mule.test.mel.default", "false"));
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        return h -> true;
    }

    @Override
    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        return this.validate(artifact);
    }
}

