/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.config.internal.validation.AbstractErrorTypesValidation;

public class RaiseErrorTypeReferencesExist
extends AbstractErrorTypesValidation {
    public RaiseErrorTypeReferencesExist(Optional<FeatureFlaggingService> featureFlaggingService, boolean ignoreParamsWithProperties) {
        super(featureFlaggingService, ignoreParamsWithProperties);
    }

    @Override
    public String getName() {
        return "Error Type references exist";
    }

    @Override
    public String getDescription() {
        return "Referenced error types do exist in the context of the artifact.";
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(ComponentAstPredicatesFactory.equalsIdentifier(RAISE_ERROR_IDENTIFIER).and(this::isErrorTypePresent));
    }

    @Override
    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        ComponentIdentifier errorTypeId;
        ComponentParameterAst errorTypeParam = this.getErrorTypeParam(component);
        String errorTypeString = errorTypeParam.getResolvedRawValue();
        Set errorNamespaces = artifact.dependencies().stream().map(d -> d.getXmlDslModel().getPrefix().toUpperCase()).collect(Collectors.toSet());
        if (errorNamespaces.contains((errorTypeId = RaiseErrorTypeReferencesExist.parseErrorType(errorTypeString)).getNamespace())) {
            return RaiseErrorTypeReferencesExist.validateErrorTypeId(component, errorTypeParam, artifact, this, errorTypeString, errorTypeId);
        }
        if (artifact.getParent().map(p -> p.getErrorTypeRepository().getErrorNamespaces().contains(errorTypeId.getNamespace())).orElse(false).booleanValue()) {
            return Optional.of(ValidationResultItem.create(component, errorTypeParam, (Validation)this, String.format("Cannot use error type '%s': namespace already exists.", errorTypeString)));
        }
        return Optional.empty();
    }
}

