/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.internal;

import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.util.MuleSystemProperties;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.container.internal.ClasspathModuleDiscoverer;
import org.mule.runtime.container.internal.JpmsModuleLayerModuleDiscoverer;
import org.mule.runtime.container.internal.ModuleDiscoverer;
import org.mule.runtime.jpms.api.MuleContainerModule;

public class JpmsModuleLayerModuleDiscoverer
implements ModuleDiscoverer {
    private final ClasspathModuleDiscoverer fallbackClasspathModuleDiscoverer;

    public JpmsModuleLayerModuleDiscoverer(ClasspathModuleDiscoverer fallbackClasspathModuleDiscoverer) {
        this.fallbackClasspathModuleDiscoverer = fallbackClasspathModuleDiscoverer;
    }

    @Override
    public List<MuleContainerModule> discover() {
        if (!MuleSystemProperties.classloaderContainerJpmsModuleLayer()) {
            return this.fallbackClasspathModuleDiscoverer.discover();
        }
        List<MuleContainerModule> discoveredModules = this.getModules(this.getClass().getModule().getLayer()).stream().map(jpmsModule -> {
            if (jpmsModule.getDescriptor().isAutomatic()) {
                MuleModule muleModule;
                block11: {
                    InputStream stream = jpmsModule.getResourceAsStream("/" + this.fallbackClasspathModuleDiscoverer.getModulePropertiesFileName());
                    try {
                        Properties moduleProperties = new Properties();
                        if (stream != null) {
                            moduleProperties.load(stream);
                        } else {
                            moduleProperties.put("module.name", jpmsModule.getName());
                        }
                        muleModule = this.fallbackClasspathModuleDiscoverer.createModule(moduleProperties);
                        if (stream == null) break block11;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Cannot create fallback muleContainer module for '" + jpmsModule.getName() + "'", e);
                        }
                    }
                    stream.close();
                }
                return muleModule;
            }
            return new JpmsMuleContainerModule(this, jpmsModule);
        }).collect(Collectors.toList());
        ModuleLayer.boot().modules().stream().filter(jpmsModule -> jpmsModule.getName().startsWith("org.mule.runtime.") || jpmsModule.getName().startsWith("com.mulesoft.mule.")).map(x$0 -> new JpmsMuleContainerModule(this, x$0)).forEach(discoveredModules::add);
        return discoveredModules;
    }

    private Set<Module> getModules(ModuleLayer layer) {
        HashSet<Module> modules = new HashSet<Module>(layer.modules());
        for (ModuleLayer parent : layer.parents()) {
            modules.addAll(this.getModules(parent));
        }
        return modules.stream().filter(module -> module.getName().startsWith("org.mule") || module.getName().startsWith("com.mulesoft")).collect(Collectors.toSet());
    }
}

