/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.extension.provider;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Properties;
import java.util.function.Supplier;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.catalog.api.PrimitiveTypesTypeLoader;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelDeclarer;
import org.mule.runtime.core.api.extension.provider.MuleOperationExtensionModelDeclarer;
import org.mule.runtime.core.api.extension.provider.TlsExtensionModelDeclarer;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.extension.api.loader.ExtensionModelLoadingRequest;
import org.mule.runtime.extension.api.metadata.ComponentMetadataConfigurerFactory;

public final class MuleExtensionModelProvider {
    private static final MuleVersion PARSED_MULE_VERSION;
    public static final String MULE_NAME = "mule";
    public static final String MULE_VERSION;
    public static final String MULESOFT_VENDOR = "MuleSoft, Inc.";
    public static final String MULE_TLS_NAMESPACE;
    public static final String MULE_TLS_SCHEMA_LOCATION = "http://www.mulesoft.org/schema/mule/tls/current/mule-tls.xsd";
    public static final ClassTypeLoader TYPE_LOADER;
    public static final BaseTypeBuilder BASE_TYPE_BUILDER;
    public static final MetadataType STRING_TYPE;
    public static final MetadataType INTEGER_TYPE;
    public static final MetadataType NUMBER_TYPE;
    public static final MetadataType BOOLEAN_TYPE;
    public static final MetadataType NULL_TYPE;
    public static final MetadataType ANY_TYPE;
    public static final MetadataType VOID_TYPE;
    public static final MetadataType OBJECT_STORE_TYPE;
    private static ComponentMetadataConfigurerFactory configurerFactory;
    private static final LazyValue<ExtensionModel> EXTENSION_MODEL;
    private static final LazyValue<ExtensionModel> TLS_EXTENSION_MODEL;
    private static final LazyValue<ExtensionModel> OPERATION_DSL_EXTENSION_MODEL;

    private static MetadataType loadPrimitive(String id) {
        return PrimitiveTypesTypeLoader.PRIMITIVE_TYPES.get(id);
    }

    private static ExtensionModelLoadingRequest loadingRequest() {
        return ExtensionModelLoadingRequest.builder(MuleExtensionModelProvider.class.getClassLoader(), DslResolvingContext.nullDslResolvingContext()).build();
    }

    public static ExtensionModel getExtensionModel() {
        return EXTENSION_MODEL.get();
    }

    public static ExtensionModel getTlsExtensionModel() {
        return TLS_EXTENSION_MODEL.get();
    }

    public static ExtensionModel getOperationDslExtensionModel() {
        return OPERATION_DSL_EXTENSION_MODEL.get();
    }

    public static MuleVersion getMuleVersion() {
        return PARSED_MULE_VERSION;
    }

    public static void setConfigurerFactory(ComponentMetadataConfigurerFactory componentMetadataConfigurerFactory) {
        configurerFactory = componentMetadataConfigurerFactory;
    }

    static {
        MULE_TLS_NAMESPACE = String.format("http://www.mulesoft.org/schema/mule/%s", "tls");
        TYPE_LOADER = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(MuleExtensionModelProvider.class.getClassLoader());
        BASE_TYPE_BUILDER = BaseTypeBuilder.create(MetadataFormat.JAVA);
        STRING_TYPE = MuleExtensionModelProvider.loadPrimitive("string");
        INTEGER_TYPE = TYPE_LOADER.load((Type)((Object)Integer.class));
        NUMBER_TYPE = MuleExtensionModelProvider.loadPrimitive("number");
        BOOLEAN_TYPE = MuleExtensionModelProvider.loadPrimitive("boolean");
        NULL_TYPE = BASE_TYPE_BUILDER.nullType().build();
        ANY_TYPE = MuleExtensionModelProvider.loadPrimitive("any");
        VOID_TYPE = BASE_TYPE_BUILDER.voidType().build();
        OBJECT_STORE_TYPE = TYPE_LOADER.load((Type)((Object)ObjectStore.class));
        configurerFactory = ComponentMetadataConfigurerFactory.getDefault();
        try {
            Properties buildProperties = new Properties();
            buildProperties.load(MuleExtensionModelDeclarer.class.getResourceAsStream("/build.properties"));
            MULE_VERSION = buildProperties.getProperty("muleVersion", "4.0.0");
        }
        catch (IOException e) {
            throw new MuleRuntimeException(e);
        }
        PARSED_MULE_VERSION = new MuleVersion(MULE_VERSION);
        EXTENSION_MODEL = new LazyValue<Supplier<ExtensionModel>>(() -> new MuleCoreExtensionModelLoader(MULE_NAME).loadExtensionModel(new MuleExtensionModelDeclarer(configurerFactory).createExtensionModel(), MuleExtensionModelProvider.loadingRequest()));
        TLS_EXTENSION_MODEL = new LazyValue<Supplier<ExtensionModel>>(() -> new MuleCoreExtensionModelLoader("mule-tls").loadExtensionModel(new TlsExtensionModelDeclarer().createExtensionModel(), MuleExtensionModelProvider.loadingRequest()));
        OPERATION_DSL_EXTENSION_MODEL = new LazyValue<Supplier<ExtensionModel>>(() -> new MuleCoreExtensionModelLoader("mule-operationDsl").loadExtensionModel(new MuleOperationExtensionModelDeclarer().declareExtensionModel(), MuleExtensionModelProvider.loadingRequest()));
    }

    private static final class MuleCoreExtensionModelLoader
    extends ExtensionModelLoader {
        private final String id;

        public MuleCoreExtensionModelLoader(String id) {
            this.id = id;
        }

        @Override
        protected void declareExtension(ExtensionLoadingContext context) {
        }

        @Override
        public String getId() {
            return this.id;
        }
    }
}

