/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.extension;

import java.util.ArrayList;
import java.util.List;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.el.TypeBindings;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.el.ExpressionLanguageUtils;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.privileged.metadata.InternalMetadataContext;

public class ForEachCollectionTypeResolver
implements InputTypeResolver<String> {
    @Override
    public String getCategoryName() {
        return "FOREACH";
    }

    @Override
    public String getResolverName() {
        return "FOREACH_INPUT_COLLECTION";
    }

    @Override
    public MetadataType getInputMetadata(MetadataContext context, String key) throws MetadataResolvingException, ConnectionException {
        if (!(context instanceof InternalMetadataContext)) {
            throw new MetadataResolvingException("Internal error: missing required contextual data", FailureCode.UNKNOWN);
        }
        InternalMetadataContext internalContext = (InternalMetadataContext)context;
        if (!internalContext.getExpressionLanguageMetadataService().isPresent() || !internalContext.getTypeBindings().isPresent()) {
            return MuleExtensionModelProvider.ANY_TYPE;
        }
        String expression = ExpressionLanguageUtils.sanitize(key);
        MetadataType resolvedType = this.resolveExpressionType(internalContext.getTypeBindings().get(), internalContext.getExpressionLanguageMetadataService().get(), expression);
        if (!(resolvedType instanceof ArrayType)) {
            throw new IllegalArgumentException(String.format("Expression `%s` does not resolve to a collection", expression));
        }
        return ((ArrayType)resolvedType).getType();
    }

    private MetadataType resolveExpressionType(TypeBindings typeBindings, ExpressionLanguageMetadataService expressionLanguageMetadataService, String expression) throws MetadataResolvingException {
        ErrorTrackingMetadataServiceCallback errorsTracker = new ErrorTrackingMetadataServiceCallback();
        MetadataType resolvedType = expressionLanguageMetadataService.getOutputType(typeBindings, expression, errorsTracker);
        if (errorsTracker.getErrorsFound().isEmpty()) {
            return resolvedType;
        }
        throw new MetadataResolvingException(String.format("Error resolving metadata from expression %s: %s", expression, errorsTracker.getErrorsFound().get(0)), FailureCode.UNKNOWN);
    }

    private static class ErrorTrackingMetadataServiceCallback
    implements ExpressionLanguageMetadataService.MessageCallback {
        private final List<String> errorsFound = new ArrayList<String>();

        private ErrorTrackingMetadataServiceCallback() {
        }

        @Override
        public void warning(String message, ExpressionLanguageMetadataService.MessageLocation location) {
        }

        @Override
        public void error(String message, ExpressionLanguageMetadataService.MessageLocation location) {
            this.errorsFound.add(message);
        }

        public List<String> getErrorsFound() {
            return this.errorsFound;
        }
    }
}

