/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.api;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.mule.api.annotation.NoExtend;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.util.IOUtils;

@NoExtend
@NoInstantiate
public final class ConfigResource {
    private static final List<String> CLASS_PATH_ENTRIES;
    private static final boolean isWindows;
    private static Pattern JAR_FILE_FROM_RESOURCE_PATTERN;
    protected String resourceName;
    private URL url;
    private InputStream inputStream;
    private long lastModifiedDate = 0L;

    public ConfigResource(String resourceName) throws IOException {
        this(resourceName, IOUtils.getResourceAsUrl(resourceName, ConfigResource.class, true, true));
    }

    public ConfigResource(URL url) {
        this.url = url;
        if (url.getProtocol().equals("jar")) {
            this.resourceName = url.toExternalForm().split("!/")[1];
        } else if (url.getProtocol().equals("file")) {
            String updatedUrl = isWindows && url.getPath().startsWith("/") ? url.getPath().substring(1) : url.getPath();
            this.resourceName = CLASS_PATH_ENTRIES.stream().filter(cp -> updatedUrl.startsWith((String)cp)).findAny().map(cp -> updatedUrl.substring(cp.length() + 1)).orElse(url.toExternalForm());
        } else {
            this.resourceName = url.toExternalForm();
        }
    }

    public ConfigResource(String resourceName, URL url) throws IOException {
        this.resourceName = resourceName;
        if (url == null) {
            throw new FileNotFoundException(resourceName);
        }
        this.url = url;
    }

    public ConfigResource(String resourceName, InputStream inputStream) {
        this(resourceName, inputStream, 0L);
    }

    public ConfigResource(String resourceName, InputStream inputStream, long lastModifiedDate) {
        this.resourceName = resourceName;
        this.inputStream = inputStream;
        this.lastModifiedDate = lastModifiedDate;
    }

    public InputStream getInputStream() throws IOException {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        if (this.url != null) {
            URLConnection urlConnection = this.url.openConnection();
            if (urlConnection instanceof JarURLConnection) {
                urlConnection.setUseCaches(false);
            }
            return urlConnection.getInputStream();
        }
        return null;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public boolean isStreamOpen() {
        return this.inputStream != null;
    }

    public long getLastModified() {
        if (this.getUrl() == null) {
            return this.lastModifiedDate;
        }
        if (this.getUrl().toString().startsWith("jar:file:")) {
            Matcher matcher = JAR_FILE_FROM_RESOURCE_PATTERN.matcher(this.getUrl().toString());
            if (matcher.matches()) {
                String path = matcher.group(1);
                return new File(path).lastModified();
            }
            return 0L;
        }
        try {
            return new File(this.getUrl().toURI()).lastModified();
        }
        catch (URISyntaxException e) {
            return 0L;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigResource that = (ConfigResource)o;
        return !(this.resourceName != null ? !this.resourceName.equals(that.resourceName) : that.resourceName != null);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.resourceName != null ? this.resourceName.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConfigResource");
        sb.append("{resourceName='").append(this.resourceName).append('\'');
        sb.append('}');
        return sb.toString();
    }

    static {
        isWindows = System.getProperty("os.name").toLowerCase().contains("windows");
        JAR_FILE_FROM_RESOURCE_PATTERN = Pattern.compile("^jar:file:(.*[.]jar)!/.*");
        String classPath = System.getProperty("java.class.path");
        String modulePath = System.getProperty("jdk.module.path");
        String pathSeparator = System.getProperty("path.separator");
        List allClassPathEntries = (modulePath != null ? Stream.concat(Stream.of(classPath.split(pathSeparator)), Stream.of(modulePath.split(pathSeparator))) : Stream.of(classPath.split(pathSeparator))).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        CLASS_PATH_ENTRIES = allClassPathEntries.stream().map(line -> line.replace("\\", "/")).collect(Collectors.toList());
    }
}

