/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metadata.api.dsl;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;

public class DslElementModel<T> {
    public static final String COMPONENT_AST_KEY = "ComponentAst";
    private final T model;
    private final String value;
    private final DslElementSyntax dsl;
    private final boolean explicitInDsl;
    private final List<DslElementModel> containedElements;
    private final ComponentConfiguration configuration;
    private final ComponentIdentifier identifier;

    private DslElementModel(T model, DslElementSyntax dsl, List<DslElementModel> containedElements, ComponentConfiguration configuration, String value, boolean explicitInDsl) {
        this.dsl = dsl;
        this.model = model;
        this.containedElements = ImmutableList.copyOf(containedElements);
        this.configuration = configuration;
        this.value = value;
        this.identifier = this.createIdentifier();
        this.explicitInDsl = explicitInDsl;
    }

    public T getModel() {
        return this.model;
    }

    public DslElementSyntax getDsl() {
        return this.dsl;
    }

    public List<DslElementModel> getContainedElements() {
        return this.containedElements;
    }

    public Optional<ComponentIdentifier> getIdentifier() {
        return Optional.ofNullable(this.identifier);
    }

    @Deprecated
    public Optional<ComponentConfiguration> getConfiguration() {
        return Optional.ofNullable(this.configuration);
    }

    public Optional<ComponentAst> getComponentModel() {
        return this.configuration == null ? Optional.empty() : this.configuration.getProperty(COMPONENT_AST_KEY).map(cm -> (ComponentAst)cm);
    }

    public Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }

    public boolean isExplicitInDsl() {
        return this.explicitInDsl;
    }

    public <E> Optional<DslElementModel<E>> findElement(ComponentIdentifier identifier) {
        if (this.identifier != null && this.identifier.equals(identifier)) {
            return Optional.of(this);
        }
        return this.find(e -> e.findElement(identifier));
    }

    public <E> Optional<DslElementModel<E>> findElement(String modelName) {
        if (this.dsl.getAttributeName().equals(modelName) || this.model instanceof NamedObject && ((NamedObject)this.model).getName().equals(modelName)) {
            return Optional.of(this);
        }
        return this.find(e -> e.findElement(modelName));
    }

    private ComponentIdentifier createIdentifier() {
        if (this.configuration != null) {
            return this.configuration.getIdentifier();
        }
        if (!this.dsl.supportsTopLevelDeclaration() && !this.dsl.supportsChildDeclaration()) {
            return null;
        }
        return ComponentIdentifier.builder().name(this.dsl.getElementName()).namespace(this.dsl.getPrefix()).build();
    }

    private <E> Optional<DslElementModel<E>> find(Function<DslElementModel, Optional<DslElementModel>> finder) {
        return this.containedElements.stream().map(finder).filter(Optional::isPresent).map(Optional::get).map(e -> e).findFirst();
    }

    public static <M> Builder<M> builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DslElementModel that = (DslElementModel)o;
        return this.explicitInDsl == that.explicitInDsl && Objects.equals(this.model, that.model) && Objects.equals(this.value, that.value) && Objects.equals(this.dsl, that.dsl) && Objects.equals(this.containedElements, that.containedElements) && Objects.equals(this.configuration, that.configuration) && Objects.equals(this.identifier, that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.model, this.value, this.dsl, this.explicitInDsl, this.containedElements, this.configuration, this.identifier);
    }

    public String toString() {
        return DslElementModel.class.getSimpleName() + "(" + (this.identifier != null ? this.identifier.toString() : "") + ")";
    }

    public static final class Builder<M> {
        private M model;
        private String value;
        private DslElementSyntax dsl;
        private ComponentConfiguration configuration;
        private final List<DslElementModel> contained = new ArrayList<DslElementModel>();
        private boolean explicitInDsl = true;

        private Builder() {
        }

        public Builder<M> withModel(M model) {
            this.model = model;
            return this;
        }

        public Builder<M> withDsl(DslElementSyntax dsl) {
            this.dsl = dsl;
            return this;
        }

        public Builder<M> containing(DslElementModel element) {
            this.contained.add(element);
            return this;
        }

        @Deprecated
        public Builder<M> withConfig(ComponentConfiguration element) {
            this.configuration = element;
            return this;
        }

        public Builder<M> withConfig(ComponentAst element) {
            this.configuration = element != null ? this.from(element) : null;
            return this;
        }

        public Builder<M> withGroupConfig(ComponentAst paramsOwner, ParameterGroupModel dslGroup) {
            this.configuration = paramsOwner != null ? this.from(paramsOwner, dslGroup) : null;
            return this;
        }

        private ComponentConfiguration from(ComponentAst element) {
            ComponentConfiguration.Builder builder = ComponentConfiguration.builder().withIdentifier(element.getIdentifier());
            ArrayList dslGroupsAsChildrenNames = new ArrayList();
            element.getModel(ParameterizedModel.class).ifPresent(pmzd -> {
                if (pmzd instanceof SourceModel) {
                    ((SourceModel)pmzd).getSuccessCallback().ifPresent(cbk -> cbk.getParameterGroupModels().forEach(pmg -> this.fromSourceCallbackGroup((ParameterGroupModel)pmg, element, dslGroupsAsChildrenNames, builder)));
                    ((SourceModel)pmzd).getErrorCallback().ifPresent(cbk -> cbk.getParameterGroupModels().forEach(pmg -> this.fromSourceCallbackGroup((ParameterGroupModel)pmg, element, dslGroupsAsChildrenNames, builder)));
                }
                pmzd.getParameterGroupModels().forEach(pmg -> this.fromGroup((ParameterGroupModel)pmg, element, dslGroupsAsChildrenNames, builder));
            });
            element.directChildrenStream().forEach(i -> builder.withNestedComponent(this.from((ComponentAst)i)));
            element.getMetadata().getParserAttributes().forEach(builder::withProperty);
            builder.withComponentLocation(element.getLocation());
            builder.withProperty(DslElementModel.COMPONENT_AST_KEY, element);
            return builder.build();
        }

        private ComponentConfiguration from(ComponentAst paramsOwner, ParameterGroupModel dslGroup) {
            return paramsOwner.getGenerationInformation().getSyntax().flatMap(ownerSyntax -> ownerSyntax.getChild(dslGroup.getName())).map(groupSyntax -> {
                ComponentIdentifier groupIdentifier = ComponentIdentifier.builder().name(groupSyntax.getElementName()).namespace(groupSyntax.getPrefix()).namespaceUri(groupSyntax.getNamespace()).build();
                ComponentConfiguration.Builder builder = ComponentConfiguration.builder().withIdentifier(groupIdentifier);
                dslGroup.getParameterModels().forEach(pm -> {
                    ComponentParameterAst param = paramsOwner.getParameter(dslGroup.getName(), pm.getName());
                    this.handleParam(param, param.getModel().getType(), builder);
                });
                return builder.build();
            }).get();
        }

        protected void fromSourceCallbackGroup(ParameterGroupModel pmg, ComponentAst element, List<ComponentIdentifier> dslGroupsAsChildrenNames, ComponentConfiguration.Builder builder) {
            if (pmg.isShowInDsl()) {
                this.fromDslGroup(pmg, element, dslGroupsAsChildrenNames, builder);
            } else {
                pmg.getParameterModels().forEach(pm -> {
                    ComponentParameterAst param = element.getParameter(pmg.getName(), pm.getName());
                    if (param != null && param.getValue().getValue().isPresent()) {
                        this.handleParam(param, param.getModel().getType(), builder);
                    }
                });
            }
        }

        protected void fromGroup(ParameterGroupModel pmg, ComponentAst element, List<ComponentIdentifier> dslGroupsAsChildrenNames, ComponentConfiguration.Builder builder) {
            if (pmg.isShowInDsl()) {
                this.fromDslGroup(pmg, element, dslGroupsAsChildrenNames, builder);
            } else {
                pmg.getParameterModels().forEach(pm -> {
                    ComponentParameterAst param = element.getParameter(pmg.getName(), pm.getName());
                    if (param != null && param.getValue().getValue().isPresent()) {
                        this.handleParam(param, param.getModel().getType(), builder);
                    }
                });
            }
        }

        protected void fromDslGroup(ParameterGroupModel pmg, ComponentAst element, List<ComponentIdentifier> dslGroupsAsChildrenNames, ComponentConfiguration.Builder builder) {
            DslElementSyntax dslElementSyntax = element.getGenerationInformation().getSyntax().get().getChild(pmg.getName()).get();
            ComponentIdentifier dslGroupIdentifier = ComponentIdentifier.builder().namespaceUri(dslElementSyntax.getNamespace()).namespace(dslElementSyntax.getPrefix()).name(dslElementSyntax.getElementName()).build();
            dslGroupsAsChildrenNames.add(dslGroupIdentifier);
            ComponentConfiguration.Builder dslElementBuilder = ComponentConfiguration.builder().withIdentifier(dslGroupIdentifier);
            AtomicBoolean paramHandled = new AtomicBoolean(false);
            pmg.getParameterModels().forEach(pm -> {
                ComponentParameterAst param = element.getParameter(pmg.getName(), pm.getName());
                if (param != null && param.getValue().getValue().isPresent()) {
                    paramHandled.set(true);
                    this.handleParam(param, param.getModel().getType(), dslElementBuilder);
                }
            });
            if (paramHandled.get()) {
                builder.withNestedComponent(dslElementBuilder.build());
            }
        }

        protected void handleParam(ComponentParameterAst param, MetadataType type, ComponentConfiguration.Builder builder) {
            param.getValue().apply(expr -> this.handleExpressionParam(param, (String)expr, builder), v -> this.handleFixedValueParam(param, type, builder));
        }

        protected void handleExpressionParam(ComponentParameterAst param, String expr, ComponentConfiguration.Builder builder) {
            if (ExtensionModelUtils.isContent(param.getModel()) || ExtensionModelUtils.isText(param.getModel())) {
                param.getGenerationInformation().getSyntax().ifPresent(contentParamSyntax -> {
                    ComponentIdentifier contentParamIdentifier = ComponentIdentifier.builder().namespaceUri(contentParamSyntax.getNamespace()).namespace(contentParamSyntax.getPrefix()).name(contentParamSyntax.getElementName()).build();
                    ComponentConfiguration.Builder dslElementBuilder = ComponentConfiguration.builder().withIdentifier(contentParamIdentifier);
                    dslElementBuilder.withValue("#[" + expr + "]");
                    builder.withNestedComponent(dslElementBuilder.build());
                });
            } else {
                builder.withParameter(param.getModel().getName(), "#[" + expr + "]");
            }
        }

        protected void handleFixedValueParam(final ComponentParameterAst param, MetadataType type, final ComponentConfiguration.Builder builder) {
            type.accept(new MetadataTypeVisitor(){

                @Override
                protected void defaultVisit(MetadataType metadataType) {
                    if (param.getResolvedRawValue() != null) {
                        builder.withParameter(param.getModel().getName(), param.getResolvedRawValue());
                    }
                }

                @Override
                public void visitArrayType(ArrayType arrayType) {
                    param.getGenerationInformation().getSyntax().ifPresent(dslElementSyntax -> {
                        ComponentIdentifier listWrapperIdentifier = ComponentIdentifier.builder().namespaceUri(dslElementSyntax.getNamespace()).namespace(dslElementSyntax.getPrefix()).name(dslElementSyntax.getElementName()).build();
                        if (param.getValue().getRight() instanceof Collection) {
                            ComponentConfiguration.Builder listWrapperBuilder = ComponentConfiguration.builder().withIdentifier(listWrapperIdentifier);
                            Collection arrayValues = (Collection)param.getValue().getRight();
                            if (arrayValues != null) {
                                for (ComponentAst child : arrayValues) {
                                    listWrapperBuilder.withNestedComponent(this.from(child));
                                }
                            }
                            builder.withNestedComponent(listWrapperBuilder.build());
                        }
                    });
                }

                @Override
                public void visitObject(ObjectType objectType) {
                    if (param.getValue().getRight() instanceof String) {
                        builder.withParameter(param.getModel().getName(), (String)param.getValue().getRight());
                    }
                    if (ExtensionMetadataTypeUtils.isMap(objectType)) {
                        param.getGenerationInformation().getSyntax().ifPresent(dslElementSyntax -> {
                            ComponentIdentifier listWrapperIdentifier = ComponentIdentifier.builder().namespaceUri(dslElementSyntax.getNamespace()).namespace(dslElementSyntax.getPrefix()).name(dslElementSyntax.getElementName()).build();
                            ComponentConfiguration.Builder listWrapperBuilder = ComponentConfiguration.builder().withIdentifier(listWrapperIdentifier);
                            Collection mapValues = (Collection)param.getValue().getRight();
                            if (mapValues != null) {
                                for (ComponentAst child : mapValues) {
                                    listWrapperBuilder.withNestedComponent(this.from(child));
                                }
                            }
                            builder.withNestedComponent(listWrapperBuilder.build());
                        });
                    }
                    if (param.getValue().getRight() instanceof ComponentAst) {
                        builder.withNestedComponent(this.from((ComponentAst)param.getValue().getRight()));
                    }
                }

                @Override
                public void visitUnion(UnionType unionType) {
                    param.getGenerationInformation().getSyntax().ifPresent(dslElementSyntax -> unionType.getTypes().stream().filter(type -> type.equals(((ComponentAst)param.getValue().getRight()).getType())).findAny().ifPresent(type -> {
                        ComponentIdentifier unionWrapperIdentifier = ComponentIdentifier.builder().namespaceUri(dslElementSyntax.getNamespace()).namespace(dslElementSyntax.getPrefix()).name(dslElementSyntax.getElementName()).build();
                        ComponentConfiguration.Builder unionWrapperBuilder = ComponentConfiguration.builder().withIdentifier(unionWrapperIdentifier);
                        this.handleParam(param, (MetadataType)type, unionWrapperBuilder);
                        builder.withNestedComponent(unionWrapperBuilder.build());
                    }));
                }
            });
        }

        public Builder<M> withValue(String value) {
            this.value = value;
            return this;
        }

        public Builder<M> isExplicitInDsl(boolean explicit) {
            this.explicitInDsl = explicit;
            return this;
        }

        public DslElementModel<M> build() {
            if (this.configuration != null) {
                Optional<String> configurationValue = this.configuration.getValue();
                if (configurationValue.isPresent() && !StringUtils.isBlank((CharSequence)configurationValue.get())) {
                    if (this.value == null) {
                        this.value = configurationValue.get();
                    } else {
                        Preconditions.checkState(this.value.equals(configurationValue.get()), "The same element cannot have two different values associated.");
                    }
                } else {
                    Preconditions.checkState(this.value == null, "The same element cannot have two different values associated.");
                }
            }
            return new DslElementModel(this.model, this.dsl, this.contained, this.configuration, this.value, this.explicitInDsl);
        }
    }
}

