/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.soap.internal.loader;

import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OptionalParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclarer;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.extension.api.declaration.type.annotation.TypedValueTypeAnnotation;
import org.mule.runtime.extension.api.metadata.ComponentMetadataConfigurerFactory;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;
import org.mule.runtime.extension.api.soap.SoapAttributes;
import org.mule.runtime.extension.api.soap.SoapOutputPayload;
import org.mule.runtime.module.extension.api.loader.java.property.CompletableComponentExecutorModelProperty;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.loader.delegate.StereotypeModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.property.ConnectivityModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.DeclaringMemberModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.module.extension.soap.internal.metadata.InvokeInputAttachmentsTypeResolver;
import org.mule.runtime.module.extension.soap.internal.metadata.InvokeInputHeadersTypeResolver;
import org.mule.runtime.module.extension.soap.internal.metadata.InvokeKeysResolver;
import org.mule.runtime.module.extension.soap.internal.metadata.InvokeOutputTypeResolver;
import org.mule.runtime.module.extension.soap.internal.metadata.InvokeRequestTypeResolver;
import org.mule.runtime.module.extension.soap.internal.metadata.WebServiceTypeKey;
import org.mule.runtime.module.extension.soap.internal.runtime.connection.ForwardingSoapClient;
import org.mule.runtime.module.extension.soap.internal.runtime.operation.SoapOperationExecutorFactory;

public class SoapInvokeOperationDeclarer {
    public static final String MESSAGE_GROUP = "Message";
    private static final String KEYS_GROUP = "Web Service Configuration";
    static final String TRANSPORT = "Transport";
    static final String TRANSPORT_GROUP = "Transport Configuration";
    static final String OPERATION_DESCRIPTION = "invokes Web Service operations";
    static final String OPERATION_NAME = "invoke";
    public static final String SERVICE_PARAM = "service";
    public static final String OPERATION_PARAM = "operation";
    public static final String HEADERS_PARAM = "headers";
    public static final String BODY_PARAM = "body";
    public static final String ATTACHMENTS_PARAM = "attachments";
    public static final String HEADERS_DISPLAY_NAME = "Headers";
    public static final String TRANSPORT_HEADERS_PARAM = "transportHeaders";
    private static final BaseTypeBuilder TYPE_BUILDER = BaseTypeBuilder.create(JavaTypeLoader.JAVA);
    private final StereotypeModelLoaderDelegate stereotypeDelegate;

    public SoapInvokeOperationDeclarer(StereotypeModelLoaderDelegate stereotypeDelegate) {
        this.stereotypeDelegate = stereotypeDelegate;
    }

    void declare(ConfigurationDeclarer configDeclarer, ClassTypeLoader loader, Set<ErrorModel> soapErrors) {
        ReflectionCache reflectionCache = new ReflectionCache();
        OperationDeclarer operation = (OperationDeclarer)((OperationDeclarer)((OperationDeclarer)((OperationDeclarer)((OperationDeclarer)configDeclarer.withOperation(OPERATION_NAME).describedAs(OPERATION_DESCRIPTION)).requiresConnection(true)).blocking(true).withStereotype(this.stereotypeDelegate.getDefaultOperationStereotype(OPERATION_NAME))).withModelProperty(new CompletableComponentExecutorModelProperty(new SoapOperationExecutorFactory()))).withModelProperty(new ConnectivityModelProperty(ForwardingSoapClient.class));
        soapErrors.forEach(operation::withErrorModel);
        this.declareMetadata(operation, loader);
        this.declareOutput(operation, loader);
        this.declareMetadataKeyParameters(operation, loader, reflectionCache);
        this.declareRequestParameters(operation, loader);
    }

    private void declareMetadata(OperationDeclarer operation, ClassTypeLoader loader) {
        ComponentMetadataConfigurerFactory.getDefault().create().setKeysResolver(new InvokeKeysResolver(), KEYS_GROUP, loader.load((Type)((Object)WebServiceTypeKey.class)), false).addInputResolver(BODY_PARAM, new InvokeRequestTypeResolver()).addInputResolver(HEADERS_PARAM, new InvokeInputHeadersTypeResolver()).addInputResolver(ATTACHMENTS_PARAM, new InvokeInputAttachmentsTypeResolver()).setOutputTypeResolver(new InvokeOutputTypeResolver()).setConnected(true).configure(operation);
    }

    private void declareOutput(OperationDeclarer operation, ClassTypeLoader loader) {
        operation.withOutput().ofDynamicType(loader.load((Type)((Object)SoapOutputPayload.class)));
        operation.withOutputAttributes().ofType(loader.load((Type)((Object)SoapAttributes.class)));
    }

    private void declareRequestParameters(OperationDeclarer operation, ClassTypeLoader loader) {
        ParameterGroupDeclarer message = operation.onParameterGroup(MESSAGE_GROUP).withDslInlineRepresentation(true).withLayout(this.getLayout(1));
        MetadataType binaryType = loader.load((Type)((Object)InputStream.class));
        ObjectType attachments = TYPE_BUILDER.objectType().openWith(TYPE_BUILDER.binaryType().id(InputStream.class.getName()).with(new TypedValueTypeAnnotation())).with(new TypeIdAnnotation(Map.class.getName())).with(new ClassInformationAnnotation(Map.class)).build();
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)message.withOptionalParameter(BODY_PARAM).ofDynamicType(binaryType)).withRole(ParameterRole.PRIMARY_CONTENT)).defaultingTo("#[payload]").withLayout(this.getLayout(3))).withDisplayModel(DisplayModel.builder().summary("The XML body to include in the SOAP message, with all the required parameters.").build());
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)message.withOptionalParameter(HEADERS_PARAM).ofDynamicType(binaryType)).withRole(ParameterRole.CONTENT)).withLayout(this.getLayout(4))).withDisplayModel(DisplayModel.builder().displayName(HEADERS_DISPLAY_NAME).summary("The XML headers to include in the SOAP message.").build());
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)message.withOptionalParameter(ATTACHMENTS_PARAM).ofDynamicType(attachments)).withRole(ParameterRole.CONTENT)).withLayout(this.getLayout(5))).withDisplayModel(DisplayModel.builder().summary("The attachments to include in the SOAP request.").build());
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)operation.onParameterGroup(TRANSPORT_GROUP).withLayout(this.getLayout(2)).withOptionalParameter(TRANSPORT_HEADERS_PARAM).ofType(TYPE_BUILDER.objectType().openWith(loader.load((Type)((Object)String.class))).with(new TypeIdAnnotation(Map.class.getName())).with(new ClassInformationAnnotation(Map.class)).build())).withDsl(ParameterDslConfiguration.getDefaultInstance())).withLayout(LayoutModel.builder().order(2).tabName(TRANSPORT).build())).withDisplayModel(DisplayModel.builder().displayName(HEADERS_DISPLAY_NAME).summary("The headers to set in the transport configuration.").build());
    }

    private void declareMetadataKeyParameters(OperationDeclarer operation, ClassTypeLoader loader, ReflectionCache reflectionCache) {
        TypeWrapper keyType = new TypeWrapper(WebServiceTypeKey.class, loader);
        Object group = operation.onParameterGroup(KEYS_GROUP).withModelProperty(new ParameterGroupModelProperty(new ParameterGroupDescriptor(KEYS_GROUP, keyType)));
        DefaultStringType stringType = TYPE_BUILDER.stringType().build();
        ((ParameterDeclarer)((ParameterDeclarer)((ParameterDeclarer)((ParameterGroupDeclarer)group).withRequiredParameter(SERVICE_PARAM).withModelProperty(new DeclaringMemberModelProperty(IntrospectionUtils.getField(WebServiceTypeKey.class, SERVICE_PARAM, reflectionCache).get()))).ofType(stringType)).withModelProperty(new MetadataKeyPartModelProperty(1))).withLayout(this.getLayout(1));
        ((ParameterDeclarer)((ParameterDeclarer)((ParameterDeclarer)((ParameterGroupDeclarer)group).withRequiredParameter(OPERATION_PARAM).ofType(stringType)).withModelProperty(new DeclaringMemberModelProperty(IntrospectionUtils.getField(WebServiceTypeKey.class, OPERATION_PARAM, reflectionCache).get()))).withModelProperty(new MetadataKeyPartModelProperty(2))).withLayout(this.getLayout(2));
    }

    private LayoutModel getLayout(int order) {
        return LayoutModel.builder().order(order).build();
    }
}

