/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.component;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.privileged.component.DynamicallyComponent;

public class AnnotatedObjectInvocationHandlerInterceptors {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, A> T removeDynamicAnnotations(A annotated) {
        if (annotated instanceof DynamicallyComponent) {
            Class<?> baseClass = annotated.getClass().getSuperclass();
            HashMap<String, Object> fieldsByName = new HashMap<String, Object>();
            for (Class<?> currentClass = baseClass; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                Field[] targetFields = currentClass.getDeclaredFields();
                for (Field field : targetFields) {
                    if (Modifier.isStatic(field.getModifiers()) || fieldsByName.containsKey(field.getName())) continue;
                    fieldsByName.put(field.getName(), field);
                }
            }
            try {
                Object base = baseClass.newInstance();
                for (Field field : fieldsByName.values()) {
                    boolean acc = field.isAccessible();
                    field.setAccessible(true);
                    try {
                        field.set(base, field.get(annotated));
                    }
                    finally {
                        field.setAccessible(acc);
                    }
                }
                return (T)base;
            }
            catch (Exception e) {
                throw new MuleRuntimeException(e);
            }
        }
        return (T)annotated;
    }
}

