/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import java.lang.reflect.Type;
import java.util.Optional;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.IdempotentDeclarationEnricherWalkDelegate;
import org.mule.runtime.extension.api.loader.WalkingDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.util.InfrastructureParameterBuilder;
import org.mule.runtime.extension.privileged.util.ComponentDeclarationUtils;

public class ConnectionProviderDeclarationEnricher
implements WalkingDeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.STRUCTURE;
    }

    @Override
    public Optional<WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate> getWalkDelegate(ExtensionLoadingContext extensionLoadingContext) {
        final ExtensionDeclarer extensionDeclarer = extensionLoadingContext.getExtensionDeclarer();
        final ExtensionDeclaration extDeclaration = (ExtensionDeclaration)extensionDeclarer.getDeclaration();
        return Optional.of(new IdempotentDeclarationEnricherWalkDelegate(){
            boolean thereAreConnectionProviders = false;

            @Override
            protected void onConnectionProvider(ConnectionProviderDeclaration declaration) {
                ConnectionManagementType managementType;
                if (ComponentDeclarationUtils.isReconnectionStrategySupported(extDeclaration)) {
                    InfrastructureParameterBuilder.addReconnectionConfigParameter(declaration);
                }
                if ((managementType = declaration.getConnectionManagementType()) == ConnectionManagementType.POOLING) {
                    InfrastructureParameterBuilder.addPoolingProfileParameter(declaration);
                }
                this.thereAreConnectionProviders = true;
            }

            @Override
            public void onWalkFinished() {
                if (this.thereAreConnectionProviders && !ConnectionProviderDeclarationEnricher.this.isTlsContextFactoryAlreadyImported(extDeclaration)) {
                    ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
                    extensionDeclarer.withImportedType(new ImportedTypeModel((ObjectType)ConnectionProviderDeclarationEnricher.this.loadTlsContextFactoryType(typeLoader)));
                }
            }
        });
    }

    private MetadataType loadTlsContextFactoryType(ClassTypeLoader loader) {
        return loader.load((Type)((Object)TlsContextFactory.class));
    }

    private boolean isTlsContextFactoryAlreadyImported(ExtensionDeclaration extension) {
        return extension.getImportedTypes().stream().anyMatch(model -> this.isTlsContextFactory(model.getImportedType()));
    }

    private boolean isTlsContextFactory(MetadataType type) {
        return MetadataTypeUtils.getTypeId(type).filter(typeId -> TlsContextFactory.class.getName().equals(typeId)).isPresent();
    }
}

