/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.coreextension;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.service.ServiceRepository;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.MuleCoreExtension;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.event.EventContextService;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.internal.lock.ServerLockFactory;
import org.mule.runtime.core.internal.registry.SimpleRegistry;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderManager;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.repository.api.RepositoryService;
import org.mule.runtime.module.tooling.api.ToolingService;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingService;

public class ContainerInjectorBuilder<T extends ContainerInjectorBuilder> {
    private final Map<String, Object> objectsToRegister = new HashMap<String, Object>();

    public T withDeploymentService(DeploymentService deploymentService) {
        this.registerObject(DeploymentService.class.getName(), deploymentService);
        return this.getThis();
    }

    public T withServiceRepository(ServiceRepository serviceRepository) {
        if (serviceRepository != null) {
            for (Service service : serviceRepository.getServices()) {
                String name = service.getName();
                if (!StringUtils.isEmpty(service.getContractName())) {
                    name = name + " - " + service.getContractName();
                }
                this.registerObject(name, service);
            }
            this.registerObject(ServiceRepository.class.getName(), serviceRepository);
        }
        return this.getThis();
    }

    public T withRepositoryService(RepositoryService repositoryService) {
        this.registerObject(RepositoryService.class.getName(), repositoryService);
        return this.getThis();
    }

    public T withCoreExtensions(List<MuleCoreExtension> coreExtensions) {
        this.registerObject("_coreExtensions", coreExtensions);
        for (MuleCoreExtension muleCoreExtension : coreExtensions) {
            this.registerObject("_coreExtension_" + muleCoreExtension.getName(), muleCoreExtension);
        }
        return this.getThis();
    }

    public T withToolingService(ToolingService toolingService) {
        this.registerObject(ToolingService.class.getName(), toolingService);
        return this.getThis();
    }

    public T withArtifactClassLoaderManager(ArtifactClassLoaderManager artifactClassLoaderManager) {
        this.registerObject(ArtifactClassLoaderManager.class.getName(), artifactClassLoaderManager);
        return this.getThis();
    }

    public T withEventContextService(EventContextService eventContextService) {
        this.registerObject(EventContextService.class.getName(), eventContextService);
        return this.getThis();
    }

    public T withTroubleshootingService(TroubleshootingService troubleshootingService) {
        this.registerObject(TroubleshootingService.class.getName(), troubleshootingService);
        return this.getThis();
    }

    public T withServerLockFactory(ServerLockFactory serverLockFactory) {
        this.registerObject(ServerLockFactory.class.getName(), serverLockFactory);
        return this.getThis();
    }

    public Injector build() {
        SimpleRegistry injector = new SimpleRegistry(null);
        try {
            injector.registerObjects(this.objectsToRegister);
        }
        catch (RegistrationException e) {
            throw new RuntimeException(e);
        }
        return injector;
    }

    protected final void registerObject(String key, Object value) {
        if (value == null) {
            return;
        }
        Preconditions.checkArgument(!StringUtils.isEmpty(key), "key cannot be empty");
        this.objectsToRegister.put(key, value);
    }

    protected T getThis() {
        return (T)this;
    }
}

