/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.pom.parser.api.MavenPomParser;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleDeployableModel;
import org.mule.runtime.api.deployment.meta.MuleDomainModel;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.module.artifact.activation.api.ArtifactActivationException;
import org.mule.runtime.module.artifact.activation.api.deployable.ArtifactModelResolver;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.activation.api.deployable.MuleProjectStructure;
import org.mule.runtime.module.artifact.activation.api.descriptor.MuleConfigurationsFilter;
import org.mule.runtime.module.artifact.activation.internal.maven.AbstractMavenDeployableProjectModelBuilder;
import org.mule.runtime.module.artifact.activation.internal.maven.DefaultMuleProjectStructure;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;

public class MavenDeployableProjectModelBuilder
extends AbstractMavenDeployableProjectModelBuilder {
    private static final String POM_FILE_PATH = "pom.xml";
    private static final String DEFAULT_PACKAGE_EXPORT = "";
    private static final String JAVA_EXTENSION = "java";
    private static final String PACKAGE_SEPARATOR = ".";
    private static final String CLASS_PATH_SEPARATOR = "/";
    private static final MuleConfigurationsFilter MULE_CONFIGURATIONS_FILTER = MuleConfigurationsFilter.defaultMuleConfigurationsFilter();
    private final List<Path> resourcesPath = new ArrayList<Path>();
    private final boolean exportAllResourcesAndPackagesIfEmptyLoaderDescriptor;
    private final boolean includeTestDependencies;

    public MavenDeployableProjectModelBuilder(File projectFolder, MavenConfiguration mavenConfiguration, boolean exportAllResourcesAndPackagesIfEmptyLoaderDescriptor, boolean includeTestDependencies) {
        super(mavenConfiguration, projectFolder);
        this.exportAllResourcesAndPackagesIfEmptyLoaderDescriptor = exportAllResourcesAndPackagesIfEmptyLoaderDescriptor;
        this.includeTestDependencies = includeTestDependencies;
    }

    public MavenDeployableProjectModelBuilder(File projectFolder, boolean exportAllResourcesAndPackagesIfEmptyLoaderDescriptor) {
        this(projectFolder, (MavenConfiguration)DEFAULT_MAVEN_CONFIGURATION.get(), exportAllResourcesAndPackagesIfEmptyLoaderDescriptor, false);
    }

    public MavenDeployableProjectModelBuilder(File projectFolder, boolean exportAllResourcesAndPackagesIfEmptyLoaderDescriptor, boolean includeTestDependencies) {
        this(projectFolder, (MavenConfiguration)DEFAULT_MAVEN_CONFIGURATION.get(), exportAllResourcesAndPackagesIfEmptyLoaderDescriptor, includeTestDependencies);
    }

    public MavenDeployableProjectModelBuilder(File projectFolder) {
        this(projectFolder, (MavenConfiguration)DEFAULT_MAVEN_CONFIGURATION.get(), false, false);
    }

    @Override
    protected DeployableProjectModel doBuild(MavenPomParser parser, ArtifactCoordinates deployableArtifactCoordinates) {
        DefaultMuleProjectStructure projectStructure = new DefaultMuleProjectStructure(this.projectFolder.toPath(), parser, this.isIncludeTestDependencies());
        return this.doBuild(projectStructure, deployableArtifactCoordinates);
    }

    protected DeployableProjectModel doBuild(MuleProjectStructure projectStructure, ArtifactCoordinates deployableArtifactCoordinates) {
        try {
            List<String> packages = this.getAvailablePackages(projectStructure);
            List<String> muleResources = this.getAvailableMuleResources(projectStructure);
            List<String> nonMuleResources = this.getAvailableNonMuleResources(projectStructure);
            List<String> allResources = Stream.concat(muleResources.stream(), nonMuleResources.stream()).collect(Collectors.toList());
            Set<String> muleConfigs = this.getConfigs(projectStructure.getMuleResourcesDirectory(), muleResources);
            return new DeployableProjectModel(packages, allResources, this.resourcesPath, this.buildBundleDescriptor(deployableArtifactCoordinates), this.getDeployableModelResolver(deployableArtifactCoordinates, allResources, muleConfigs, packages), Optional.of(projectStructure), this.projectFolder, this.deployableBundleDependencies, this.sharedDeployableBundleDescriptors, this.additionalPluginDependencies);
        }
        catch (IOException e) {
            throw new ArtifactActivationException(I18nMessageFactory.createStaticMessage("Couldn't search exported packages and resources"), (Throwable)e);
        }
    }

    private Supplier<MuleDeployableModel> getDeployableModelResolver(ArtifactCoordinates deployableArtifactCoordinates, List<String> allResources, Set<String> muleConfigs, List<String> packages) {
        if ("mule-application".equals(deployableArtifactCoordinates.getClassifier())) {
            return () -> this.buildApplicationModel(ArtifactModelResolver.applicationModelResolver().resolve(this.projectFolder), allResources, muleConfigs, packages);
        }
        if ("mule-domain".equals(deployableArtifactCoordinates.getClassifier())) {
            return () -> this.buildDomainModel(ArtifactModelResolver.domainModelResolver().resolve(this.projectFolder), allResources, muleConfigs, packages);
        }
        throw new IllegalStateException("project is not a mule-application or mule-domain");
    }

    @Override
    protected boolean isIncludeTestDependencies() {
        return this.includeTestDependencies;
    }

    private MuleApplicationModel buildApplicationModel(MuleApplicationModel applicationModel, List<String> allResources, Set<String> muleConfigs, List<String> packages) {
        MuleApplicationModel.MuleApplicationModelBuilder builder = ((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)new MuleApplicationModel.MuleApplicationModelBuilder().setName(applicationModel.getName() != null ? applicationModel.getName() : "mule")).setMinMuleVersion(applicationModel.getMinMuleVersion())).setRequiredProduct(applicationModel.getRequiredProduct() != null ? applicationModel.getRequiredProduct() : Product.MULE_EE)).withClassLoaderModelDescriptorLoader(this.createClassLoaderModelDescriptorLoader(applicationModel.getClassLoaderModelLoaderDescriptor(), allResources, packages))).withBundleDescriptorLoader(applicationModel.getBundleDescriptorLoader() != null ? applicationModel.getBundleDescriptorLoader() : new MuleArtifactLoaderDescriptor("mule", Collections.emptyMap()))).setDomain(applicationModel.getDomain().orElse(null));
        builder.setConfigs((Set)(applicationModel.getConfigs() != null ? applicationModel.getConfigs() : muleConfigs));
        builder.setRedeploymentEnabled(applicationModel.isRedeploymentEnabled());
        builder.setSecureProperties((List)applicationModel.getSecureProperties());
        builder.setSupportedJavaVersions((Set)applicationModel.getSupportedJavaVersions());
        builder.setLogConfigFile(applicationModel.getLogConfigFile());
        return (MuleApplicationModel)builder.build();
    }

    private MuleDomainModel buildDomainModel(MuleDomainModel domainModel, List<String> allResources, Set<String> muleConfigs, List<String> packages) {
        MuleDomainModel.MuleDomainModelBuilder builder = (MuleDomainModel.MuleDomainModelBuilder)((MuleDomainModel.MuleDomainModelBuilder)((MuleDomainModel.MuleDomainModelBuilder)((MuleDomainModel.MuleDomainModelBuilder)((MuleDomainModel.MuleDomainModelBuilder)new MuleDomainModel.MuleDomainModelBuilder().setName(domainModel.getName() != null ? domainModel.getName() : "mule")).setMinMuleVersion(domainModel.getMinMuleVersion())).setRequiredProduct(domainModel.getRequiredProduct() != null ? domainModel.getRequiredProduct() : Product.MULE_EE)).withClassLoaderModelDescriptorLoader(this.createClassLoaderModelDescriptorLoader(domainModel.getClassLoaderModelLoaderDescriptor(), allResources, packages))).withBundleDescriptorLoader(domainModel.getBundleDescriptorLoader() != null ? domainModel.getBundleDescriptorLoader() : new MuleArtifactLoaderDescriptor("mule", Collections.emptyMap()));
        builder.setConfigs((Set)(domainModel.getConfigs() != null ? domainModel.getConfigs() : muleConfigs));
        builder.setRedeploymentEnabled(domainModel.isRedeploymentEnabled());
        builder.setSecureProperties((List)domainModel.getSecureProperties());
        builder.setSupportedJavaVersions((Set)domainModel.getSupportedJavaVersions());
        builder.setLogConfigFile(domainModel.getLogConfigFile());
        return (MuleDomainModel)builder.build();
    }

    private Set<String> getConfigs(Path muleResourcesDirectory, List<String> muleResources) {
        return muleResources.stream().filter(muleResource -> MULE_CONFIGURATIONS_FILTER.filter(this.resolveCandidateConfigsPath(muleResourcesDirectory, (String)muleResource))).collect(Collectors.toSet());
    }

    private File resolveCandidateConfigsPath(Path muleResourcesDirectory, String candidateConfigFileName) {
        return Paths.get(this.projectFolder.getAbsolutePath(), new String[0]).resolve(muleResourcesDirectory).resolve(candidateConfigFileName).toFile();
    }

    private MuleArtifactLoaderDescriptor createClassLoaderModelDescriptorLoader(MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor, List<String> resources, List<String> packages) {
        HashMap<String, Object> attributes;
        String id = classLoaderModelLoaderDescriptor != null ? classLoaderModelLoaderDescriptor.getId() : "mule";
        Map<String, Object> map = attributes = classLoaderModelLoaderDescriptor != null && classLoaderModelLoaderDescriptor.getAttributes() != null ? classLoaderModelLoaderDescriptor.getAttributes() : new HashMap<String, Object>();
        if (this.exportAllResourcesAndPackagesIfEmptyLoaderDescriptor && classLoaderModelLoaderDescriptor == null) {
            attributes.put("exportedResources", resources);
            attributes.put("exportedPackages", packages);
        }
        if (this.isIncludeTestDependencies()) {
            attributes.put("includeTestDependencies", "true");
        }
        return new MuleArtifactLoaderDescriptor(id, attributes);
    }

    private List<String> getAvailablePackages(MuleProjectStructure projectStructure) throws IOException {
        Path javaDirectory = projectStructure.getJavaDirectory();
        if (!javaDirectory.toFile().exists()) {
            return Collections.emptyList();
        }
        List allJavaFiles = Files.walk(javaDirectory, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        Predicate<Path> isJavaFile = path -> FilenameUtils.getExtension((String)path.toString()).endsWith(JAVA_EXTENSION);
        return allJavaFiles.stream().filter(isJavaFile).map(path -> {
            Path parent = javaDirectory.relativize((Path)path).getParent();
            return parent != null ? parent.toString() : DEFAULT_PACKAGE_EXPORT;
        }).map(this::escapeSlashes).map(s -> s.replace(CLASS_PATH_SEPARATOR, PACKAGE_SEPARATOR)).distinct().collect(Collectors.toList());
    }

    private List<String> getAvailableMuleResources(MuleProjectStructure projectStructure) throws IOException {
        List<String> resources = this.getResourcesInFolder(projectStructure.getMuleResourcesDirectory());
        if (resources.isEmpty()) {
            throw new IOException(projectStructure.getMuleResourcesDirectory().toAbsolutePath().toString() + " cannot be empty");
        }
        return resources;
    }

    private List<String> getAvailableNonMuleResources(MuleProjectStructure projectStructure) throws IOException {
        ArrayList<String> resources = new ArrayList<String>();
        Collection<Path> resourcesDirectories = projectStructure.getResourcesDirectories();
        for (Path r : resourcesDirectories) {
            try {
                resources.addAll(this.getResourcesInFolder(r));
            }
            catch (IOException e) {
                throw new IOException("Cannot load files from" + r + ": " + e.getMessage());
            }
        }
        return resources;
    }

    private List<String> getResourcesInFolder(Path resourcesDirectory) throws IOException {
        if (!resourcesDirectory.toFile().exists()) {
            return Collections.emptyList();
        }
        this.resourcesPath.add(resourcesDirectory);
        if (Files.notExists(resourcesDirectory, new LinkOption[0])) {
            return Collections.emptyList();
        }
        List allResourcesFiles = Files.walk(resourcesDirectory, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        return allResourcesFiles.stream().map(resourcesDirectory::relativize).map(Path::toString).map(this::escapeSlashes).collect(Collectors.toList());
    }

    private String escapeSlashes(String p) {
        return p.replace("\\", CLASS_PATH_SEPARATOR);
    }

    @Override
    protected File getPomFromFolder(File projectFolder) {
        File pomFile = new File(projectFolder, POM_FILE_PATH);
        if (!pomFile.exists()) {
            throw new IllegalStateException(String.format("The pom.xml file for artifact in folder %s could not be found", projectFolder.getAbsolutePath()));
        }
        return pomFile;
    }
}

