/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.notification;

import java.util.function.Supplier;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.ExtensionNotification;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.extension.internal.runtime.notification.ExtensionAction;
import org.mule.sdk.api.notification.NotificationActionDefinition;

public class DefaultExtensionNotification
implements ExtensionNotification {
    private static final long serialVersionUID = 6641419368045215517L;
    private final Event event;
    private final Component component;
    private final NotificationActionDefinition actionDefinition;
    private final Supplier<TypedValue<?>> data;
    private ExtensionAction action;

    public DefaultExtensionNotification(Event event, Component component, NotificationActionDefinition actionDefinition, TypedValue<?> data) {
        DataType actualDataType = data.getDataType();
        DataType expectedDataType = actionDefinition.getDataType();
        Preconditions.checkArgument(expectedDataType.isCompatibleWith(actualDataType), () -> String.format("The action data type (%s) does not match the actual data type received (%s)", expectedDataType, actualDataType));
        this.event = event;
        this.component = component;
        this.actionDefinition = actionDefinition;
        this.data = () -> data;
    }

    public DefaultExtensionNotification(Event event, Component component, NotificationActionDefinition actionDefinition, Supplier<?> dataValue, DataType actualDataType) {
        DataType expectedDataType = actionDefinition.getDataType();
        Preconditions.checkArgument(expectedDataType.isCompatibleWith(actualDataType), () -> String.format("The action data type (%s) does not match the actual data type received (%s)", expectedDataType, actualDataType));
        this.event = event;
        this.component = component;
        this.actionDefinition = actionDefinition;
        this.data = new LazyValue<Supplier<TypedValue>>(() -> new TypedValue(dataValue.get(), actualDataType));
    }

    @Override
    public Event getEvent() {
        return this.event;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public TypedValue<?> getData() {
        return this.data.get();
    }

    @Override
    public Notification.Action getAction() {
        if (this.action == null) {
            String namespace = this.component.getLocation() == null ? "NULL" : this.component.getLocation().getComponentIdentifier().getIdentifier().getNamespace().toUpperCase();
            this.action = new ExtensionAction(namespace, ((Enum)((Object)this.actionDefinition)).name());
        }
        return this.action;
    }

    public String toString() {
        return "{action={" + this.getAction().getNamespace() + ":" + this.getAction().getIdentifier() + "}, location: " + this.component.getLocation() + "}";
    }
}

