/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence.deserializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.FunctionTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.persistence.JsonMetadataTypeLoader;
import org.mule.metadata.persistence.deserializer.AbstractTypeDeserializer;
import org.mule.metadata.persistence.deserializer.SerializerUtils;

final class FunctionTypeDeserializer
extends AbstractTypeDeserializer {
    FunctionTypeDeserializer() {
        super(BaseTypeBuilder::functionType);
    }

    @Override
    public TypeBuilder buildType(JsonObject typeObject, BaseTypeBuilder baseBuilder, JsonMetadataTypeLoader typeLoader) {
        FunctionTypeBuilder functionTypeBuilder = (FunctionTypeBuilder)this.supplier.get(baseBuilder);
        for (JsonElement jsonElement : typeObject.get("parameters").getAsJsonArray()) {
            JsonObject parameterJsonObject = jsonElement.getAsJsonObject();
            String name = parameterJsonObject.get("name").getAsString();
            boolean optional = false;
            if (parameterJsonObject.has("required")) {
                optional = !parameterJsonObject.get("required").getAsBoolean();
            }
            TypeBuilder type = typeLoader.buildType((JsonElement)parameterJsonObject.get("type").getAsJsonObject(), new BaseTypeBuilder(SerializerUtils.VOLATILE_FORMAT));
            if (optional) {
                functionTypeBuilder.addOptionalParameterOf(name, type);
                continue;
            }
            functionTypeBuilder.addParameterOf(name, type);
        }
        if (typeObject.has("returnType")) {
            functionTypeBuilder.returnType(typeLoader.buildType((JsonElement)typeObject.get("returnType").getAsJsonObject(), new BaseTypeBuilder(SerializerUtils.VOLATILE_FORMAT)));
        }
        this.parseAnnotations(typeObject, functionTypeBuilder);
        return functionTypeBuilder;
    }
}

