/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.component;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.SuperMethodCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.core.internal.component.AnnotatedObjectInvocationHandlerInterceptors;
import org.mule.runtime.core.internal.util.MultiParentClassLoaderUtils;
import org.mule.runtime.core.privileged.component.ComponentAdditionalInterceptor;
import org.mule.runtime.core.privileged.component.ComponentInterceptor;
import org.mule.runtime.core.privileged.component.DynamicallyComponent;
import org.mule.runtime.core.privileged.component.DynamicallySerializableComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnnotatedObjectInvocationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotatedObjectInvocationHandler.class);
    private static final ByteBuddy byteBuddy = new ByteBuddy();
    private static final Set<Method> MANAGED_METHODS = Collections.unmodifiableSet(new HashSet<Method>(Arrays.asList(Component.class.getDeclaredMethods())));
    private static final Method COMPONENT_ADDITIONAL_INTERCEPTOR_SET_OBJ;

    public static <T, A extends Component> Class<A> addAnnotationsToClass(Class<T> clazz) {
        Class<DynamicallyComponent> dynamicInterface;
        if (Component.class.isAssignableFrom(clazz) && Arrays.asList(clazz.getMethods()).stream().anyMatch(m -> "getAnnotations".equals(m.getName()) && !m.isDefault())) {
            return clazz;
        }
        if (Modifier.isFinal(clazz.getModifiers())) {
            throw new UnsupportedOperationException("Class '" + clazz.getName() + "' must either not be final or implement '" + Component.class.getName() + "'");
        }
        if (Serializable.class.isAssignableFrom(clazz)) {
            try {
                clazz.getConstructor(new Class[0]);
                dynamicInterface = DynamicallySerializableComponent.class;
            }
            catch (SecurityException e) {
                throw new UnsupportedOperationException("Class '" + clazz.getName() + "' cannot be enhanced for annotations (" + e.getMessage() + ")", e);
            }
            catch (NoSuchMethodException e) {
                LOGGER.warn("Class '" + clazz.getName() + "' implements Serializable but does not provide a default public constructor. The mechanism to add annotations dynamically requires a default public constructor in a Serializable class.");
                dynamicInterface = DynamicallyComponent.class;
            }
        } else {
            dynamicInterface = DynamicallyComponent.class;
        }
        ComponentInterceptor annotatedObjectInvocationHandler = new ComponentInterceptor();
        MethodDelegation implementation = MethodDelegation.to((Object)annotatedObjectInvocationHandler);
        DynamicType.Builder.MethodDefinition.ImplementationDefinition.Optional builder = byteBuddy.subclass(clazz, (ConstructorStrategy)ConstructorStrategy.Default.IMITATE_SUPER_CLASS).implement(new Type[]{dynamicInterface});
        for (Method method : MANAGED_METHODS) {
            builder = builder.method((ElementMatcher)ElementMatchers.named((String)method.getName()).and((ElementMatcher)ElementMatchers.takesArguments((Class[])method.getParameterTypes()))).intercept((Implementation)implementation);
        }
        ComponentAdditionalInterceptor annotatedObjectAdditionalInvocationHandler = new ComponentAdditionalInterceptor();
        builder = builder.method((ElementMatcher)ElementMatchers.named((String)"writeReplace").or((ElementMatcher)ElementMatchers.isToString().and((ElementMatcher)ElementMatchers.isDeclaredBy(Object.class)))).intercept((Implementation)MethodDelegation.to((Object)annotatedObjectAdditionalInvocationHandler));
        builder = builder.constructor((ElementMatcher)ElementMatchers.any()).intercept((Implementation)SuperMethodCall.INSTANCE.andThen((Implementation.Composable)MethodCall.invoke((Method)COMPONENT_ADDITIONAL_INTERCEPTOR_SET_OBJ).on((Object)annotatedObjectAdditionalInvocationHandler).withThis()));
        ClassLoader classLoader = MultiParentClassLoaderUtils.multiParentClassLoaderFor(clazz.getClassLoader());
        return builder.make().load(classLoader).getLoaded();
    }

    public static <T, A> T removeDynamicAnnotations(A annotated) {
        return AnnotatedObjectInvocationHandlerInterceptors.removeDynamicAnnotations(annotated);
    }

    static {
        try {
            COMPONENT_ADDITIONAL_INTERCEPTOR_SET_OBJ = ComponentAdditionalInterceptor.class.getMethod("setObj", Component.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException(e);
        }
    }
}

