/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.plugin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.internal.util.jar.JarLoadingUtils;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;

public class MuleArtifactPatchingModel {
    private static final String MULE_ARTIFACT_PATCH_JSON_FILE_NAME = "mule-artifact-patch.json";
    private static final Map<String, MuleArtifactPatchingModel> loadedModelByJar = new HashMap<String, MuleArtifactPatchingModel>();
    private ArtifactCoordinates artifactCoordinates;
    private List<String> affectedVersions;

    public static synchronized MuleArtifactPatchingModel loadModel(File pluginPatchJarFile) throws IOException {
        String key = pluginPatchJarFile.toString();
        if (!loadedModelByJar.containsKey(key)) {
            Optional<byte[]> muleArtifactPatchContent = JarLoadingUtils.loadFileContentFrom(pluginPatchJarFile, MULE_ARTIFACT_PATCH_JSON_FILE_NAME);
            muleArtifactPatchContent.map(bytes -> {
                MuleArtifactPatchingModel artifactPatchingModel = MuleArtifactPatchingModel.deserialize(bytes);
                loadedModelByJar.put(key, artifactPatchingModel);
                return artifactPatchingModel;
            }).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Invalid jar file '%s'. It does not contain descriptor '%s'", pluginPatchJarFile, MULE_ARTIFACT_PATCH_JSON_FILE_NAME))));
        }
        return loadedModelByJar.get(key);
    }

    private static MuleArtifactPatchingModel deserialize(byte[] muleArtifactPatchBytes) {
        Gson gson = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().create();
        return (MuleArtifactPatchingModel)gson.fromJson(new String(muleArtifactPatchBytes), MuleArtifactPatchingModel.class);
    }

    public ArtifactCoordinates getArtifactCoordinates() {
        return this.artifactCoordinates;
    }

    public void setArtifactCoordinates(ArtifactCoordinates artifactCoordinates) {
        this.artifactCoordinates = artifactCoordinates;
    }

    public List<String> getAffectedVersions() {
        return this.affectedVersions;
    }

    public void setAffectedVersions(List<String> affectedVersions) {
        this.affectedVersions = affectedVersions;
    }
}

