/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal.processor;

import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.deployment.model.api.artifact.ArtifactConfigurationProcessor;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContext;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContextConfiguration;
import org.mule.runtime.module.deployment.internal.processor.FallbackAllowedArtifactConfigurationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FallbackArtifactConfigurationProcessor
implements ArtifactConfigurationProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(FallbackArtifactConfigurationProcessor.class);
    private final FallbackAllowedArtifactConfigurationProcessor primary;
    private final ArtifactConfigurationProcessor fallback;

    public FallbackArtifactConfigurationProcessor(FallbackAllowedArtifactConfigurationProcessor primary, ArtifactConfigurationProcessor fallback) {
        this.primary = primary;
        this.fallback = fallback;
    }

    @Override
    public ArtifactContext createArtifactContext(ArtifactContextConfiguration artifactContextConfiguration) throws ConfigurationException {
        if (Boolean.getBoolean("mule.deployment.forceParseConfigXmls")) {
            return this.fallback.createArtifactContext(artifactContextConfiguration);
        }
        if (!this.primary.check(artifactContextConfiguration)) {
            return this.fallback.createArtifactContext(artifactContextConfiguration);
        }
        try {
            ArtifactContext createdArtifactContext = this.primary.createArtifactContext(artifactContextConfiguration);
            LOGGER.debug("Successfully created context with " + this.primary.toString() + " for deployment " + createdArtifactContext.getMuleContext().getConfiguration().getId());
            return createdArtifactContext;
        }
        catch (ConfigurationException e) {
            String message = "Falling back to " + this.fallback.toString() + " for deployment " + artifactContextConfiguration.getMuleContext().getConfiguration().getId();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.warn(message, (Throwable)e);
            } else {
                LOGGER.warn(message + ": " + e.toString());
            }
            try {
                return this.fallback.createArtifactContext(artifactContextConfiguration);
            }
            catch (ConfigurationException eFallback) {
                eFallback.addSuppressed(e);
                throw eFallback;
            }
        }
    }
}

