/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.delegate;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasParametersDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasSourceDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceCallbackDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSemanticTermsDeclaration;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.extension.api.exception.IllegalSourceModelDefinitionException;
import org.mule.runtime.extension.api.property.BackPressureStrategyModelProperty;
import org.mule.runtime.module.extension.internal.loader.ModelLoaderDelegateUtils;
import org.mule.runtime.module.extension.internal.loader.delegate.AbstractComponentModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.delegate.DefaultExtensionModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.parser.AttributesResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.SourceModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.notification.NotificationModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.metadata.InputResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.metadata.MetadataKeyModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.metadata.OutputResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.utils.ModelLoaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SourceModelLoaderDelegate
extends AbstractComponentModelLoaderDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(SourceModelLoaderDelegate.class);
    private final Map<SourceModelParser, SourceDeclarer> sourceDeclarers = new HashMap<SourceModelParser, SourceDeclarer>();

    SourceModelLoaderDelegate(DefaultExtensionModelLoaderDelegate delegate) {
        super(delegate);
    }

    void declareMessageSources(ExtensionDeclarer extensionDeclarer, HasSourceDeclarer ownerDeclarer, List<SourceModelParser> parsers) {
        for (SourceModelParser parser : parsers) {
            Optional<SourceModelParser.SourceCallbackModelParser> errorCallbackSourceCallbackModelParser;
            HasSourceDeclarer actualDeclarer;
            if (parser.isIgnored()) continue;
            boolean requiresConfig = ModelLoaderDelegateUtils.requiresConfig(parser);
            HasSourceDeclarer hasSourceDeclarer = actualDeclarer = requiresConfig ? ownerDeclarer : extensionDeclarer;
            if (actualDeclarer == extensionDeclarer && requiresConfig) {
                throw new IllegalSourceModelDefinitionException(String.format("Source '%s' is defined at the extension level but it requires a config parameter. Remove such parameter or move the source to the proper config", parser.getName()));
            }
            SourceDeclarer existingDeclarer = this.sourceDeclarers.get(parser);
            if (existingDeclarer != null) {
                actualDeclarer.withMessageSource(existingDeclarer);
                continue;
            }
            SourceDeclarer sourceDeclarer = (SourceDeclarer)((SourceDeclarer)((SourceDeclarer)((SourceDeclarer)((SourceDeclarer)actualDeclarer.withMessageSource(parser.getName()).describedAs(parser.getDescription())).hasResponse(parser.emitsResponse()).requiresConnection(parser.isConnected())).transactional(parser.isTransactional())).supportsStreaming(parser.supportsStreaming())).withVisibility(parser.getComponentVisibility());
            parser.getDeprecationModel().ifPresent(sourceDeclarer::withDeprecation);
            parser.getDisplayModel().ifPresent(d -> ((SourceDeclaration)sourceDeclarer.getDeclaration()).setDisplayModel((DisplayModel)d));
            parser.getSourceFactoryModelProperty().ifPresent(sourceDeclarer::withModelProperty);
            parser.getOutputType().applyOn(sourceDeclarer.withOutput());
            parser.getAttributesOutputType().applyOn(sourceDeclarer.withOutputAttributes());
            if (parser.mustResolveMinMuleVersion()) {
                parser.getResolvedMinMuleVersion().ifPresent(resolvedMMV -> {
                    sourceDeclarer.withMinMuleVersion(resolvedMMV.getMinMuleVersion());
                    LOGGER.debug(resolvedMMV.getReason());
                });
            }
            Optional<OutputResolverModelParser> outputResolverModelParser = parser.getOutputResolverModelParser();
            Optional<AttributesResolverModelParser> attributesResolverModelParser = parser.getAttributesResolverModelParser();
            Optional<MetadataKeyModelParser> keyIdResolverModelParser = parser.getMetadataKeyModelParser();
            this.loader.getParameterModelsLoaderDelegate().declare(sourceDeclarer, parser.getParameterGroupModelParsers());
            parser.getMediaTypeModelProperty().ifPresent(sourceDeclarer::withModelProperty);
            parser.getExceptionHandlerModelProperty().ifPresent(sourceDeclarer::withModelProperty);
            this.loader.registerOutputTypes((ExecutableComponentDeclaration)sourceDeclarer.getDeclaration());
            ModelLoaderUtils.declareMetadataModelProperties((ParameterizedDeclaration)sourceDeclarer.getDeclaration(), outputResolverModelParser, attributesResolverModelParser, Collections.emptyList(), keyIdResolverModelParser, parser.isConnected());
            ModelLoaderUtils.addSemanticTerms((WithSemanticTermsDeclaration)sourceDeclarer.getDeclaration(), parser);
            NotificationModelParserUtils.declareEmittedNotifications(parser, sourceDeclarer, this.loader::getNotificationModel);
            this.getStereotypeModelLoaderDelegate().addStereotypes(parser, sourceDeclarer, Optional.of(() -> this.getStereotypeModelLoaderDelegate().getDefaultSourceStereotype(parser.getName())));
            parser.getAdditionalModelProperties().forEach(sourceDeclarer::withModelProperty);
            Optional<SourceModelParser.SourceCallbackModelParser> successCallbackSourceCallbackModelParser = parser.getOnSuccessCallbackParser();
            if (successCallbackSourceCallbackModelParser.isPresent()) {
                SourceCallbackDeclarer onSuccessSourceCallbackDeclarer = sourceDeclarer.onSuccess();
                List<InputResolverModelParser> sourceCallbackInputResolverModelParsers = successCallbackSourceCallbackModelParser.get().getInputResolverModelParsers();
                ModelLoaderUtils.declareMetadataModelProperties((ParameterizedDeclaration)onSuccessSourceCallbackDeclarer.getDeclaration(), Optional.empty(), Optional.empty(), sourceCallbackInputResolverModelParsers, Optional.empty(), parser.isConnected());
                this.declareSourceCallbackParameters(successCallbackSourceCallbackModelParser, () -> onSuccessSourceCallbackDeclarer);
            }
            if ((errorCallbackSourceCallbackModelParser = parser.getOnErrorCallbackParser()).isPresent()) {
                SourceCallbackDeclarer onErrorSourceCallbackDeclarer = sourceDeclarer.onError();
                List<InputResolverModelParser> sourceCallbackInputResolverModelParsers = errorCallbackSourceCallbackModelParser.get().getInputResolverModelParsers();
                ModelLoaderUtils.declareMetadataModelProperties((ParameterizedDeclaration)onErrorSourceCallbackDeclarer.getDeclaration(), Optional.empty(), Optional.empty(), sourceCallbackInputResolverModelParsers, Optional.empty(), parser.isConnected());
                this.declareSourceCallbackParameters(parser.getOnErrorCallbackParser(), () -> onErrorSourceCallbackDeclarer);
            }
            this.declareSourceCallbackParameters(parser.getOnTerminateCallbackParser(), sourceDeclarer::onTerminate);
            this.declareSourceCallbackParameters(parser.getOnBackPressureCallbackParser(), sourceDeclarer::onBackPressure);
            sourceDeclarer.withModelProperty(parser.getSourceClusterSupportModelProperty());
            sourceDeclarer.withModelProperty(parser.getBackPressureStrategyModelProperty().orElse(BackPressureStrategyModelProperty.getDefault()));
            this.sourceDeclarers.put(parser, sourceDeclarer);
        }
    }

    private void declareSourceCallbackParameters(Optional<SourceModelParser.SourceCallbackModelParser> parser, Supplier<ParameterizedDeclarer> declarer) {
        parser.ifPresent(callback -> this.loader.getParameterModelsLoaderDelegate().declare((HasParametersDeclarer)declarer.get(), callback.getParameterGroupModelParsers()));
    }
}

