/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tls.internal.socket;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.PropertiesUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsProperties {
    private static final Logger logger = LoggerFactory.getLogger(TlsProperties.class);
    private String[] enabledCipherSuites;
    private String[] enabledProtocols;
    private String defaultProtocol;

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public String getDefaultProtocol() {
        return this.defaultProtocol;
    }

    public void load(String fileName) {
        try {
            InputStream config = IOUtils.getResourceAsStream(fileName, TlsProperties.class);
            if (config == null) {
                logger.warn(String.format("File %s not found, using default configuration.", fileName));
            } else {
                logger.info(String.format("Loading configuration file: %s", fileName));
                Properties properties = PropertiesUtils.loadProperties(config);
                String enabledCipherSuitesProperty = properties.getProperty("enabledCipherSuites");
                String enabledProtocolsProperty = properties.getProperty("enabledProtocols");
                String defaultProtocolProperty = properties.getProperty("defaultProtocol");
                if (enabledCipherSuitesProperty != null) {
                    this.enabledCipherSuites = StringUtils.splitAndTrim(enabledCipherSuitesProperty, ",");
                }
                if (enabledProtocolsProperty != null) {
                    this.enabledProtocols = StringUtils.splitAndTrim(enabledProtocolsProperty, ",");
                }
                if (defaultProtocolProperty != null) {
                    this.defaultProtocol = defaultProtocolProperty.trim();
                }
            }
        }
        catch (IOException e) {
            logger.warn(String.format("Cannot read file %s, using default configuration", fileName), (Throwable)e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TlsProperties that = (TlsProperties)o;
        if (!Arrays.equals(this.enabledCipherSuites, that.enabledCipherSuites)) {
            return false;
        }
        if (!Arrays.equals(this.enabledProtocols, that.enabledProtocols)) {
            return false;
        }
        return this.defaultProtocol != null ? this.defaultProtocol.equals(that.defaultProtocol) : that.defaultProtocol == null;
    }

    public int hashCode() {
        int result = this.enabledCipherSuites != null ? Arrays.hashCode(this.enabledCipherSuites) : 0;
        result = 31 * result + (this.enabledProtocols != null ? Arrays.hashCode(this.enabledProtocols) : 0);
        result = 31 * result + (this.defaultProtocol != null ? this.defaultProtocol.hashCode() : 0);
        return result;
    }
}

