/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el;

import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class TemplateParserToken {
    private static final Random RANDOM = new Random();
    private final Pattern searchPattern;

    private static TemplateParserToken getNewToken() {
        String id = '1' + String.format("%010d", RANDOM.nextInt() & Integer.MAX_VALUE);
        return new TemplateParserToken(id);
    }

    private TemplateParserToken(String id) {
        this.searchPattern = Pattern.compile(id);
    }

    public String getId() {
        return this.searchPattern.pattern();
    }

    public Replacement buildReplacement(String replacement) {
        return new Replacement(replacement);
    }

    class Replacement {
        private final String replacement;

        private Replacement(String replacement) {
            this.replacement = replacement;
        }

        public String replace(String original, Function<String, String> replacementMapper) {
            Matcher matcher = TemplateParserToken.this.searchPattern.matcher(original);
            if (!matcher.find()) {
                return original;
            }
            String mappedReplacement = replacementMapper.apply(this.replacement);
            int lastEndOfMatch = 0;
            StringBuilder sb = new StringBuilder();
            do {
                sb.append(original, lastEndOfMatch, matcher.start());
                sb.append(mappedReplacement);
                lastEndOfMatch = matcher.end();
            } while (matcher.find());
            sb.append(original, lastEndOfMatch, original.length());
            return sb.toString();
        }
    }

    static class Provider {
        private static final int POOL_INITIAL_SIZE = 10;
        private static final List<TemplateParserToken> tokensPool = new CopyOnWriteArrayList<TemplateParserToken>(Provider.createInitialTokensBatch());
        private int curOffset = 0;

        Provider() {
        }

        private static TemplateParserToken[] createInitialTokensBatch() {
            TemplateParserToken[] tokens = new TemplateParserToken[10];
            for (int i = 0; i < tokens.length; ++i) {
                tokens[i] = TemplateParserToken.getNewToken();
            }
            return tokens;
        }

        public TemplateParserToken getToken() {
            if (tokensPool.size() <= this.curOffset) {
                tokensPool.add(TemplateParserToken.getNewToken());
            }
            return tokensPool.get(this.curOffset++);
        }
    }
}

