/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl.connection;

import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.retry.ReconnectionConfig;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantTypeVisitor;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthModelProperty;
import org.mule.runtime.extension.api.connectivity.oauth.PlatformManagedOAuthGrantType;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.config.dsl.AbstractExtensionObjectFactory;
import org.mule.runtime.module.extension.internal.runtime.config.BaseConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.config.DefaultConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.AuthorizationCodeConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.AuthorizationCodeOAuthHandler;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials.ClientCredentialsConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials.ClientCredentialsOAuthHandler;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ocs.PlatformManagedOAuthConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ocs.PlatformManagedOAuthHandler;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderResolver;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.soap.internal.loader.property.SoapExtensionModelProperty;
import org.mule.runtime.module.extension.soap.internal.runtime.connection.SoapConnectionProviderObjectBuilder;

public class ConnectionProviderObjectFactory
extends AbstractExtensionObjectFactory<ConnectionProviderResolver> {
    private final ConnectionProviderModel providerModel;
    private final ExtensionModel extensionModel;
    private final AuthorizationCodeOAuthHandler authCodeHandler;
    private final ClientCredentialsOAuthHandler clientCredentialsHandler;
    private final PlatformManagedOAuthHandler platformManagedOAuthHandler;
    private PoolingProfile poolingProfile = null;
    private ReconnectionConfig reconnectionConfig = ReconnectionConfig.defaultReconnectionConfig();
    @Inject
    private ConfigurationProperties properties;
    @Inject
    private MuleContext muleContext;

    public ConnectionProviderObjectFactory(ConnectionProviderModel providerModel, ExtensionModel extensionModel, AuthorizationCodeOAuthHandler authCodeHandler, ClientCredentialsOAuthHandler clientCredentialsHandler, PlatformManagedOAuthHandler platformManagedOAuthHandler, MuleContext muleContext) {
        super(muleContext);
        this.providerModel = providerModel;
        this.extensionModel = extensionModel;
        this.authCodeHandler = authCodeHandler;
        this.clientCredentialsHandler = clientCredentialsHandler;
        this.platformManagedOAuthHandler = platformManagedOAuthHandler;
    }

    @Override
    public ConnectionProviderResolver doGetObject() {
        Callable<ResolverSet> callable = () -> this.getParametersResolver().getParametersAsResolverSet(this.providerModel, this.muleContext);
        ResolverSet resolverSet = ClassUtils.withContextClassLoader(MuleExtensionUtils.getClassLoader(this.extensionModel), callable);
        BaseConnectionProviderObjectBuilder builder = this.extensionModel.getModelProperty(SoapExtensionModelProperty.class).isPresent() ? new SoapConnectionProviderObjectBuilder(this.providerModel, resolverSet, this.poolingProfile, this.reconnectionConfig, this.extensionModel, this.expressionManager, this.muleContext) : (this.providerModel.getModelProperty(OAuthModelProperty.class).isPresent() ? this.resolveOAuthBuilder(resolverSet) : new DefaultConnectionProviderObjectBuilder(this.providerModel, resolverSet, this.poolingProfile, this.reconnectionConfig, this.extensionModel, this.expressionManager, this.muleContext));
        return new ConnectionProviderResolver(builder, resolverSet, this.muleContext);
    }

    private BaseConnectionProviderObjectBuilder resolveOAuthBuilder(final ResolverSet resolverSet) {
        OAuthGrantType grantType = (OAuthGrantType)this.providerModel.getModelProperty(OAuthModelProperty.class).map(OAuthModelProperty::getGrantTypes).get().get(0);
        final Reference builder = new Reference();
        grantType.accept(new OAuthGrantTypeVisitor(){

            @Override
            public void visit(AuthorizationCodeGrantType grantType) {
                builder.set(new AuthorizationCodeConnectionProviderObjectBuilder(ConnectionProviderObjectFactory.this.providerModel, resolverSet, ConnectionProviderObjectFactory.this.poolingProfile, ConnectionProviderObjectFactory.this.reconnectionConfig, grantType, ConnectionProviderObjectFactory.this.authCodeHandler, ConnectionProviderObjectFactory.this.extensionModel, ConnectionProviderObjectFactory.this.expressionManager, ConnectionProviderObjectFactory.this.muleContext));
            }

            @Override
            public void visit(ClientCredentialsGrantType grantType) {
                builder.set(new ClientCredentialsConnectionProviderObjectBuilder(ConnectionProviderObjectFactory.this.providerModel, resolverSet, ConnectionProviderObjectFactory.this.poolingProfile, ConnectionProviderObjectFactory.this.reconnectionConfig, grantType, ConnectionProviderObjectFactory.this.clientCredentialsHandler, ConnectionProviderObjectFactory.this.extensionModel, ConnectionProviderObjectFactory.this.expressionManager, ConnectionProviderObjectFactory.this.muleContext));
            }

            @Override
            public void visit(PlatformManagedOAuthGrantType grantType) {
                builder.set(new PlatformManagedOAuthConnectionProviderObjectBuilder(ConnectionProviderObjectFactory.this.providerModel, resolverSet, ConnectionProviderObjectFactory.this.poolingProfile, ConnectionProviderObjectFactory.this.reconnectionConfig, grantType, ConnectionProviderObjectFactory.this.platformManagedOAuthHandler, ConnectionProviderObjectFactory.this.properties, ConnectionProviderObjectFactory.this.extensionModel, ConnectionProviderObjectFactory.this.expressionManager, ConnectionProviderObjectFactory.this.muleContext));
            }
        });
        return (BaseConnectionProviderObjectBuilder)builder.get();
    }

    public void setPoolingProfile(PoolingProfile poolingProfile) {
        this.poolingProfile = poolingProfile;
    }

    public void setReconnectionConfig(ReconnectionConfig reconnectionConfig) {
        this.reconnectionConfig = reconnectionConfig;
    }
}

