/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl.parameter;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.dsl.api.component.AttributeDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.config.dsl.ExtensionParsingContext;
import org.mule.runtime.module.extension.internal.config.dsl.parameter.InlineParameterGroupObjectFactory;
import org.mule.runtime.module.extension.internal.config.dsl.parameter.ParameterGroupParser;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;

public class TypedInlineParameterGroupParser
extends ParameterGroupParser {
    private final ObjectType metadataType;
    private final Map<String, ParameterRole> parametersRole;

    public TypedInlineParameterGroupParser(ComponentBuildingDefinition.Builder definition, ParameterGroupModel group, ParameterGroupDescriptor groupDescriptor, ClassLoader classLoader, DslElementSyntax groupDsl, DslSyntaxResolver dslResolver, ExtensionParsingContext context) {
        super(definition, group, classLoader, groupDsl, dslResolver, context);
        MetadataType type = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(classLoader).load(groupDescriptor.getType().getDeclaringClass().get());
        Preconditions.checkArgument((boolean)MetadataTypeUtils.isObjectType(type), (Object)String.format("Only an ObjectType can be parsed as a TypedParameterGroup, found [%s] instead", type.getClass().getName()));
        this.metadataType = (ObjectType)type;
        this.parametersRole = group.getParameterModels().stream().collect(Collectors.toMap(NamedObject::getName, ParameterModel::getRole));
    }

    @Override
    protected ComponentBuildingDefinition.Builder doParse(ComponentBuildingDefinition.Builder definitionBuilder) throws ConfigurationException {
        ComponentBuildingDefinition.Builder<ValueResolver> finalBuilder = definitionBuilder.withIdentifier(this.name).withNamespace(this.namespace).asNamed().withTypeDefinition(TypeDefinition.fromType(ValueResolver.class)).withObjectFactoryType(InlineParameterGroupObjectFactory.class).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue(this.metadataType).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue(this.classLoader).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromReferenceObject(MuleContext.class).build());
        this.parseFields(this.metadataType, this.groupDsl, this.parametersRole);
        return finalBuilder;
    }
}

