/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.client.operation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.transaction.TransactionManager;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ComponentModelVisitor;
import org.mule.runtime.api.meta.model.ComponentVisibility;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.data.sample.SampleDataProviderModel;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.notification.NotificationModel;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.profiling.ProfilingDataProducer;
import org.mule.runtime.api.profiling.type.context.ComponentThreadingProfilingEventContext;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.streaming.object.CursorIterator;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.util.func.CheckedFunction;
import org.mule.runtime.core.internal.event.NullEventFactory;
import org.mule.runtime.core.internal.profiling.DummyComponentTracerFactory;
import org.mule.runtime.core.internal.streaming.CursorProviderDecorator;
import org.mule.runtime.core.internal.util.rx.ImmediateScheduler;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.runtime.DefaultExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.client.NullComponent;
import org.mule.runtime.module.extension.internal.runtime.client.operation.ComponentExecutorResolver;
import org.mule.runtime.module.extension.internal.runtime.client.operation.DefaultOperationParameterizer;
import org.mule.runtime.module.extension.internal.runtime.client.operation.OperationKey;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ExtensionConnectionSupplier;
import org.mule.runtime.module.extension.internal.runtime.operation.DefaultExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.operation.ExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.operation.ResultTransformer;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParametersResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.resolver.ValueResolverFactory;
import org.mule.runtime.module.extension.internal.runtime.result.ValueReturnDelegate;
import org.mule.runtime.module.extension.internal.util.InterceptorChainUtils;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.tracer.api.component.ComponentTracer;
import org.mule.runtime.tracer.api.component.ComponentTracerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationClient
implements Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationClient.class);
    private static final NullProfilingDataProducer NULL_PROFILING_DATA_PRODUCER = new NullProfilingDataProducer();
    private static final String PARAMS_PROPERTY_NAME = "parameterization";
    private static final BiFunction<ParameterGroupModel, ParameterModel, Object> NULL_PARAMS_FUNCTION = (g, p) -> null;
    private final ExtensionModel extensionModel;
    private final OperationModel operationModel;
    private final ExecutionMediator<OperationModel> mediator;
    private final CompletableComponentExecutor<OperationModel> executor;
    private final ValueReturnDelegate returnDelegate;
    private final StreamingManager streamingManager;
    private final ExtensionManager extensionManager;
    private final ExpressionManager expressionManager;
    private final ReflectionCache reflectionCache;
    private final MuleContext muleContext;
    private final ResolverSet resolverSet;
    private Optional<ConfigurationProvider> configurationProvider = null;
    private Map<String, ValueResolver<?>> absentParameterResolvers;

    public static OperationClient from(OperationKey key, ExtensionManager extensionManager, ExpressionManager expressionManager, ExtensionConnectionSupplier extensionConnectionSupplier, ErrorTypeRepository errorTypeRepository, StreamingManager streamingManager, ReflectionCache reflectionCache, ComponentTracerFactory<CoreEvent> componentTracerFactory, MuleContext muleContext, MuleConfiguration muleConfiguration, NotificationDispatcher notificationDispatcher, TransactionManager transactionManager) {
        return new OperationClient(key.getExtensionModel(), key.getOperationModel(), OperationClient.createExecutionMediator(key, extensionConnectionSupplier, errorTypeRepository, reflectionCache, componentTracerFactory, muleContext, muleConfiguration, notificationDispatcher, transactionManager), ComponentExecutorResolver.from(key, extensionManager, expressionManager, reflectionCache), new ValueReturnDelegate(key.getOperationModel(), muleContext), streamingManager, extensionManager, expressionManager, reflectionCache, muleContext);
    }

    private OperationClient(ExtensionModel extensionModel, OperationModel operationModel, ExecutionMediator<OperationModel> mediator, CompletableComponentExecutor<OperationModel> executor, ValueReturnDelegate returnDelegate, StreamingManager streamingManager, ExtensionManager extensionManager, ExpressionManager expressionManager, ReflectionCache reflectionCache, MuleContext muleContext) {
        this.extensionModel = extensionModel;
        this.operationModel = new FilteredOperationModel(operationModel);
        this.mediator = mediator;
        this.executor = executor;
        this.returnDelegate = returnDelegate;
        this.streamingManager = streamingManager;
        this.extensionManager = extensionManager;
        this.expressionManager = expressionManager;
        this.reflectionCache = reflectionCache;
        this.muleContext = muleContext;
        this.resolverSet = this.createResolverSet();
    }

    private ResolverSet createResolverSet() {
        ResolverSet resolverSet;
        ValueResolverFactory factory = new ValueResolverFactory(){

            @Override
            public Optional<ValueResolver> ofNullableParameter(BiFunction<ParameterGroupModel, ParameterModel, Object> params, final ParameterGroupModel parameterGroupModel, final ParameterModel parameterModel, final CheckedFunction<Object, ValueResolver> resolverFunction) {
                return Optional.of(new ValueResolver(){

                    public Object resolve(ValueResolvingContext context) throws MuleException {
                        ComponentParameterization parameterization = (ComponentParameterization)context.getProperty(OperationClient.PARAMS_PROPERTY_NAME);
                        Object value = parameterization.getParameter(parameterGroupModel, parameterModel);
                        ValueResolver delegate = value != null ? (ValueResolver)resolverFunction.apply(value) : (ValueResolver)OperationClient.this.absentParameterResolvers.get(IntrospectionUtils.getMemberName(parameterModel));
                        return delegate != null ? delegate.resolve(context) : null;
                    }

                    @Override
                    public boolean isDynamic() {
                        return true;
                    }
                });
            }
        };
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader extensionClassLoader = MuleExtensionUtils.getClassLoader(this.extensionModel);
        Thread.currentThread().setContextClassLoader(extensionClassLoader);
        try {
            resolverSet = ResolverSetUtils.getResolverSetFromParameters(this.operationModel, NULL_PARAMS_FUNCTION, this.muleContext, true, this.reflectionCache, this.expressionManager, "", factory);
            resolverSet.initialise();
            ResolverSet absentResolverSet = ParametersResolver.fromValues(Collections.emptyMap(), this.muleContext, true, this.reflectionCache, this.expressionManager, "").getParametersAsResolverSet(this.operationModel, this.muleContext);
            absentResolverSet.initialise();
            this.absentParameterResolvers = absentResolverSet.getResolvers();
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(e.getMessage()), (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
        }
        return resolverSet;
    }

    public <T, A> CompletableFuture<Result<T, A>> execute(OperationKey key, DefaultOperationParameterizer parameterizer) {
        boolean shouldCompleteEvent = false;
        CoreEvent contextEvent = parameterizer.getContextEvent().orElse(null);
        if (contextEvent == null) {
            contextEvent = NullEventFactory.getNullEvent(this.muleContext);
            shouldCompleteEvent = true;
        }
        OperationModel operationModel = key.getOperationModel();
        Optional<ConfigurationInstance> configurationInstance = this.getConfigurationInstance(key, contextEvent);
        Map<String, Object> resolvedParams = this.resolveOperationParameters(operationModel, configurationInstance, parameterizer, contextEvent);
        CursorProviderFactory cursorProviderFactory = parameterizer.getCursorProviderFactory(this.streamingManager);
        DefaultExecutionContext<OperationModel> context = new DefaultExecutionContext<OperationModel>(key.getExtensionModel(), configurationInstance, resolvedParams, operationModel, contextEvent, cursorProviderFactory, this.streamingManager, NullComponent.NULL_COMPONENT, parameterizer.getRetryPolicyTemplate(), ImmediateScheduler.IMMEDIATE_SCHEDULER, Optional.empty(), this.muleContext);
        return this.doExecute(context, shouldCompleteEvent);
    }

    private <T, A> CompletableFuture<Result<T, A>> doExecute(final ExecutionContextAdapter<OperationModel> ctx, final boolean shouldCompleteEvent) {
        final CompletableFuture<Result<T, A>> future = new CompletableFuture<Result<T, A>>();
        CompletableComponentExecutor.ExecutorCallback callback = new CompletableComponentExecutor.ExecutorCallback(){

            @Override
            public void complete(Object value) {
                EventCompletingValue result = OperationClient.this.asEventCompletingResult(value, ctx, shouldCompleteEvent);
                try {
                    future.complete((Result)result.value);
                }
                finally {
                    if (result.shouldCompleteEvent) {
                        ((BaseEventContext)ctx.getEvent().getContext()).success();
                    }
                }
            }

            @Override
            public void error(Throwable e) {
                if (!(e instanceof MessagingException)) {
                    e = new MessagingException(ctx.getEvent(), e);
                }
                try {
                    future.completeExceptionally(e);
                }
                finally {
                    if (shouldCompleteEvent) {
                        ((BaseEventContext)ctx.getEvent().getContext()).error(e);
                    }
                }
            }
        };
        this.mediator.execute(this.executor, ctx, callback);
        return future;
    }

    private Map<String, Object> resolveOperationParameters(OperationModel operationModel, Optional<ConfigurationInstance> configurationInstance, DefaultOperationParameterizer parameterizer, CoreEvent event) {
        ComponentParameterization.Builder<OperationModel> paramsBuilder = ComponentParameterization.builder(operationModel);
        parameterizer.setValuesOn(paramsBuilder);
        ValueResolvingContext.Builder ctxBuilder = ValueResolvingContext.builder(event).withProperty(PARAMS_PROPERTY_NAME, paramsBuilder.build()).acceptsNullValues(false);
        configurationInstance.ifPresent(ctxBuilder::withConfig);
        ValueResolvingContext ctx = ctxBuilder.build();
        try {
            Map<String, Object> map = this.resolverSet.resolve(ctx).asMap();
            if (ctx != null) {
                ctx.close();
            }
            return map;
        }
        catch (Throwable throwable) {
            try {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Exception found while evaluating parameters:" + e.getMessage()), (Throwable)e);
            }
        }
    }

    private <T, A> EventCompletingValue<Result<T, A>> asEventCompletingResult(Object value, ExecutionContextAdapter<OperationModel> context, boolean shouldCompleteEvent) {
        Message message = this.returnDelegate.asReturnValue(value, context).getMessage();
        TypedValue payload = message.getPayload();
        TypedValue attributes = message.getAttributes();
        EventCompletingValue<Object> completingPayload = this.asEventCompletingValue(payload.getValue(), context, shouldCompleteEvent);
        shouldCompleteEvent = shouldCompleteEvent && ((EventCompletingValue)completingPayload).shouldCompleteEvent;
        EventCompletingValue<Object> completingAttributes = this.asEventCompletingValue(attributes.getValue(), context, shouldCompleteEvent);
        shouldCompleteEvent = shouldCompleteEvent && ((EventCompletingValue)completingAttributes).shouldCompleteEvent;
        Result<Object, Object> result = Result.builder().output(((EventCompletingValue)completingPayload).value).mediaType(payload.getDataType().getMediaType()).attributes(((EventCompletingValue)completingAttributes).value).attributesMediaType(attributes.getDataType().getMediaType()).build();
        return new EventCompletingValue<Result<T, A>>(result, shouldCompleteEvent);
    }

    private EventCompletingValue<Object> asEventCompletingValue(Object value, ExecutionContextAdapter ctx, boolean shouldCompleteEvent) {
        if (shouldCompleteEvent) {
            if (value instanceof CursorIteratorProvider) {
                return new EventCompletingValue<Object>(new EventCompletingCursorIteratorProviderDecorator((CursorIteratorProvider)value, ctx.getEvent()), false);
            }
            if (value instanceof CursorStreamProvider) {
                return new EventCompletingValue<Object>(new EventCompletingCursorStreamProviderDecorator((CursorStreamProvider)value, ctx.getEvent()), false);
            }
        }
        return new EventCompletingValue<Object>(value, shouldCompleteEvent);
    }

    private Optional<ConfigurationInstance> getConfigurationInstance(OperationKey key, CoreEvent contextEvent) {
        return this.getConfigurationProvider(key, contextEvent).map(config -> config.get(contextEvent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<ConfigurationProvider> getConfigurationProvider(OperationKey key, CoreEvent contextEvent) {
        if (this.configurationProvider != null) {
            return this.configurationProvider;
        }
        OperationClient operationClient = this;
        synchronized (operationClient) {
            if (this.configurationProvider == null) {
                String configName = key.getConfigName();
                this.configurationProvider = configName != null ? Optional.of(this.extensionManager.getConfigurationProvider(configName).map(configurationProvider -> {
                    if (configurationProvider.getExtensionModel() != this.extensionModel) {
                        throw new IllegalArgumentException(String.format("A config of the '%s' extension was expected but one from '%s' was parameterized instead", this.extensionModel.getName(), configurationProvider.getExtensionModel().getName()));
                    }
                    return configurationProvider;
                }).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage("No configuration [" + configName + "] found")))) : this.extensionManager.getConfigurationProvider(this.extensionModel, this.operationModel, contextEvent);
            }
        }
        return this.configurationProvider;
    }

    @Override
    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.mediator, true, this.muleContext);
        LifecycleUtils.initialiseIfNeeded(this.executor, true, this.muleContext);
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.mediator);
        LifecycleUtils.startIfNeeded(this.executor);
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.mediator);
        LifecycleUtils.stopIfNeeded(this.executor);
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.mediator, LOGGER);
        LifecycleUtils.disposeIfNeeded(this.executor, LOGGER);
    }

    private static ExecutionMediator<OperationModel> createExecutionMediator(OperationKey key, ExtensionConnectionSupplier extensionConnectionSupplier, ErrorTypeRepository errorTypeRepository, ReflectionCache reflectionCache, ComponentTracerFactory<CoreEvent> componentTracerFactory, MuleContext muleContext, MuleConfiguration muleConfiguration, NotificationDispatcher notificationDispatcher, TransactionManager transactionManager) {
        ExtensionModel extensionModel = key.getExtensionModel();
        OperationModel operationModel = key.getOperationModel();
        DefaultExecutionMediator<OperationModel> mediator = new DefaultExecutionMediator<OperationModel>(extensionModel, operationModel, InterceptorChainUtils.createConnectionInterceptorsChain(extensionModel, operationModel, extensionConnectionSupplier, reflectionCache, DummyComponentTracerFactory.DUMMY_COMPONENT_TRACER_INSTANCE), errorTypeRepository, muleContext.getExecutionClassLoader(), muleConfiguration, notificationDispatcher, transactionManager, OperationClient.getResultTransformer(extensionConnectionSupplier, extensionModel, operationModel, componentTracerFactory), NULL_PROFILING_DATA_PRODUCER, OperationClient.getOperationConnectionTracer(componentTracerFactory), false);
        try {
            LifecycleUtils.initialiseIfNeeded(mediator, true, muleContext);
            LifecycleUtils.startIfNeeded(mediator);
            return mediator;
        }
        catch (MuleException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not create mediator for operation " + key), (Throwable)e);
        }
    }

    private static ComponentTracer<CoreEvent> getOperationConnectionTracer(ComponentTracerFactory<CoreEvent> componentTracerFactory) {
        return componentTracerFactory.fromComponent(NullComponent.NULL_COMPONENT, "mule:get-connection", "");
    }

    private static ResultTransformer getResultTransformer(ExtensionConnectionSupplier extensionConnectionSupplier, ExtensionModel extensionModel, OperationModel operationModel, ComponentTracerFactory<CoreEvent> componentTracerFactory) {
        return MuleExtensionUtils.getPagingResultTransformer(operationModel, extensionConnectionSupplier, MuleExtensionUtils.supportsOAuth(extensionModel), OperationClient.getOperationConnectionTracer(componentTracerFactory)).orElse(null);
    }

    private static class FilteredOperationModel
    implements OperationModel {
        private final OperationModel delegate;
        private final List<ParameterGroupModel> parameterGroupModels;
        private final List<ParameterModel> allParameters = new ArrayList<ParameterModel>(20);

        private FilteredOperationModel(OperationModel delegate) {
            this.delegate = delegate;
            this.parameterGroupModels = new ArrayList<ParameterGroupModel>(delegate.getParameterGroupModels().size());
            for (ParameterGroupModel group : delegate.getParameterGroupModels()) {
                String name = group.getName();
                if ("Output".equals(name) || "Error Mappings".equals(name)) continue;
                this.parameterGroupModels.add(group);
                this.allParameters.addAll(group.getParameterModels());
            }
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public ComponentVisibility getVisibility() {
            return this.delegate.getVisibility();
        }

        @Override
        public List<? extends NestableElementModel> getNestedComponents() {
            return this.delegate.getNestedComponents();
        }

        @Override
        public boolean isTransactional() {
            return this.delegate.isTransactional();
        }

        @Override
        public boolean requiresConnection() {
            return this.delegate.requiresConnection();
        }

        @Override
        public boolean supportsStreaming() {
            return this.delegate.supportsStreaming();
        }

        @Override
        public <T extends ModelProperty> Optional<T> getModelProperty(Class<T> propertyType) {
            return this.delegate.getModelProperty(propertyType);
        }

        @Override
        public Set<ModelProperty> getModelProperties() {
            return this.delegate.getModelProperties();
        }

        @Override
        public OutputModel getOutput() {
            return this.delegate.getOutput();
        }

        @Override
        public OutputModel getOutputAttributes() {
            return this.delegate.getOutputAttributes();
        }

        @Override
        public Optional<SampleDataProviderModel> getSampleDataProviderModel() {
            return this.delegate.getSampleDataProviderModel();
        }

        @Override
        public Set<String> getSemanticTerms() {
            return this.delegate.getSemanticTerms();
        }

        @Override
        public Optional<DeprecationModel> getDeprecationModel() {
            return this.delegate.getDeprecationModel();
        }

        @Override
        public boolean isDeprecated() {
            return this.delegate.isDeprecated();
        }

        @Override
        public Optional<DisplayModel> getDisplayModel() {
            return this.delegate.getDisplayModel();
        }

        @Override
        public Set<ErrorModel> getErrorModels() {
            return this.delegate.getErrorModels();
        }

        @Override
        public Set<NotificationModel> getNotificationModels() {
            return this.delegate.getNotificationModels();
        }

        @Override
        public boolean isBlocking() {
            return this.delegate.isBlocking();
        }

        @Override
        public ExecutionType getExecutionType() {
            return this.delegate.getExecutionType();
        }

        @Override
        public void accept(ComponentModelVisitor visitor) {
            this.delegate.accept(visitor);
        }

        @Override
        public List<ParameterGroupModel> getParameterGroupModels() {
            return this.parameterGroupModels;
        }

        @Override
        public List<ParameterModel> getAllParameterModels() {
            return this.allParameters;
        }

        @Override
        public StereotypeModel getStereotype() {
            return this.delegate.getStereotype();
        }

        @Override
        public Optional<MuleVersion> getMinMuleVersion() {
            return this.delegate.getMinMuleVersion();
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }
    }

    private static class NullProfilingDataProducer
    implements ProfilingDataProducer<ComponentThreadingProfilingEventContext, CoreEvent> {
        private NullProfilingDataProducer() {
        }

        @Override
        public void triggerProfilingEvent(ComponentThreadingProfilingEventContext profilerEventContext) {
        }

        @Override
        public void triggerProfilingEvent(CoreEvent sourceData, Function<CoreEvent, ComponentThreadingProfilingEventContext> transformation) {
        }
    }

    private static class EventCompletingValue<T> {
        private final T value;
        private final boolean shouldCompleteEvent;

        private EventCompletingValue(T value, boolean shouldCompleteEvent) {
            this.value = value;
            this.shouldCompleteEvent = shouldCompleteEvent;
        }
    }

    private static class EventCompletingCursorIteratorProviderDecorator
    extends EventCompletingCursorProviderDecorator<CursorIterator>
    implements CursorIteratorProvider {
        public EventCompletingCursorIteratorProviderDecorator(CursorIteratorProvider delegate, CoreEvent event) {
            super(delegate, event);
        }
    }

    private static class EventCompletingCursorStreamProviderDecorator
    extends EventCompletingCursorProviderDecorator<CursorStream>
    implements CursorStreamProvider {
        public EventCompletingCursorStreamProviderDecorator(CursorStreamProvider delegate, CoreEvent event) {
            super(delegate, event);
        }
    }

    private static abstract class EventCompletingCursorProviderDecorator<T extends Cursor>
    extends CursorProviderDecorator<T> {
        private final CoreEvent event;

        private EventCompletingCursorProviderDecorator(CursorProvider delegate, CoreEvent event) {
            super(delegate);
            this.event = event;
        }

        @Override
        public void close() {
            try {
                super.close();
            }
            finally {
                ((BaseEventContext)this.event.getContext()).success();
            }
        }
    }
}

