/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.privileged.resources.documentation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.mule.apache.xml.serialize.OutputFormat;
import org.mule.apache.xml.serialize.XMLSerializer;
import org.mule.runtime.module.extension.privileged.resources.documentation.XmlExtensionDocumentation;

public class ExtensionDescriptionsSerializer {
    public static final ExtensionDescriptionsSerializer SERIALIZER = new ExtensionDescriptionsSerializer();
    private JAXBContext jaxbContext;
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;

    private ExtensionDescriptionsSerializer() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ExtensionDescriptionsSerializer.class.getClassLoader());
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{XmlExtensionDocumentation.class});
            this.marshaller = this.jaxbContext.createMarshaller();
            this.unmarshaller = this.jaxbContext.createUnmarshaller();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    public synchronized String serialize(XmlExtensionDocumentation dto) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            this.marshaller.marshal((Object)dto, this.getXmlSerializer(out).asContentHandler());
            return out.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized XmlExtensionDocumentation deserialize(String xml) {
        try {
            return (XmlExtensionDocumentation)this.unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(xml.getBytes()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized XmlExtensionDocumentation deserialize(InputStream xml) {
        try {
            return (XmlExtensionDocumentation)this.unmarshaller.unmarshal(xml);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private XMLSerializer getXmlSerializer(OutputStream out) {
        OutputFormat of = new OutputFormat();
        of.setCDataElements(new String[]{"^description"});
        of.setIndenting(true);
        XMLSerializer serializer = new XMLSerializer(of);
        serializer.setOutputByteStream(out);
        return serializer;
    }

    public String getFileName(String extensionName) {
        String key = extensionName.replace(" ", "-").toLowerCase();
        return String.format("%s-extension-descriptions.xml", key);
    }
}

