/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.metadata;

import java.util.ServiceLoader;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.DataTypeBuilder;
import org.mule.runtime.api.util.classloader.MuleImplementationLoaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoExtend
public abstract class AbstractDataTypeBuilderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDataTypeBuilderFactory.class);
    private static final AbstractDataTypeBuilderFactory DEFAULT_FACTORY = AbstractDataTypeBuilderFactory.loadFactory();

    private static AbstractDataTypeBuilderFactory loadFactory() {
        try {
            AbstractDataTypeBuilderFactory factory = ServiceLoader.load(AbstractDataTypeBuilderFactory.class, MuleImplementationLoaderUtils.getMuleImplementationsLoader()).iterator().next();
            LOGGER.info(String.format("Loaded AbstractDataTypeBuilderFactory implementation '%s' from classloader '%s'", factory.getClass().getName(), factory.getClass().getClassLoader().toString()));
            return factory;
        }
        catch (Throwable t) {
            LOGGER.error("Error loading AbstractDataTypeBuilderFactory implementation.", t);
            throw t;
        }
    }

    static final AbstractDataTypeBuilderFactory getDefaultFactory() {
        if (MuleImplementationLoaderUtils.isResolveMuleImplementationLoadersDynamically()) {
            return AbstractDataTypeBuilderFactory.loadFactory();
        }
        return DEFAULT_FACTORY;
    }

    protected abstract DataTypeBuilder create();

    protected abstract DataTypeBuilder create(DataType var1);
}

