/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.visitor;

import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.internal.model.DefaultExtensionModelHelper;
import org.mule.runtime.ast.internal.serialization.dto.ComponentGenerationInformationDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentParameterAstDTO;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;

public class UnionTypesVisitor
extends MetadataTypeVisitor {
    private final ComponentParameterAstDTO componentParameterAstDTO;
    private final DefaultExtensionModelHelper extensionModelHelper;
    private final AtomicBoolean paramProcessed;

    public UnionTypesVisitor(ComponentParameterAstDTO componentParameterAstDTO, DefaultExtensionModelHelper extensionModelHelper, AtomicBoolean paramProcessed) {
        this.componentParameterAstDTO = componentParameterAstDTO;
        this.extensionModelHelper = extensionModelHelper;
        this.paramProcessed = paramProcessed;
    }

    @Override
    public void visitUnion(UnionType unionType) {
        unionType.getTypes().forEach(type -> {
            ComponentAst parameterValue = (ComponentAst)this.componentParameterAstDTO.getValue().getRight();
            if (parameterValue != null) {
                ComponentIdentifier parameterValueIdentifier = parameterValue.getIdentifier();
                this.extensionModelHelper.resolveDslElementModel((MetadataType)type, parameterValueIdentifier.getNamespace()).filter(resolveDslElementModel -> resolveDslElementModel.getElementName().equals(parameterValueIdentifier.getName())).ifPresent(resolveDslElementModel -> {
                    this.paramProcessed.set(true);
                    this.componentParameterAstDTO.setGenerationInformation(new ComponentGenerationInformationDTO((DslElementSyntax)resolveDslElementModel));
                });
            }
        });
    }
}

