/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.registry;

import java.util.Map;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.config.internal.DependencyGraphLifecycleObjectSorter;
import org.mule.runtime.config.internal.registry.AbstractSpringRegistry;
import org.mule.runtime.config.internal.registry.SpringRegistryBootstrap;
import org.mule.runtime.config.internal.resolvers.AutoDiscoveredDependencyResolver;
import org.mule.runtime.config.internal.resolvers.ConfigurationDependencyResolver;
import org.mule.runtime.config.internal.resolvers.DeclaredDependencyResolver;
import org.mule.runtime.config.internal.resolvers.DependencyGraphBeanDependencyResolver;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.Config;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.security.SecurityManager;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.util.queue.QueueManager;
import org.mule.runtime.core.internal.exception.GlobalErrorHandler;
import org.mule.runtime.core.internal.lifecycle.EmptyLifecycleCallback;
import org.mule.runtime.core.internal.lifecycle.LifecycleInterceptor;
import org.mule.runtime.core.internal.lifecycle.RegistryLifecycleCallback;
import org.mule.runtime.core.internal.lifecycle.RegistryLifecycleManager;
import org.mule.runtime.core.internal.lifecycle.phases.LifecycleObjectSorter;
import org.mule.runtime.core.internal.lifecycle.phases.MuleContextDisposePhase;
import org.mule.runtime.core.internal.lifecycle.phases.MuleContextInitialisePhase;
import org.mule.runtime.core.internal.lifecycle.phases.MuleContextStartPhase;
import org.mule.runtime.core.internal.lifecycle.phases.MuleContextStopPhase;
import org.mule.runtime.core.internal.lifecycle.phases.NotInLifecyclePhase;
import org.mule.runtime.core.internal.registry.Registry;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;

public class SpringRegistryLifecycleManager
extends RegistryLifecycleManager {
    public SpringRegistryLifecycleManager(String id, Registry springRegistry, MuleContext muleContext, LifecycleInterceptor lifecycleInterceptor) {
        super(id, springRegistry, muleContext, lifecycleInterceptor);
    }

    @Override
    protected void registerPhases(Registry registry) {
        RegistryLifecycleCallback callback = new RegistryLifecycleCallback(this);
        this.registerPhase("not in lifecycle", new NotInLifecyclePhase(), new EmptyLifecycleCallback());
        this.registerPhase("initialise", new SpringContextInitialisePhase(), callback);
        this.registerPhase("start", new MuleContextStartPhase(), callback);
        this.registerPhase("stop", new MuleContextStopPhase(), callback);
        this.registerPhase("dispose", new SpringContextDisposePhase(), callback);
    }

    @Override
    protected Map<String, Object> lookupObjectsForLifecycle() {
        if ("initialise".equals(this.getExecutingPhase())) {
            return this.getSpringRegistry().lookupEntriesForLifecycle(Object.class);
        }
        return this.getSpringRegistry().lookupEntriesForLifecycleIncludingAncestors(Object.class);
    }

    private boolean isNamedBean(String name) {
        return name != null && !name.startsWith("(inner bean)");
    }

    private AbstractSpringRegistry getSpringRegistry() {
        return (AbstractSpringRegistry)this.getLifecycleObject();
    }

    class SpringContextDisposePhase
    extends MuleContextDisposePhase {
        public SpringContextDisposePhase() {
            Class[] ignoredObjects = new Class[]{MuleContext.class, ServerNotificationManager.class, Service.class, GlobalErrorHandler.class};
            this.setIgnoredObjectTypes(ignoredObjects);
        }

        @Override
        public void applyLifecycle(Object o) throws LifecycleException {
            if (o instanceof AbstractSpringRegistry) {
                ((AbstractSpringRegistry)o).doDispose();
            } else if (o instanceof Transformer) {
                String name = ((Transformer)o).getName();
                if (SpringRegistryLifecycleManager.this.isNamedBean(name)) {
                    super.applyLifecycle(o);
                }
            } else {
                super.applyLifecycle(o);
            }
        }

        @Override
        public LifecycleObjectSorter newLifecycleObjectSorter() {
            AutoDiscoveredDependencyResolver autoDiscoveredDependencyResolver = new AutoDiscoveredDependencyResolver(SpringRegistryLifecycleManager.this.getSpringRegistry());
            DeclaredDependencyResolver declaredDependencyResolver = new DeclaredDependencyResolver(SpringRegistryLifecycleManager.this.getSpringRegistry());
            ConfigurationDependencyResolver configurationDependencyResolver = SpringRegistryLifecycleManager.this.getSpringRegistry().getConfigurationDependencyResolver();
            DependencyGraphBeanDependencyResolver dependencyGraphBeanDependencyResolver = new DependencyGraphBeanDependencyResolver(configurationDependencyResolver, declaredDependencyResolver, autoDiscoveredDependencyResolver, SpringRegistryLifecycleManager.this.getSpringRegistry());
            return new DependencyGraphLifecycleObjectSorter(dependencyGraphBeanDependencyResolver, this.orderedLifecycleTypes);
        }
    }

    class SpringContextInitialisePhase
    extends MuleContextInitialisePhase {
        public SpringContextInitialisePhase() {
            this.setOrderedLifecycleTypes(new Class[]{LockFactory.class, ObjectStoreManager.class, ExpressionLanguage.class, QueueManager.class, StreamingManager.class, ConfigurationProvider.class, Config.class, SecurityManager.class, FlowConstruct.class, MuleConfiguration.class, Initialisable.class});
            this.setIgnoredObjectTypes(new Class[]{ExtensionManager.class, AbstractSpringRegistry.class, SpringRegistryBootstrap.class, FlowExceptionHandler.class, MessageProcessorChain.class, MuleContext.class, Service.class});
        }

        @Override
        public void applyLifecycle(Object o) throws LifecycleException {
            try {
                o = ((MuleContext)SpringRegistryLifecycleManager.this.getMuleContext().get()).getInjector().inject(o);
            }
            catch (MuleException e) {
                throw new LifecycleException(e, o);
            }
            if (o instanceof Transformer) {
                String name = ((Transformer)o).getName();
                if (SpringRegistryLifecycleManager.this.isNamedBean(name)) {
                    super.applyLifecycle(o);
                }
            } else {
                super.applyLifecycle(o);
            }
        }

        @Override
        public LifecycleObjectSorter newLifecycleObjectSorter() {
            AutoDiscoveredDependencyResolver autoDiscoveredDependencyResolver = new AutoDiscoveredDependencyResolver(SpringRegistryLifecycleManager.this.getSpringRegistry());
            DeclaredDependencyResolver declaredDependencyResolver = new DeclaredDependencyResolver(SpringRegistryLifecycleManager.this.getSpringRegistry());
            ConfigurationDependencyResolver configurationDependencyResolver = SpringRegistryLifecycleManager.this.getSpringRegistry().getConfigurationDependencyResolver();
            DependencyGraphBeanDependencyResolver dependencyGraphBeanDependencyResolver = new DependencyGraphBeanDependencyResolver(configurationDependencyResolver, declaredDependencyResolver, autoDiscoveredDependencyResolver, SpringRegistryLifecycleManager.this.getSpringRegistry());
            return new DependencyGraphLifecycleObjectSorter(dependencyGraphBeanDependencyResolver, this.orderedLifecycleTypes);
        }
    }
}

