/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.transformer.AbstractTransformer;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.internal.registry.TransformerResolver;
import org.mule.runtime.core.internal.registry.TransformerWeighting;
import org.mule.runtime.core.internal.transformer.ResolverException;
import org.mule.runtime.core.internal.transformer.TransformerChain;
import org.mule.runtime.core.internal.transformer.TransformersRegistry;
import org.mule.runtime.core.internal.transformer.graph.GraphTransformerResolver;
import org.mule.runtime.core.internal.transformer.simple.ObjectToByteArray;
import org.mule.runtime.core.internal.transformer.simple.ObjectToString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeBasedTransformerResolver
implements TransformerResolver,
Disposable,
Initialisable {
    private static final Logger logger = LoggerFactory.getLogger(TypeBasedTransformerResolver.class);
    private ObjectToString objectToString;
    private ObjectToByteArray objectToByteArray;
    private TransformersRegistry transformersRegistry;
    protected Map<String, Transformer> exactTransformerCache = new ConcurrentHashMap<String, Transformer>(8);
    protected TransformerResolver graphTransformerResolver = new GraphTransformerResolver();

    @Override
    public void initialise() throws InitialisationException {
        this.objectToString = new ObjectToString();
        this.objectToByteArray = new ObjectToByteArray();
    }

    @Override
    public Transformer resolve(DataType source, DataType result) throws ResolverException {
        Transformer transformer = this.exactTransformerCache.get(source.toString() + result.toString());
        if (transformer != null) {
            return transformer;
        }
        List<Transformer> trans = this.transformersRegistry.lookupTransformers(source, result);
        Transformer compositeTransformer = this.graphTransformerResolver.resolve(source, result);
        if (compositeTransformer != null) {
            trans = new LinkedList<Transformer>(trans);
            trans.add(compositeTransformer);
        }
        if ((transformer = this.getNearestTransformerMatch(trans, source.getType(), result.getType())) == null) {
            AbstractTransformer secondPass;
            if (String.class.equals(result.getType())) {
                secondPass = this.objectToString;
            } else if (byte[].class.equals(result.getType())) {
                secondPass = this.objectToByteArray;
            } else {
                return null;
            }
            trans = this.transformersRegistry.lookupTransformers(source, DataType.OBJECT);
            transformer = this.getNearestTransformerMatch(trans, source.getType(), result.getType());
            if (transformer != null) {
                transformer = new TransformerChain(transformer, secondPass);
                try {
                    this.transformersRegistry.registerTransformer(transformer);
                }
                catch (MuleException e) {
                    throw new ResolverException(e.getI18nMessage(), (Throwable)e);
                }
            }
        }
        if (transformer != null) {
            this.exactTransformerCache.put(source.toString() + result.toString(), transformer);
        }
        return transformer;
    }

    protected Transformer getNearestTransformerMatch(List<Transformer> trans, Class input, Class output) throws ResolverException {
        if (trans.size() > 1) {
            if (logger.isDebugEnabled()) {
                logger.debug("Comparing transformers for best match: source = " + input + " target = " + output + " Possible transformers = " + trans);
            }
            List<TransformerWeighting> weightings = this.calculateTransformerWeightings(trans, input, output);
            TransformerWeighting maxWeighting = weightings.get(weightings.size() - 1);
            for (int index = weightings.size() - 2; index >= 0 && maxWeighting.compareTo(weightings.get(index)) == 0; --index) {
                TransformerWeighting current = weightings.get(index);
                if (maxWeighting.getTransformer().getClass().equals(current.getTransformer().getClass())) continue;
                List<Transformer> transformers = Arrays.asList(current.getTransformer(), maxWeighting.getTransformer());
                throw new ResolverException(CoreMessages.transformHasMultipleMatches(input, output, transformers));
            }
            return maxWeighting.getTransformer();
        }
        if (trans.size() == 0) {
            return null;
        }
        return trans.get(0);
    }

    private List<TransformerWeighting> calculateTransformerWeightings(List<Transformer> transformers, Class input, Class output) {
        ArrayList<TransformerWeighting> weightings = new ArrayList<TransformerWeighting>(transformers.size());
        for (Transformer transformer : transformers) {
            TransformerWeighting transformerWeighting = new TransformerWeighting(input, output, transformer);
            weightings.add(transformerWeighting);
        }
        Collections.sort(weightings);
        return weightings;
    }

    @Override
    public void dispose() {
        this.exactTransformerCache.clear();
    }

    @Override
    public void transformerChange(Transformer transformer, TransformerResolver.RegistryAction registryAction) {
        if (transformer instanceof Converter) {
            this.graphTransformerResolver.transformerChange(transformer, registryAction);
            this.exactTransformerCache.clear();
        }
    }

    @Inject
    public void setTransformersRegistry(TransformersRegistry transformersRegistry) {
        this.transformersRegistry = transformersRegistry;
    }
}

