/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.soap;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoapOutputPayload {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SoapOutputPayload.class.getName());
    private final TypedValue<InputStream> body;
    private final Map<String, TypedValue<InputStream>> attachments;
    private final Map<String, TypedValue<String>> headers;

    public SoapOutputPayload(TypedValue<InputStream> body, Map<String, TypedValue<InputStream>> attachments, Map<String, TypedValue<String>> headers) {
        this.body = body;
        this.attachments = attachments;
        this.headers = headers;
    }

    public TypedValue<InputStream> getBody() {
        return this.body;
    }

    public Map<String, TypedValue<InputStream>> getAttachments() {
        return this.attachments;
    }

    public Map<String, TypedValue<String>> getHeaders() {
        return this.headers;
    }

    public String toString() {
        try {
            String hs = this.headers.values().stream().map(v -> "\"" + (String)v.getValue() + "\"").collect(Collectors.joining(",\n  "));
            String as = String.join((CharSequence)", ", this.attachments.keySet());
            return "{\nbody:" + this.getBodyString() + ",\nheaders: [" + hs + "],\nattachments: [" + as + "]\n}";
        }
        catch (Exception e) {
            LOGGER.error("Error building SoapResponse string: " + e.getMessage(), (Throwable)e);
            return "Error building SoapResponse string";
        }
    }

    private String getBodyString() throws IOException {
        InputStream value = this.body.getValue();
        InputStream stream = null;
        if (value instanceof CursorStreamProvider) {
            stream = (InputStream)((CursorStreamProvider)((Object)value)).openCursor();
        } else if (value instanceof InputStream) {
            stream = value;
        }
        return stream != null ? IOUtils.toString((InputStream)stream, (Charset)this.getBodyCharset()) : value.toString();
    }

    private Charset getBodyCharset() {
        DataType dataType = this.body.getDataType();
        Charset defaultCharset = Charset.forName("UTF-8");
        return dataType != null ? dataType.getMediaType().getCharset().orElse(defaultCharset) : defaultCharset;
    }
}

