/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.event;

import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.event.BaseEventDecorator;
import org.mule.runtime.core.internal.event.InternalEvent;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;

public final class EventQuickCopy {
    private EventQuickCopy() {
    }

    public static CoreEvent quickCopy(EventContext context, CoreEvent event) {
        if (event instanceof EventQuickCopyContextDecorator && ((EventQuickCopyContextDecorator)event).getEvent().getContext() == context) {
            return ((EventQuickCopyContextDecorator)event).getEvent();
        }
        return event instanceof InternalEvent && context instanceof BaseEventContext ? new EventQuickCopyContextDecorator((BaseEventContext)context, (InternalEvent)event) : CoreEvent.builder(context, event).build();
    }

    public static PrivilegedEvent quickCopy(EventContext context, PrivilegedEvent event) {
        if (event instanceof EventQuickCopyContextDecorator && ((EventQuickCopyContextDecorator)event).getEvent().getContext() == context) {
            return ((EventQuickCopyContextDecorator)event).getEvent();
        }
        return event instanceof InternalEvent && context instanceof BaseEventContext ? new EventQuickCopyContextDecorator((BaseEventContext)context, (InternalEvent)event) : PrivilegedEvent.builder(context, event).build();
    }

    public static CoreEvent quickCopy(Error error, CoreEvent event) {
        if (event instanceof InternalEvent) {
            return new EventQuickCopyErrorDecorator(error, (InternalEvent)event);
        }
        return CoreEvent.builder(event).error(error).build();
    }

    public static InternalEvent quickCopy(CoreEvent event, Map<String, Object> internalParameters) {
        if (event instanceof EventQuickCopyInternalParametersDecorator) {
            EventQuickCopyInternalParametersDecorator quickCopy = (EventQuickCopyInternalParametersDecorator)event;
            Map<String, Object> resolvedParams = SmallMap.copy(quickCopy.internalParameters);
            resolvedParams.putAll(internalParameters);
            return EventQuickCopy.quickCopy(quickCopy.getEvent(), resolvedParams);
        }
        return event instanceof InternalEvent ? new EventQuickCopyInternalParametersDecorator((InternalEvent)event, internalParameters) : InternalEvent.builder(event).internalParameters(internalParameters).build();
    }

    private static class EventQuickCopyInternalParametersDecorator
    extends BaseEventDecorator {
        private static final long serialVersionUID = -8748877786435182694L;
        private final Map<String, ?> internalParameters;

        public EventQuickCopyInternalParametersDecorator(InternalEvent event, Map<String, Object> internalParameters) {
            super(event);
            this.internalParameters = internalParameters;
        }

        @Override
        public Map<String, ?> getInternalParameters() {
            Map<String, ?> eventInternalParameters = this.getEvent().getInternalParameters();
            if (eventInternalParameters.isEmpty()) {
                return this.internalParameters;
            }
            Map<String, ?> resolvedParams = SmallMap.copy(eventInternalParameters);
            resolvedParams.putAll(this.internalParameters);
            return resolvedParams;
        }

        @Override
        public <T> T getInternalParameter(String key) {
            Object outerValue = this.internalParameters.get(key);
            return (T)(outerValue != null ? outerValue : this.getEvent().getInternalParameter(key));
        }
    }

    private static class EventQuickCopyErrorDecorator
    extends BaseEventDecorator {
        private static final long serialVersionUID = 7605973213141261979L;
        private final Optional<Error> error;

        public EventQuickCopyErrorDecorator(Error error, InternalEvent event) {
            super(event);
            this.error = Optional.of(error);
        }

        @Override
        public Optional<Error> getError() {
            return this.error;
        }
    }

    private static class EventQuickCopyContextDecorator
    extends BaseEventDecorator {
        private static final long serialVersionUID = -2674520914985642327L;
        private final BaseEventContext context;

        public EventQuickCopyContextDecorator(BaseEventContext context, InternalEvent event) {
            super(event);
            this.context = context;
        }

        @Override
        public BaseEventContext getContext() {
            return this.context;
        }

        @Override
        public FlowCallStack getFlowCallStack() {
            return this.context.getFlowCallStack();
        }

        @Override
        public String getCorrelationId() {
            return this.getLegacyCorrelationId() != null ? this.getLegacyCorrelationId() : this.getContext().getCorrelationId();
        }
    }
}

