/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.lang.ref.Reference;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.notification.FlowStackElement;
import org.mule.runtime.core.api.context.notification.ServerNotificationHandler;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.BaseExceptionHandler;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.policy.OnExecuteNextErrorConsumer;
import org.mule.runtime.core.internal.policy.PolicyEventMapper;
import org.mule.runtime.core.internal.policy.PolicyNotificationHelper;
import org.mule.runtime.core.internal.policy.PolicyTraceLogger;
import org.mule.runtime.core.internal.policy.SourcePolicyContext;
import org.mule.runtime.core.privileged.event.DefaultFlowCallStack;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.tracer.api.component.ComponentTracerFactory;
import org.reactivestreams.Publisher;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class PolicyNextActionMessageProcessor
extends AbstractComponent
implements Processor,
Initialisable,
Disposable {
    public static final String EXECUTE_NEXT = "execute-next";
    static final String SOURCE_POLICY_PART_IDENTIFIER = "source";
    static final String SUBFLOW_POLICY_PART_IDENTIFIER = "sub-flow";
    public static final String POLICY_NEXT_OPERATION = "policy.nextOperation";
    public static final String POLICY_IS_PROPAGATE_MESSAGE_TRANSFORMATIONS = "policy.isPropagateMessageTransformations";
    @Inject
    private MuleContext muleContext;
    @Inject
    private ServerNotificationHandler notificationManager;
    @Inject
    private ComponentTracerFactory componentTracerFactory;
    private PolicyNotificationHelper notificationHelper;
    private PolicyEventMapper policyEventMapper;
    private final PolicyTraceLogger policyTraceLogger = new PolicyTraceLogger();
    private OnExecuteNextErrorConsumer onExecuteNextErrorConsumer;
    private MessageProcessorChain nextDispatchAsChain;
    private final Map<ComponentLocation, Boolean> locationsCache = new SmallMap<ComponentLocation, Boolean>();
    private final Map<Pair<ComponentLocation, String>, Boolean> subFlowLocationsCache = new SmallMap<Pair<ComponentLocation, String>, Boolean>();

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply(event, this);
    }

    @Override
    public void initialise() throws InitialisationException {
        this.policyEventMapper = new PolicyEventMapper(this.getPolicyId());
        this.notificationHelper = new PolicyNotificationHelper(this.notificationManager, this.getPolicyId(), this);
        this.onExecuteNextErrorConsumer = this.errorConsumer(this.policyEventMapper, this.notificationHelper);
        this.nextDispatchAsChain = MessageProcessors.buildNewChainWithListOfProcessors(Optional.empty(), Collections.singletonList(new Processor(){

            @Override
            public CoreEvent process(CoreEvent event) throws MuleException {
                return MessageProcessors.processToApply(event, this);
            }

            @Override
            public Publisher<CoreEvent> apply(Publisher<CoreEvent> eventPub) {
                return Flux.deferContextual(ctx -> Flux.from((Publisher)eventPub).map(event -> ctx.hasKey((Object)PolicyNextActionMessageProcessor.POLICY_IS_PROPAGATE_MESSAGE_TRANSFORMATIONS) ? PolicyNextActionMessageProcessor.this.policyEventMapper.onSourcePolicyNext((CoreEvent)event, (Boolean)ctx.get((Object)PolicyNextActionMessageProcessor.POLICY_IS_PROPAGATE_MESSAGE_TRANSFORMATIONS)) : PolicyNextActionMessageProcessor.this.policyEventMapper.onOperationPolicyNext((CoreEvent)event)).transform((Function)((ReactiveProcessor)((Reference)ctx.get((Object)PolicyNextActionMessageProcessor.POLICY_NEXT_OPERATION)).get())));
            }
        }), (FlowExceptionHandler)this.policyNextErrorHandler(), this.componentTracerFactory.fromComponent(this, "policy-next-action", ""));
        LifecycleUtils.initialiseIfNeeded(this.nextDispatchAsChain, this.muleContext);
    }

    private OnExecuteNextErrorConsumer errorConsumer(PolicyEventMapper policyEventMapper, PolicyNotificationHelper notificationHelper) {
        return new OnExecuteNextErrorConsumer(me -> {
            if (!this.isWithinSourcePolicy(this.getLocation()).booleanValue() && !this.isWithingSubflowInSourcePolicy(this.getLocation(), (MessagingException)me).booleanValue()) {
                return policyEventMapper.fromPolicyNext(me.getEvent());
            }
            CoreEvent event = me.getEvent();
            if (me.getFailingComponent() != null && (this.isWithinSourcePolicy(me.getFailingComponent().getLocation()).booleanValue() || this.isWithingSubflowInSourcePolicy(me.getFailingComponent().getLocation(), (MessagingException)me).booleanValue())) {
                return policyEventMapper.fromPolicyNext(event);
            }
            return policyEventMapper.fromPolicyNext(policyEventMapper.onFlowError(event, this.getPolicyId(), SourcePolicyContext.from(event).getParametersTransformer()));
        }, notificationHelper, this.getLocation());
    }

    private Boolean isWithinSourcePolicy(ComponentLocation location) {
        return this.locationsCache.computeIfAbsent(location, loc -> loc.getParts().size() >= 2 && loc.getParts().get(1).getPartIdentifier().map(tci -> tci.getIdentifier().getName().equals(SOURCE_POLICY_PART_IDENTIFIER)).orElse(false) != false);
    }

    private Boolean isWithingSubflowInSourcePolicy(ComponentLocation loc, MessagingException me) {
        List<FlowStackElement> elements = me.getEvent().getFlowCallStack().getElements();
        if (elements.size() == 0) {
            return false;
        }
        return this.subFlowLocationsCache.computeIfAbsent(new Pair<ComponentLocation, String>(loc, elements.get(0).getProcessorPath()), pair -> {
            if (((ComponentLocation)pair.getFirst()).getParts().size() < 1) {
                return false;
            }
            boolean isWithinSubflow = ((ComponentLocation)pair.getFirst()).getParts().get(0).getPartIdentifier().map(tci -> tci.getIdentifier().getName().equals(SUBFLOW_POLICY_PART_IDENTIFIER)).orElse(false);
            if (!isWithinSubflow) {
                return false;
            }
            return this.isSubflowWithinASoucePolicy(Location.builderFromStringRepresentation(((String)pair.getSecond()).split(" ")[0]).build());
        });
    }

    private boolean isSubflowWithinASoucePolicy(Location loc) {
        List<String> parts = loc.getParts();
        return loc.getGlobalName().equals(this.getRootContainerLocation().toString()) && parts.size() >= 1 && parts.get(0).equals(SOURCE_POLICY_PART_IDENTIFIER);
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return Flux.from(publisher).doOnNext(event -> this.policyTraceLogger.logBeforeExecuteNext(this.getPolicyId(), (CoreEvent)event)).doOnNext(event -> {
            PolicyNextActionMessageProcessor.popBeforeNextFlowFlowStackElement().accept((CoreEvent)event);
            this.notificationHelper.notification(2102).accept((CoreEvent)event);
        }).transformDeferred((Function)this.nextDispatchAsChain).doOnNext(coreEvent -> {
            this.notificationHelper.fireNotification((CoreEvent)coreEvent, null, 2103);
            this.pushAfterNextFlowStackElement().accept((CoreEvent)coreEvent);
        }).map(this.policyEventMapper::fromPolicyNext).doOnNext(event -> this.policyTraceLogger.logAfterExecuteNext(this.getPolicyId(), (CoreEvent)event));
    }

    private BaseExceptionHandler policyNextErrorHandler() {
        return new BaseExceptionHandler(){

            @Override
            public void onError(Exception error) {
                PolicyNextActionMessageProcessor.this.onExecuteNextErrorConsumer.accept(error);
            }

            public String toString() {
                return PolicyNextActionMessageProcessor.class.getSimpleName() + ".errorHandler @ " + PolicyNextActionMessageProcessor.this.getLocation().getLocation();
            }
        };
    }

    private Consumer<CoreEvent> pushAfterNextFlowStackElement() {
        return event -> ((DefaultFlowCallStack)event.getFlowCallStack()).push(new FlowStackElement(PolicyNextActionMessageProcessor.toPolicyLocation(this.getLocation()), null));
    }

    private static String toPolicyLocation(ComponentLocation componentLocation) {
        return componentLocation.getParts().get(0).getPartPath() + "/" + componentLocation.getParts().get(1).getPartPath() + "[after next]";
    }

    private static Consumer<CoreEvent> popBeforeNextFlowFlowStackElement() {
        return event -> ((DefaultFlowCallStack)event.getFlowCallStack()).pop();
    }

    private String getPolicyId() {
        return this.muleContext.getConfiguration().getId();
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.nextDispatchAsChain, LoggerFactory.getLogger(this.getClass()));
    }
}

