/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl.construct;

import com.google.common.base.Preconditions;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.dsl.api.component.AttributeDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.config.dsl.ExtensionDefinitionParser;
import org.mule.runtime.module.extension.internal.config.dsl.ExtensionParsingContext;
import org.mule.runtime.module.extension.internal.config.dsl.construct.RouteComponentObjectFactory;

public class RouteComponentParser
extends ExtensionDefinitionParser {
    private final ObjectType metadataType;
    private final ClassLoader classLoader;
    private final DslElementSyntax routeDsl;
    private final String name;
    private final String namespace;
    private final NestedRouteModel route;

    public RouteComponentParser(ComponentBuildingDefinition.Builder definition, NestedRouteModel route, MetadataType metadataType, ClassLoader classLoader, DslElementSyntax routeDsl, DslSyntaxResolver dslResolver, ExtensionParsingContext context) {
        super(definition, dslResolver, context);
        Preconditions.checkArgument((boolean)MetadataTypeUtils.isObjectType(metadataType), (Object)String.format("Only an ObjectType can be parsed as a TypedParameterGroup, found [%s] instead", metadataType.getClass().getName()));
        this.route = route;
        this.metadataType = (ObjectType)metadataType;
        this.classLoader = classLoader;
        this.routeDsl = routeDsl;
        this.name = routeDsl.getElementName();
        this.namespace = routeDsl.getPrefix();
    }

    @Override
    protected ComponentBuildingDefinition.Builder doParse(ComponentBuildingDefinition.Builder definitionBuilder) throws ConfigurationException {
        ComponentBuildingDefinition.Builder<ValueResolver> finalBuilder = definitionBuilder.withIdentifier(this.name).withNamespace(this.namespace).asNamed().withTypeDefinition(TypeDefinition.fromType(ValueResolver.class)).withObjectFactoryType(RouteComponentObjectFactory.class).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue(this.route).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue(this.metadataType).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue(this.classLoader).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromReferenceObject(MuleContext.class).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build());
        this.parseParameters(this.route.getAllParameterModels());
        return finalBuilder;
    }
}

