/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.error;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jgrapht.Graph;
import org.jgrapht.alg.cycle.CycleDetector;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultDirectedWeightedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.module.extension.internal.error.ErrorModelUtils;
import org.mule.runtime.module.extension.internal.error.ModuleErrors;
import org.mule.runtime.module.extension.internal.error.SdkErrorTypeDefinitionAdapter;
import org.mule.runtime.module.extension.internal.loader.parser.ErrorModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.error.JavaErrorModelParserUtils;
import org.mule.sdk.api.error.MuleErrors;

public class ErrorsModelFactory {
    private static final String MULE = "mule".toUpperCase();
    private final String extensionNamespace;
    private final Map<String, ErrorModel> errorModelMap;

    private static org.mule.sdk.api.error.ErrorTypeDefinition<?>[] adaptLegacyArray(ErrorTypeDefinition<?>[] errorTypesEnum) {
        return (org.mule.sdk.api.error.ErrorTypeDefinition[])Stream.of(errorTypesEnum).map(SdkErrorTypeDefinitionAdapter::from).toArray(org.mule.sdk.api.error.ErrorTypeDefinition[]::new);
    }

    private static List<ErrorModelParser> adaptToParsersArray(org.mule.sdk.api.error.ErrorTypeDefinition<?>[] errorTypesEnum, String extensionNamespace) {
        String errorExtensionNamespace = extensionNamespace.toUpperCase();
        return Stream.of(errorTypesEnum).map(def -> JavaErrorModelParserUtils.toParser(errorExtensionNamespace, def)).collect(Collectors.toList());
    }

    public ErrorsModelFactory(List<ErrorModelParser> extensionErrorParsers, String extensionNamespace) throws IllegalModelDefinitionException {
        this.extensionNamespace = extensionNamespace.toUpperCase();
        Graph<ErrorModelParser, DefaultEdge> graph = this.toGraph(extensionErrorParsers);
        this.errorModelMap = new HashMap<String, ErrorModel>();
        this.initErrorModelMap(this.errorModelMap);
        new TopologicalOrderIterator(graph).forEachRemaining(parser -> {
            ErrorModel errorModel = this.toErrorModel((ErrorModelParser)parser, this.errorModelMap);
            this.errorModelMap.put(errorModel.toString(), errorModel);
        });
        this.addConnectivityErrors(this.errorModelMap);
    }

    public ErrorsModelFactory(ErrorTypeDefinition<?>[] errorTypesEnum, String extensionNamespace) {
        this(ErrorsModelFactory.adaptLegacyArray(errorTypesEnum), extensionNamespace);
    }

    public ErrorsModelFactory(org.mule.sdk.api.error.ErrorTypeDefinition<?>[] errorTypesEnum, String extensionNamespace) {
        this(ErrorsModelFactory.adaptToParsersArray(errorTypesEnum, extensionNamespace), extensionNamespace);
    }

    public ErrorsModelFactory(String extensionNamespace) throws IllegalModelDefinitionException {
        this(Collections.emptyList(), extensionNamespace);
    }

    public Set<ErrorModel> getErrorModels() {
        TreeSet<ErrorModel> sortedErrorModels = new TreeSet<ErrorModel>((em1, em2) -> {
            int namespaceComparation = em1.getNamespace().compareTo(em2.getNamespace());
            if (namespaceComparation == 0) {
                return em1.getType().compareTo(em2.getType());
            }
            return namespaceComparation;
        });
        sortedErrorModels.addAll(this.errorModelMap.values());
        return sortedErrorModels;
    }

    public ErrorModel getErrorModel(ErrorModelParser errorModelParser) {
        String errorKey = this.toIdentifier(errorModelParser);
        if (this.errorModelMap.containsKey(errorKey)) {
            return this.errorModelMap.get(errorKey);
        }
        return this.toErrorModel(errorModelParser, this.errorModelMap);
    }

    private ErrorModel toErrorModel(ErrorModelParser errorModelParser, Map<String, ErrorModel> errorModelMap) {
        if (errorModelMap.containsKey(this.toIdentifier(errorModelParser))) {
            return errorModelMap.get(this.toIdentifier(errorModelParser));
        }
        ErrorModelBuilder builder = ErrorModelBuilder.newError(errorModelParser.getType(), errorModelParser.getNamespace());
        builder.withParent(this.toErrorModel(errorModelParser.getParent().orElse(null), errorModelMap));
        ErrorModel errorModel = builder.build();
        errorModelMap.put(this.toIdentifier(errorModelParser), errorModel);
        return errorModel;
    }

    private String toIdentifier(ErrorModelParser parser) {
        if (parser == null) {
            return this.toIdentifier(MuleErrors.ANY);
        }
        return parser.getNamespace() + ":" + parser.getType();
    }

    private String getErrorNamespace(org.mule.sdk.api.error.ErrorTypeDefinition<?> errorType) {
        return ErrorModelUtils.isMuleError(errorType) ? MULE : this.extensionNamespace;
    }

    private void detectCycleReferences(DefaultDirectedGraph<?, ?> graph) {
        CycleDetector cycleDetector = new CycleDetector(graph);
        if (cycleDetector.detectCycles()) {
            throw new IllegalModelDefinitionException("Cyclic Error Types reference detected, offending types: " + cycleDetector.findCycles());
        }
    }

    private void addConnectivityErrors(Map<String, ErrorModel> errorModelMap) {
        ErrorModel connectivityError = this.definitionToErrorModel(ModuleErrors.CONNECTIVITY, errorModelMap);
        String key = connectivityError.toString();
        errorModelMap.putIfAbsent(key, connectivityError);
        ErrorModel retryExhaustedError = this.definitionToErrorModel(ModuleErrors.RETRY_EXHAUSTED, errorModelMap);
        String retry = retryExhaustedError.toString();
        errorModelMap.putIfAbsent(retry, retryExhaustedError);
    }

    private ErrorModel definitionToErrorModel(org.mule.sdk.api.error.ErrorTypeDefinition<?> definition, Map<String, ErrorModel> errorModelMap) {
        if (errorModelMap.containsKey(this.toIdentifier(definition))) {
            return errorModelMap.get(this.toIdentifier(definition));
        }
        ErrorModelBuilder builder = ErrorModelBuilder.newError(definition.getType(), this.getErrorNamespace(definition));
        builder.withParent(this.definitionToErrorModel(definition.getParent().orElse(MuleErrors.ANY), errorModelMap));
        ErrorModel errorModel = builder.build();
        errorModelMap.put(this.toIdentifier(definition), errorModel);
        return errorModel;
    }

    private String toIdentifier(org.mule.sdk.api.error.ErrorTypeDefinition<?> errorTypeDefinition) {
        return this.getErrorNamespace(errorTypeDefinition) + ":" + errorTypeDefinition.getType();
    }

    private void initErrorModelMap(Map<String, ErrorModel> errorModelMap) {
        errorModelMap.put(this.toIdentifier(MuleErrors.ANY), ErrorModelBuilder.newError(MuleErrors.ANY.getType(), MULE).build());
    }

    private Graph<ErrorModelParser, DefaultEdge> toGraph(List<ErrorModelParser> extensionErrorParsers) {
        DefaultDirectedWeightedGraph graph = new DefaultDirectedWeightedGraph(DefaultEdge.class);
        extensionErrorParsers.forEach(arg_0 -> this.lambda$toGraph$4((DefaultDirectedGraph)graph, arg_0));
        this.detectCycleReferences((DefaultDirectedGraph<?, ?>)graph);
        return graph;
    }

    private void addType(ErrorModelParser parser, DefaultDirectedGraph<ErrorModelParser, DefaultEdge> graph) {
        graph.addVertex((Object)parser);
        String type = parser.getType();
        if (!MuleErrors.ANY.name().equals(type) && !MuleErrors.CRITICAL.name().equals(type)) {
            parser.getParent().ifPresent(parentErrorType -> {
                graph.addVertex(parentErrorType);
                graph.addEdge((Object)parser, parentErrorType);
            });
        }
    }

    private /* synthetic */ void lambda$toGraph$4(DefaultDirectedGraph graph, ErrorModelParser error) {
        this.addType(error, (DefaultDirectedGraph<ErrorModelParser, DefaultEdge>)graph);
    }
}

