/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracing.level.impl.config;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.model.dsl.ClassLoaderResourceProvider;
import org.mule.runtime.config.internal.model.dsl.config.DefaultConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.model.dsl.config.SystemPropertiesConfigurationProvider;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.module.observability.FileConfiguration;
import org.mule.runtime.tracer.common.watcher.TracingConfigurationFileWatcher;

public class YAMLConfiguration
extends FileConfiguration {
    private final List<Runnable> onConfigurationChangeRunnables;
    private final String configurationFilePath;
    private JsonNode configuration;
    private URL configurationUrl;
    private ConfigurationPropertiesResolver propertyResolver;
    private TracingConfigurationFileWatcher tracingConfigurationFileWatcher;
    private boolean tracingConfigurationFileWatcherInitialised;

    public YAMLConfiguration(MuleContext muleContext, List<Runnable> onConfigurationChangeRunnables, String configurationFilePath) {
        super(muleContext);
        this.onConfigurationChangeRunnables = onConfigurationChangeRunnables;
        this.configurationFilePath = configurationFilePath;
    }

    public void initialiseWatcher() {
        if (this.configuration != null && !this.tracingConfigurationFileWatcherInitialised) {
            this.tracingConfigurationFileWatcher = new TracingConfigurationFileWatcher(this.configurationUrl.getFile(), () -> this.onConfigurationChangeRunnables.forEach(Runnable::run));
            this.tracingConfigurationFileWatcher.start();
            this.tracingConfigurationFileWatcherInitialised = true;
        }
    }

    public void loadJSONConfiguration(ClassLoader classLoader) {
        this.loadJSONConfigurationFromFile(classLoader);
        this.loadPropertyResolver();
    }

    private void loadJSONConfigurationFromFile(ClassLoader classLoader) {
        ClassLoaderResourceProvider resourceProvider = new ClassLoaderResourceProvider(classLoader);
        try {
            InputStream is = resourceProvider.getResourceAsStream(this.configurationFilePath);
            this.configurationUrl = ClassUtils.getResourceOrFail(this.configurationFilePath, classLoader, true);
            this.configuration = YAMLConfiguration.loadConfiguration(is);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(e);
        }
    }

    private void loadPropertyResolver() {
        this.propertyResolver = new DefaultConfigurationPropertiesResolver(Optional.empty(), new SystemPropertiesConfigurationProvider());
    }

    public String getValue(String property) {
        return this.getStringValue(property);
    }

    public List<String> getStringListFromConfig(String key) {
        return this.readStringListFromConfig(key);
    }

    public void onConfigurationChange(Runnable runnable) {
        this.onConfigurationChangeRunnables.add(runnable);
    }

    public void dispose() {
        if (this.tracingConfigurationFileWatcher != null) {
            this.tracingConfigurationFileWatcher.interrupt();
        }
    }

    @Override
    protected boolean isAValueCorrespondingToAPath(String key) {
        return false;
    }

    @Override
    protected JsonNode getConfiguration() {
        return this.configuration;
    }

    @Override
    protected ConfigurationPropertiesResolver getPropertyResolver() {
        return this.propertyResolver;
    }
}

