/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.observability;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolver;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;

public abstract class FileConfiguration {
    private final MuleContext muleContext;
    private static final ObjectMapper configFileMapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public FileConfiguration(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public String getStringValue(String key) {
        String value = this.readStringFromConfigOrSystemProperty(key);
        if (value != null) {
            String absolutePath;
            value = this.getPropertyResolver().apply(value);
            if (this.isAValueCorrespondingToAPath(key) && (absolutePath = this.getAbsolutePath(value)) != null) {
                return absolutePath;
            }
        }
        return value;
    }

    private String readStringFromConfigOrSystemProperty(String key) {
        JsonNode configuration = this.getConfiguration();
        if (configuration != null) {
            String[] path = key.split("\\.");
            JsonNode configurationValue = configuration;
            for (int i = 0; i < path.length && configurationValue.get(path[i]) != null; ++i) {
                configurationValue = configurationValue.get(path[i]);
            }
            return configurationValue != null && !configurationValue.asText().isEmpty() ? configurationValue.asText() : null;
        }
        return System.getProperty(key);
    }

    protected List<String> readStringListFromConfig(String key) {
        JsonNode configuration = this.getConfiguration();
        ArrayList<String> configuredValues = new ArrayList<String>();
        if (configuration != null) {
            String[] path = key.split("\\.");
            JsonNode configurationValue = configuration;
            for (int i = 0; i < path.length && configurationValue != null; configurationValue = configurationValue.get(path[i]), ++i) {
            }
            if (configurationValue != null) {
                configurationValue.elements().forEachRemaining(jsonNode -> {
                    if (jsonNode.isTextual()) {
                        configuredValues.add(jsonNode.textValue());
                    }
                });
            }
        }
        return configuredValues;
    }

    protected abstract boolean isAValueCorrespondingToAPath(String var1);

    private String getAbsolutePath(String value) {
        Path path = Paths.get(value, new String[0]);
        try {
            URL url;
            if (!path.isAbsolute() && (url = this.getExecutionClassLoader(this.muleContext).getResource(value)) != null) {
                return new File(url.toURI()).getAbsolutePath();
            }
        }
        catch (URISyntaxException e) {
            return value;
        }
        return null;
    }

    protected ClassLoader getExecutionClassLoader(MuleContext muleContext) {
        return muleContext.getExecutionClassLoader();
    }

    protected static JsonNode loadConfiguration(InputStream is) throws IOException {
        if (is == null) {
            I18nMessage error = CoreMessages.objectIsNull("input stream");
            throw new IOException(error.toString());
        }
        try {
            JsonNode jsonNode = configFileMapper.readTree(is);
            return jsonNode;
        }
        finally {
            is.close();
        }
    }

    protected String getConfFolder() {
        return MuleFoldersUtil.getConfFolder().getAbsolutePath();
    }

    protected abstract JsonNode getConfiguration();

    protected abstract ConfigurationPropertiesResolver getPropertyResolver();
}

