/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.value;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.module.extension.api.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.loader.java.property.InjectableParameterInfo;
import org.mule.runtime.module.extension.internal.loader.java.property.ValueProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.util.InjectableParameterResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.module.extension.internal.value.SdkValueProviderAdapter;
import org.mule.sdk.api.values.ValueProvider;
import org.mule.sdk.api.values.ValueResolvingException;

public class ValueProviderFactory {
    private final ValueProviderFactoryModelProperty factoryModelProperty;
    private final ParameterValueResolver parameterValueResolver;
    private final Supplier<Object> connectionSupplier;
    private final Supplier<Object> configurationSupplier;
    private final Field connectionField;
    private final Field configField;
    private final ReflectionCache reflectionCache;
    private final MuleContext muleContext;
    private ExpressionManager expressionManager;
    private ParameterizedModel parameterizedModel;

    public ValueProviderFactory(ValueProviderFactoryModelProperty factoryModelProperty, ParameterValueResolver parameterValueResolver, Supplier<Object> connectionSupplier, Supplier<Object> configurationSupplier, Field connectionField, Field configField, ReflectionCache reflectionCache, MuleContext muleContext, ParameterizedModel parameterizedModel) {
        this.factoryModelProperty = factoryModelProperty;
        this.parameterValueResolver = parameterValueResolver;
        this.connectionSupplier = connectionSupplier;
        this.configurationSupplier = configurationSupplier;
        this.connectionField = connectionField;
        this.configField = configField;
        this.reflectionCache = reflectionCache;
        this.muleContext = muleContext;
        this.expressionManager = muleContext.getExpressionManager();
        this.parameterizedModel = parameterizedModel;
    }

    ValueProvider createValueProvider() throws ValueResolvingException {
        Class<?> resolverClass = this.factoryModelProperty.getValueProvider();
        try {
            Object resolver = ClassUtils.instantiateClass(resolverClass, new Object[0]);
            LifecycleUtils.initialiseIfNeeded(resolver, true, this.muleContext);
            InjectableParameterResolver injectableParameterResolver = new InjectableParameterResolver(this.parameterizedModel, this.parameterValueResolver, this.expressionManager, this.factoryModelProperty.getInjectableParameters());
            this.injectValueProviderFields(resolver, injectableParameterResolver);
            if (this.factoryModelProperty.usesConnection()) {
                Object connection;
                try {
                    connection = this.connectionSupplier.get();
                }
                catch (Exception e) {
                    throw new ValueResolvingException("Failed to establish connection: " + e.getMessage(), "CONNECTION_FAILURE", (Throwable)e);
                }
                if (connection == null) {
                    throw new ValueResolvingException("The value provider requires a connection and none was provided", "MISSING_REQUIRED_PARAMETERS");
                }
                IntrospectionUtils.setValueIntoField(resolver, connection, this.connectionField);
            }
            if (this.factoryModelProperty.usesConfig()) {
                Object config = this.configurationSupplier.get();
                if (config == null) {
                    throw new ValueResolvingException("The value provider requires a configuration and none was provided", "MISSING_REQUIRED_PARAMETERS");
                }
                IntrospectionUtils.setValueIntoField(resolver, config, this.configField);
            }
            return this.adaptResolver(resolver);
        }
        catch (ValueResolvingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ValueResolvingException("An error occurred trying to create a ValueProvider", "UNKNOWN", (Throwable)e);
        }
    }

    private void injectValueProviderFields(Object resolver, InjectableParameterResolver resolvedParameters) throws ValueResolvingException {
        ArrayList<String> missingParameters = new ArrayList<String>();
        for (InjectableParameterInfo injectableParam : this.factoryModelProperty.getInjectableParameters()) {
            Object parameterValue = resolvedParameters.getInjectableParameterValue(injectableParam.getParameterName());
            if (parameterValue != null) {
                IntrospectionUtils.setValueIntoField(resolver, parameterValue, injectableParam.getParameterName(), this.reflectionCache);
                continue;
            }
            if (!injectableParam.isRequired()) continue;
            if (injectableParam.getParameterName().equals(injectableParam.getExtractionExpression())) {
                missingParameters.add(injectableParam.getExtractionExpression());
                continue;
            }
            missingParameters.add(injectableParam.getParameterName() + "(taken from: " + injectableParam.getExtractionExpression() + ")");
        }
        if (!missingParameters.isEmpty()) {
            throw new ValueResolvingException("Unable to retrieve values. There are missing required parameters for the resolution: " + missingParameters, "MISSING_REQUIRED_PARAMETERS");
        }
    }

    private ValueProvider adaptResolver(Object resolverObject) throws ValueResolvingException {
        if (resolverObject instanceof ValueProvider) {
            return (ValueProvider)resolverObject;
        }
        if (resolverObject instanceof org.mule.runtime.extension.api.values.ValueProvider) {
            return new SdkValueProviderAdapter((org.mule.runtime.extension.api.values.ValueProvider)resolverObject);
        }
        throw new ValueResolvingException(String.format("An error occurred trying to create a ValueProvider: %s should implement %s or %s", resolverObject.getClass().getName(), ValueProvider.class.getName(), ValueProvider.class.getName()), "UNKNOWN");
    }
}

