/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.internal.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptorLoader;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfigurationLoader;
import org.mule.runtime.module.artifact.api.descriptor.DescriptorLoader;
import org.mule.runtime.module.artifact.api.descriptor.DescriptorLoaderRepository;
import org.mule.runtime.module.artifact.api.descriptor.LoaderNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRegistryDescriptorLoaderRepository
implements DescriptorLoaderRepository,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceRegistryDescriptorLoaderRepository.class);
    private final Function<Class<? extends DescriptorLoader>, Stream<? extends DescriptorLoader>> serviceRegistry;
    private final Class[] descriptorLoaderClasses = new Class[]{ClassLoaderConfigurationLoader.class, BundleDescriptorLoader.class};
    private Map<Class, List<DescriptorLoader>> descriptorLoaders;

    public ServiceRegistryDescriptorLoaderRepository() {
        this(descriptorLoaderClass -> StreamSupport.stream(((Iterable)() -> ServiceLoader.load(descriptorLoaderClass, ServiceRegistryDescriptorLoaderRepository.class.getClassLoader()).iterator()).spliterator(), false));
    }

    public ServiceRegistryDescriptorLoaderRepository(Function<Class<? extends DescriptorLoader>, Stream<? extends DescriptorLoader>> serviceRegistry) {
        Preconditions.checkArgument(serviceRegistry != null, "serviceRegistry cannot be null");
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public synchronized <T extends DescriptorLoader> T get(String id, ArtifactType artifactType, Class<T> loaderClass) throws LoaderNotFoundException {
        if (this.descriptorLoaders == null) {
            this.initializeDescriptorLoaders();
        }
        DescriptorLoader descriptorLoader = null;
        List<DescriptorLoader> registeredDescriptorLoaders = this.descriptorLoaders.get(loaderClass);
        if (registeredDescriptorLoaders != null) {
            for (DescriptorLoader loader : registeredDescriptorLoaders) {
                if (!loader.getId().equals(id) || !loader.supportsArtifactType(artifactType)) continue;
                descriptorLoader = loader;
            }
        }
        if (descriptorLoader == null) {
            throw new LoaderNotFoundException(ServiceRegistryDescriptorLoaderRepository.noRegisteredLoaderError(id, loaderClass));
        }
        return (T)descriptorLoader;
    }

    protected static <T extends DescriptorLoader> String noRegisteredLoaderError(String id, Class<T> loaderClass) {
        return String.format("There is no loader with ID='%s' and type '%s'", id, loaderClass.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeDescriptorLoaders() {
        ServiceRegistryDescriptorLoaderRepository serviceRegistryDescriptorLoaderRepository = this;
        synchronized (serviceRegistryDescriptorLoaderRepository) {
            if (this.descriptorLoaders == null) {
                this.descriptorLoaders = new HashMap<Class, List<DescriptorLoader>>();
                for (Class descriptorLoaderClass : this.descriptorLoaderClasses) {
                    this.descriptorLoaders.put(descriptorLoaderClass, this.findBundleDescriptorLoaders(descriptorLoaderClass));
                }
            }
        }
    }

    private List<DescriptorLoader> findBundleDescriptorLoaders(Class<? extends DescriptorLoader> descriptorLoaderClass) {
        return Collections.unmodifiableList(this.serviceRegistry.apply(descriptorLoaderClass).collect(Collectors.toList()));
    }

    @Override
    public void dispose() {
        this.descriptorLoaders.forEach((descriptorLoaderClass, descriptorLoaders) -> descriptorLoaders.forEach(descriptorLoader -> LifecycleUtils.disposeIfNeeded(descriptorLoader, LOGGER)));
    }
}

