/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.delegate;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.notification.NotificationModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.error.ErrorsModelFactory;
import org.mule.runtime.module.extension.internal.loader.delegate.ConfigModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.delegate.ConnectionProviderModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.delegate.FunctionModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.delegate.ModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.delegate.OperationModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.delegate.ParameterModelsLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.delegate.SourceModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.delegate.StereotypeModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.property.CompileTimeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.DevelopmentFrameworkModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.ExtensionModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ExtensionModelParserFactory;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParserFactory;
import org.mule.runtime.module.extension.internal.loader.utils.ExtensionNamespaceUtils;
import org.mule.runtime.module.extension.internal.loader.utils.ModelLoaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExtensionModelLoaderDelegate
implements ModelLoaderDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExtensionModelLoaderDelegate.class);
    protected final String version;
    private final ConfigModelLoaderDelegate configLoaderDelegate = new ConfigModelLoaderDelegate(this);
    private final OperationModelLoaderDelegate operationLoaderDelegate = new OperationModelLoaderDelegate(this);
    private final FunctionModelLoaderDelegate functionModelLoaderDelegate = new FunctionModelLoaderDelegate(this);
    private final SourceModelLoaderDelegate sourceModelLoaderDelegate = new SourceModelLoaderDelegate(this);
    private final ConnectionProviderModelLoaderDelegate connectionProviderModelLoaderDelegate = new ConnectionProviderModelLoaderDelegate(this);
    private final ParameterModelsLoaderDelegate parameterModelsLoaderDelegate = new ParameterModelsLoaderDelegate(this::getStereotypeModelLoaderDelegate, this::registerType);
    private final Map<String, NotificationModel> notificationModels = new LinkedHashMap<String, NotificationModel>();
    private StereotypeModelLoaderDelegate stereotypeModelLoaderDelegate;
    private Supplier<ErrorsModelFactory> errorsModelFactorySupplier;
    private ExtensionDeclarer declarer;
    private String namespace;

    public DefaultExtensionModelLoaderDelegate(String version) {
        this.version = version;
    }

    @Override
    @Deprecated
    public ExtensionDeclarer declare(ExtensionLoadingContext context) {
        return this.declare(new JavaExtensionModelParserFactory(), context);
    }

    @Override
    public ExtensionDeclarer declare(ExtensionModelParserFactory parserFactory, ExtensionLoadingContext context) {
        ExtensionModelParser parser = parserFactory.createParser(context);
        ExtensionDeclarer declarer = context.getExtensionDeclarer().named(parser.getName()).onVersion(this.version).supportingJavaVersions(parser.getSupportedJavaVersions()).fromVendor(parser.getVendor()).withCategory(parser.getCategory()).withModelProperty(parser.getLicenseModelProperty()).withXmlDsl(ModelLoaderUtils.getXmlDslModel(parser.getName(), this.version, parser.getXmlDslConfiguration()));
        context.getParameter("COMPILATION_MODE").ifPresent(m -> declarer.withModelProperty(new CompileTimeModelProperty()));
        declarer.withModelProperty(new DevelopmentFrameworkModelProperty(parser.getDevelopmentFramework()));
        parser.getArtifactLifecycleListenerModelProperty().ifPresent(declarer::withModelProperty);
        this.declarer = declarer;
        this.namespace = ExtensionNamespaceUtils.getExtensionsNamespace((ExtensionDeclaration)declarer.getDeclaration());
        this.stereotypeModelLoaderDelegate = new StereotypeModelLoaderDelegate(context);
        this.stereotypeModelLoaderDelegate.setNamespace(this.namespace);
        parser.getDeprecationModel().ifPresent(declarer::withDeprecation);
        parser.getExternalLibraryModels().forEach(declarer::withExternalLibrary);
        parser.getExtensionHandlerModelProperty().ifPresent(declarer::withModelProperty);
        parser.getAdditionalModelProperties().forEach(declarer::withModelProperty);
        if (parser.mustResolveMinMuleVersion()) {
            parser.getResolvedMinMuleVersion().ifPresent(resolvedMMV -> {
                declarer.withMinMuleVersion(resolvedMMV.getMinMuleVersion());
                LOGGER.debug(resolvedMMV.getReason());
            });
        }
        this.declareErrorModels(parser, declarer);
        this.declareExports(parser, declarer);
        this.declareImportedTypes(parser, declarer, context);
        this.declareSubTypes(parser, declarer, context);
        this.declareNotifications(parser, declarer);
        this.configLoaderDelegate.declareConfigurations(declarer, parser);
        this.connectionProviderModelLoaderDelegate.declareConnectionProviders(declarer, parser.getConnectionProviderModelParsers());
        this.operationLoaderDelegate.declareOperations(declarer, parser.getDevelopmentFramework(), declarer, parser.getOperationModelParsers());
        this.functionModelLoaderDelegate.declareFunctions(declarer, parser.getFunctionModelParsers());
        this.sourceModelLoaderDelegate.declareMessageSources(declarer, declarer, parser.getSourceModelParsers());
        this.getStereotypeModelLoaderDelegate().resolveDeclaredTypesStereotypes((ExtensionDeclaration)declarer.getDeclaration());
        return declarer;
    }

    private void declareNotifications(ExtensionModelParser parser, ExtensionDeclarer declarer) {
        parser.getNotificationModels().forEach(notification -> {
            declarer.withNotificationModel((NotificationModel)notification);
            this.registerType(notification.getType());
            this.notificationModels.put(notification.getIdentifier(), (NotificationModel)notification);
        });
    }

    private void declareErrorModels(ExtensionModelParser parser, ExtensionDeclarer declarer) {
        this.initErrorModelFactorySupplier(parser);
        ((ExtensionDeclaration)declarer.getDeclaration()).getErrorModels().addAll(this.createErrorModelFactory().getErrorModels());
    }

    private void declareExports(ExtensionModelParser parser, ExtensionDeclarer declarer) {
        parser.getExportedTypes().forEach(type -> this.registerExportedType(declarer, (MetadataType)type));
        parser.getExportedResources().forEach(declarer::withResource);
        parser.getPrivilegedExportedArtifacts().forEach(declarer::withPrivilegedArtifact);
        parser.getPrivilegedExportedPackages().forEach(declarer::withPrivilegedPackage);
    }

    private void declareImportedTypes(ExtensionModelParser parser, ExtensionDeclarer declarer, ExtensionLoadingContext context) {
        parser.getImportedTypes().forEach(importedType -> {
            Optional<String> typeId = MetadataTypeUtils.getTypeId(importedType);
            if (!(importedType instanceof ObjectType)) {
                Object[] objectArray = new Object[1];
                objectArray[0] = typeId.orElseGet(importedType::toString);
                throw new IllegalArgumentException(String.format("Type '%s' is not complex. Only complex types can be imported from other extensions.", objectArray));
            }
            declarer.withImportedType(new ImportedTypeModel(typeId.flatMap(importedTypeId -> context.getDslResolvingContext().getTypeCatalog().getType((String)importedTypeId)).orElse((ObjectType)importedType)));
        });
    }

    private void declareSubTypes(ExtensionModelParser parser, ExtensionDeclarer declarer, ExtensionLoadingContext context) {
        parser.getSubTypes().forEach((base, subTypes) -> {
            declarer.withSubTypes((MetadataType)base, (Collection<MetadataType>)subTypes);
            this.autoImportReferencedTypes(declarer, (MetadataType)base, context);
            subTypes.forEach(subTypeEntry -> this.autoImportReferencedTypes(declarer, (MetadataType)subTypeEntry, context));
            this.registerType((MetadataType)base);
            subTypes.forEach(sub -> this.registerType((MetadataType)sub));
        });
    }

    private void autoImportReferencedTypes(ExtensionDeclarer declarer, MetadataType subType, ExtensionLoadingContext loadingContext) {
        MetadataTypeUtils.getTypeId(subType).filter(imported -> ExtensionMetadataTypeUtils.getType(subType, loadingContext.getExtensionClassLoader()).map(clazz -> !clazz.getClassLoader().equals(loadingContext.getExtensionClassLoader())).orElse(true)).ifPresent(subTypeId -> loadingContext.getDslResolvingContext().getTypeCatalog().getType((String)subTypeId).map(ImportedTypeModel::new).ifPresent(declarer::withImportedType));
    }

    public void registerOutputTypes(ExecutableComponentDeclaration<?> declaration) {
        if (declaration.getOutput() == null) {
            throw new IllegalModelDefinitionException(String.format("%s '%s' doesn't specify an output type", NameUtils.getComponentDeclarationTypeName(declaration), declaration.getName()));
        }
        if (declaration.getOutputAttributes() == null) {
            throw new IllegalModelDefinitionException(String.format("%s '%s' doesn't specify output attributes types", NameUtils.getComponentDeclarationTypeName(declaration), declaration.getName()));
        }
        this.registerType(declaration.getOutput().getType());
        this.registerType(declaration.getOutputAttributes().getType());
    }

    public void registerType(MetadataType type) {
        ExtensionMetadataTypeUtils.registerType(this.declarer, type);
    }

    public Optional<NotificationModel> getNotificationModel(String identifier) {
        return Optional.ofNullable(this.notificationModels.get(identifier));
    }

    private void registerExportedType(final ExtensionDeclarer declarer, MetadataType type) {
        type.accept(new MetadataTypeVisitor(){

            @Override
            public void visitObject(ObjectType objectType) {
                if (objectType.isOpen()) {
                    objectType.getOpenRestriction().get().accept(this);
                } else {
                    declarer.withType(objectType);
                }
            }

            @Override
            public void visitArrayType(ArrayType arrayType) {
                arrayType.getType().accept(this);
            }

            @Override
            public void visitIntersection(IntersectionType intersectionType) {
                intersectionType.getTypes().forEach(type -> type.accept(this));
            }

            @Override
            public void visitUnion(UnionType unionType) {
                unionType.getTypes().forEach(type -> type.accept(this));
            }

            @Override
            public void visitObjectField(ObjectFieldType objectFieldType) {
                objectFieldType.getValue().accept(this);
            }
        });
    }

    private void initErrorModelFactorySupplier(ExtensionModelParser parser) {
        this.errorsModelFactorySupplier = () -> new ErrorsModelFactory(parser.getErrorModelParsers(), this.namespace);
    }

    OperationModelLoaderDelegate getOperationLoaderDelegate() {
        return this.operationLoaderDelegate;
    }

    FunctionModelLoaderDelegate getFunctionModelLoaderDelegate() {
        return this.functionModelLoaderDelegate;
    }

    SourceModelLoaderDelegate getSourceModelLoaderDelegate() {
        return this.sourceModelLoaderDelegate;
    }

    ConnectionProviderModelLoaderDelegate getConnectionProviderModelLoaderDelegate() {
        return this.connectionProviderModelLoaderDelegate;
    }

    StereotypeModelLoaderDelegate getStereotypeModelLoaderDelegate() {
        Preconditions.checkState(this.stereotypeModelLoaderDelegate != null, "stereotypeDelegate not yet initialized");
        return this.stereotypeModelLoaderDelegate;
    }

    ErrorsModelFactory createErrorModelFactory() {
        Preconditions.checkState(this.errorsModelFactorySupplier != null, "errorModelFactorySupplier not yet initialized");
        return this.errorsModelFactorySupplier.get();
    }

    public ParameterModelsLoaderDelegate getParameterModelsLoaderDelegate() {
        return this.parameterModelsLoaderDelegate;
    }
}

