/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;

public class AllComponentsBelongToSomeExtensionModel
implements Validation {
    @Override
    public String getName() {
        return "All components belong to some extension model";
    }

    @Override
    public String getDescription() {
        return "All components belong to some extension model";
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        return c -> true;
    }

    @Override
    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        if (component.getExtensionModel() == null) {
            return Optional.of(ValidationResultItem.create(component, (Validation)this, String.format("The component '%s' doesn't belong to any extension model", component.getIdentifier())));
        }
        return Optional.empty();
    }
}

