/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connectivity;

import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.connectivity.ConnectivityTestingService;
import org.mule.runtime.api.connectivity.ConnectivityTestingStrategy;
import org.mule.runtime.api.connectivity.UnsupportedConnectivityTestingObjectException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.ObjectNotFoundException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;

public class DefaultConnectivityTestingService
implements ConnectivityTestingService,
Initialisable {
    private Supplier<Stream<ConnectivityTestingStrategy>> serviceRegistry = () -> ConnectivityTestingStrategy.lookupConnectivityTestingStrategies(this.getClass().getClassLoader());
    private Collection<ConnectivityTestingStrategy> connectivityTestingStrategies;
    private MuleContext muleContext;
    private ConfigurationComponentLocator locator;

    protected void setServiceRegistry(Supplier<Stream<ConnectivityTestingStrategy>> serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Inject
    protected void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @Inject
    public void setLocator(ConfigurationComponentLocator locator) {
        this.locator = locator;
    }

    @Override
    public void initialise() throws InitialisationException {
        this.connectivityTestingStrategies = this.serviceRegistry.get().collect(Collectors.toList());
        for (ConnectivityTestingStrategy connectivityTestingStrategy : this.connectivityTestingStrategies) {
            try {
                this.muleContext.getInjector().inject(connectivityTestingStrategy);
            }
            catch (MuleException e) {
                throw new InitialisationException(I18nMessageFactory.createStaticMessage("Could not initialise connectivity testing strategy of type " + connectivityTestingStrategy.getClass().getName()), (Throwable)e, this);
            }
        }
    }

    @Override
    public ConnectionValidationResult testConnection(Location location) {
        Component connectivityTestingObject = this.locator.find(location).orElseThrow(() -> new ObjectNotFoundException("No object found with path: " + location));
        for (ConnectivityTestingStrategy connectivityTestingStrategy : this.connectivityTestingStrategies) {
            if (!connectivityTestingStrategy.accepts(connectivityTestingObject)) continue;
            try {
                return connectivityTestingStrategy.testConnectivity(connectivityTestingObject);
            }
            catch (Exception e) {
                return ConnectionValidationResult.failure(e.getMessage(), e);
            }
        }
        throw new UnsupportedConnectivityTestingObjectException(I18nMessageFactory.createStaticMessage("Could not do connectivity testing over object of type " + connectivityTestingObject.getClass().getName()));
    }
}

